/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.client.ui.basic.table;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.scout.rt.client.ui.basic.table.ITableRow;
import org.eclipse.scout.rt.client.ui.basic.table.columns.IColumn;
import org.eclipse.scout.rt.client.ui.basic.table.internal.HolderToRowMapper;
import org.eclipse.scout.rt.client.ui.basic.table.internal.RowToHolderMapper;
import org.eclipse.scout.rt.platform.holders.IHolder;

public class TableRowMapper {
    private final ITableRow m_row;
    private List<RowToHolderMapper> m_exportMappings;
    private List<HolderToRowMapper> m_importMappings;

    public TableRowMapper(ITableRow row) {
        this.m_row = row;
    }

    public ITableRow getRow() {
        return this.m_row;
    }

    public <T> void addMapping(IColumn<T> col, IHolder<T> holder) {
        this.addMapping(col, holder, true, true);
    }

    public <T> void addMapping(IColumn<T> col, IHolder<T> holder, boolean enableExport, boolean enableImport) {
        if (enableExport) {
            if (this.m_exportMappings == null) {
                this.m_exportMappings = new ArrayList<RowToHolderMapper>();
            }
            this.m_exportMappings.add(new RowToHolderMapper<T>(this.m_row, col, holder));
        }
        if (enableImport) {
            if (this.m_importMappings == null) {
                this.m_importMappings = new ArrayList<HolderToRowMapper>();
            }
            this.m_importMappings.add(new HolderToRowMapper<T>(this.m_row, col, holder));
        }
    }

    public void exportRowData() {
        if (this.m_exportMappings != null) {
            try {
                this.m_row.setRowChanging(true);
                for (RowToHolderMapper m : this.m_exportMappings) {
                    m.exportRowValue();
                }
            }
            finally {
                this.m_row.setRowChanging(false);
            }
        }
    }

    public void importRowData() {
        if (this.m_importMappings != null) {
            try {
                this.m_row.setRowChanging(true);
                for (HolderToRowMapper m : this.m_importMappings) {
                    m.importRowValue();
                }
            }
            finally {
                this.m_row.setRowChanging(false);
            }
        }
    }
}

