/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.client.ui.basic.table.columns;

import java.util.List;
import org.eclipse.scout.rt.client.extension.ui.basic.table.columns.IProposalColumnExtension;
import org.eclipse.scout.rt.client.ui.basic.cell.Cell;
import org.eclipse.scout.rt.client.ui.basic.table.ITableRow;
import org.eclipse.scout.rt.client.ui.basic.table.columns.AbstractSmartColumn;
import org.eclipse.scout.rt.client.ui.basic.table.columns.IProposalColumn;
import org.eclipse.scout.rt.client.ui.form.fields.IFormField;
import org.eclipse.scout.rt.client.ui.form.fields.smartfield.AbstractProposalField;
import org.eclipse.scout.rt.client.ui.form.fields.smartfield.IProposalField;
import org.eclipse.scout.rt.platform.BEANS;
import org.eclipse.scout.rt.platform.annotations.ConfigProperty;
import org.eclipse.scout.rt.platform.classid.ClassId;
import org.eclipse.scout.rt.platform.util.Assertions;
import org.eclipse.scout.rt.platform.util.StringUtility;
import org.eclipse.scout.rt.shared.services.common.code.ICodeType;
import org.eclipse.scout.rt.shared.services.lookup.ILookupCall;

@ClassId(value="7e21b24b-ddd8-4114-8b82-91dd396bf11b")
public abstract class AbstractProposalColumn<LOOKUP_TYPE>
extends AbstractSmartColumn<LOOKUP_TYPE>
implements IProposalColumn<LOOKUP_TYPE> {
    public AbstractProposalColumn() {
        this(true);
    }

    public AbstractProposalColumn(boolean callInitializer) {
        super(callInitializer);
    }

    @Override
    protected void initConfig() {
        super.initConfig();
        this.setMaxLength(this.getConfiguredMaxLength());
        this.setTrimText(this.getConfiguredTrimText());
    }

    @ConfigProperty(value="INTEGER")
    protected int getConfiguredMaxLength() {
        return 4000;
    }

    @ConfigProperty(value="BOOLEAN")
    protected boolean getConfiguredTrimText() {
        return true;
    }

    @Override
    public void setMaxLength(int maxLength) {
        this.propertySupport.setPropertyInt("maxLength", Math.max(0, maxLength));
    }

    @Override
    public int getMaxLength() {
        return this.propertySupport.getPropertyInt("maxLength");
    }

    @Override
    public void setTrimText(boolean b) {
        this.propertySupport.setPropertyBool("trimText", b);
    }

    @Override
    public boolean isTrimText() {
        return this.propertySupport.getPropertyBool("trimText");
    }

    @Override
    protected void updateDisplayTexts() {
        if (this.getTable() != null) {
            this.updateDisplayTexts(this.getTable().getRows());
        }
    }

    @Override
    public void updateDisplayTexts(List<ITableRow> rows) {
        for (ITableRow row : (List)Assertions.assertNotNull(rows)) {
            this.updateDisplayText(row, row.getCellForUpdate(this));
        }
    }

    @Override
    public void updateDisplayText(ITableRow row, Cell cell) {
        this.updateDisplayText(row, cell, (String)cell.getValue());
    }

    @Override
    public void updateDisplayText(ITableRow row, LOOKUP_TYPE value) {
        Cell cell = row.getCellForUpdate(this);
        this.updateDisplayText(row, cell, (String)value);
    }

    private void updateDisplayText(ITableRow row, Cell cell, String value) {
        cell.setText(this.formatValueInternal(row, (LOOKUP_TYPE)value));
    }

    @Override
    protected LOOKUP_TYPE parseValueInternal(ITableRow row, Object rawValue) {
        return (LOOKUP_TYPE)rawValue;
    }

    @Override
    protected void decorateCellInternal(Cell cell, ITableRow row) {
        super.decorateCellInternal(cell, row);
        this.updateDisplayText(row, cell);
    }

    @Override
    protected String formatValueInternal(ITableRow row, LOOKUP_TYPE value) {
        return (String)value;
    }

    @Override
    protected IFormField prepareEditInternal(ITableRow row) {
        ProposalField2Editor f = (ProposalField2Editor)this.getDefaultEditor();
        f.setRow(row);
        this.mapEditorFieldProperties(f);
        return f;
    }

    @Override
    protected void mapEditorFieldProperties(IProposalField<LOOKUP_TYPE> f) {
        super.mapEditorFieldProperties(f);
        f.setMaxLength(this.getMaxLength());
        f.setTrimText(this.isTrimText());
    }

    @Override
    protected ProposalField2Editor createDefaultEditor() {
        return new ProposalField2Editor();
    }

    @Override
    public int compareTableRows(ITableRow r1, ITableRow r2) {
        ILookupCall call;
        ICodeType codeType = this.getCodeTypeClass() != null ? (ICodeType)BEANS.opt(this.getCodeTypeClass()) : null;
        ILookupCall iLookupCall = call = this.getLookupCall() != null ? this.getLookupCall() : null;
        if (codeType != null) {
            String s1 = this.getDisplayText(r1);
            String s2 = this.getDisplayText(r2);
            return StringUtility.compareIgnoreCase((String)s1, (String)s2);
        }
        if (call != null) {
            String s1 = this.getDisplayText(r1);
            String s2 = this.getDisplayText(r2);
            return StringUtility.compareIgnoreCase((String)s1, (String)s2);
        }
        return super.compareTableRows(r1, r2);
    }

    @Override
    protected IProposalColumnExtension<LOOKUP_TYPE, ? extends AbstractProposalColumn<LOOKUP_TYPE>> createLocalExtension() {
        return new LocalProposalColumnExtension(this);
    }

    protected static class LocalProposalColumnExtension<LOOKUP_TYPE, OWNER extends AbstractProposalColumn<LOOKUP_TYPE>>
    extends AbstractSmartColumn.LocalSmartColumnExtension<LOOKUP_TYPE, OWNER>
    implements IProposalColumnExtension<LOOKUP_TYPE, OWNER> {
        public LocalProposalColumnExtension(OWNER owner) {
            super(owner);
        }
    }

    @ClassId(value="45103179-6dc2-47b1-9b77-790507533714")
    protected class ProposalField2Editor
    extends AbstractProposalField<LOOKUP_TYPE> {
        private ITableRow m_row;

        protected ProposalField2Editor() {
        }

        protected ITableRow getRow() {
            return this.m_row;
        }

        protected void setRow(ITableRow row) {
            this.m_row = row;
        }

        @Override
        protected void initConfig() {
            super.initConfig();
            this.propertySupport.putPropertiesMap(AbstractProposalColumn.this.propertySupport.getPropertiesMap());
        }

        @Override
        public Class<LOOKUP_TYPE> getHolderType() {
            return AbstractProposalColumn.this.getDataType();
        }

        @Override
        protected void execPrepareLookup(ILookupCall<LOOKUP_TYPE> call) {
            AbstractProposalColumn.this.interceptPrepareLookup(call, this.getRow());
        }
    }
}

