/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.client.ui.desktop.datachange;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.scout.rt.client.ui.desktop.datachange.DataChangeEvent;
import org.eclipse.scout.rt.client.ui.desktop.datachange.IDataChangeListener;
import org.eclipse.scout.rt.client.ui.desktop.datachange.IDataChangeManager;
import org.eclipse.scout.rt.platform.Bean;
import org.eclipse.scout.rt.platform.util.event.AbstractGroupedListenerList;

@Bean
public class DataChangeManager
extends AbstractGroupedListenerList<IDataChangeListener, DataChangeEvent, Object>
implements IDataChangeManager {
    private final List<DataChangeEvent> m_dataChangeEventBuffer = new ArrayList<DataChangeEvent>();
    private boolean m_buffering;

    @Override
    public void addAll(IDataChangeManager other) {
        super.addAll((AbstractGroupedListenerList)((DataChangeManager)other));
    }

    protected Set<Object> knownEventTypes() {
        return Collections.emptySet();
    }

    protected Object otherEventsType() {
        return null;
    }

    protected Object eventType(DataChangeEvent event) {
        return event.getDataType();
    }

    protected void handleEvent(IDataChangeListener listener, DataChangeEvent event) {
        listener.dataChanged(event);
    }

    public void fireEvents(List<DataChangeEvent> events) {
        if (this.isBuffering()) {
            this.m_dataChangeEventBuffer.addAll(events);
        } else {
            super.fireEvents(events);
        }
    }

    @Override
    public void fireEvent(DataChangeEvent event) {
        if (this.isBuffering()) {
            this.m_dataChangeEventBuffer.add(event);
        } else {
            super.fireEvent((Object)event);
        }
    }

    @Override
    public boolean isBuffering() {
        return this.m_buffering;
    }

    @Override
    public void setBuffering(boolean buffering) {
        if (buffering == this.m_buffering) {
            return;
        }
        this.m_buffering = buffering;
        if (!this.m_buffering) {
            this.processDataChangeBuffer();
        }
    }

    protected void processDataChangeBuffer() {
        if (this.m_dataChangeEventBuffer.isEmpty()) {
            return;
        }
        LinkedHashSet<DataChangeEvent> coalescedEvents = new LinkedHashSet<DataChangeEvent>(this.m_dataChangeEventBuffer);
        this.m_dataChangeEventBuffer.clear();
        for (DataChangeEvent event : coalescedEvents) {
            super.fireEvent((Object)event);
        }
    }
}

