/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.client.ui.desktop.outline;

import java.security.Permission;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.scout.rt.client.context.ClientRunContext;
import org.eclipse.scout.rt.client.context.ClientRunContexts;
import org.eclipse.scout.rt.client.extension.ui.basic.tree.ITreeExtension;
import org.eclipse.scout.rt.client.extension.ui.desktop.outline.IOutlineExtension;
import org.eclipse.scout.rt.client.extension.ui.desktop.outline.OutlineChains;
import org.eclipse.scout.rt.client.ui.AbstractEventBuffer;
import org.eclipse.scout.rt.client.ui.IWidget;
import org.eclipse.scout.rt.client.ui.action.menu.IMenu;
import org.eclipse.scout.rt.client.ui.action.menu.TableMenuType;
import org.eclipse.scout.rt.client.ui.action.menu.TreeMenuType;
import org.eclipse.scout.rt.client.ui.basic.table.ITable;
import org.eclipse.scout.rt.client.ui.basic.table.ITableRow;
import org.eclipse.scout.rt.client.ui.basic.tree.AbstractTree;
import org.eclipse.scout.rt.client.ui.basic.tree.ITree;
import org.eclipse.scout.rt.client.ui.basic.tree.ITreeNode;
import org.eclipse.scout.rt.client.ui.basic.tree.ITreeNodeFilter;
import org.eclipse.scout.rt.client.ui.basic.tree.TreeEvent;
import org.eclipse.scout.rt.client.ui.basic.tree.TreeListener;
import org.eclipse.scout.rt.client.ui.desktop.outline.DefaultPageChangeStrategy;
import org.eclipse.scout.rt.client.ui.desktop.outline.IOutline;
import org.eclipse.scout.rt.client.ui.desktop.outline.IPageChangeStrategy;
import org.eclipse.scout.rt.client.ui.desktop.outline.MenuWrapper;
import org.eclipse.scout.rt.client.ui.desktop.outline.OutlineEvent;
import org.eclipse.scout.rt.client.ui.desktop.outline.OutlineEventBuffer;
import org.eclipse.scout.rt.client.ui.desktop.outline.OutlineMediator;
import org.eclipse.scout.rt.client.ui.desktop.outline.OutlineMenuWrapper;
import org.eclipse.scout.rt.client.ui.desktop.outline.pages.AbstractPageWithNodes;
import org.eclipse.scout.rt.client.ui.desktop.outline.pages.IPage;
import org.eclipse.scout.rt.client.ui.desktop.outline.pages.IPageWithNodes;
import org.eclipse.scout.rt.client.ui.desktop.outline.pages.IPageWithTable;
import org.eclipse.scout.rt.client.ui.desktop.outline.pages.ISearchForm;
import org.eclipse.scout.rt.client.ui.dnd.TransferObject;
import org.eclipse.scout.rt.client.ui.form.IForm;
import org.eclipse.scout.rt.platform.BEANS;
import org.eclipse.scout.rt.platform.Order;
import org.eclipse.scout.rt.platform.annotations.ConfigOperation;
import org.eclipse.scout.rt.platform.annotations.ConfigProperty;
import org.eclipse.scout.rt.platform.classid.ClassId;
import org.eclipse.scout.rt.platform.exception.ExceptionHandler;
import org.eclipse.scout.rt.platform.exception.PlatformError;
import org.eclipse.scout.rt.platform.exception.ProcessingException;
import org.eclipse.scout.rt.platform.holders.Holder;
import org.eclipse.scout.rt.platform.reflect.ConfigurationUtility;
import org.eclipse.scout.rt.platform.util.CollectionUtility;
import org.eclipse.scout.rt.platform.util.concurrent.OptimisticLock;
import org.eclipse.scout.rt.platform.util.visitor.DepthFirstTreeVisitor;
import org.eclipse.scout.rt.platform.util.visitor.IDepthFirstTreeVisitor;
import org.eclipse.scout.rt.platform.util.visitor.TreeVisitResult;
import org.eclipse.scout.rt.security.ACCESS;
import org.eclipse.scout.rt.shared.data.basic.NamedBitMaskHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ClassId(value="fe822e40-23a0-4ec2-b2b0-6357df01d115")
public abstract class AbstractOutline
extends AbstractTree
implements IOutline {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractOutline.class);
    private static final NamedBitMaskHelper VISIBLE_BIT_HELPER = new NamedBitMaskHelper(new String[]{"VISIBLE", "VISIBLE_GRANTED"});
    private static final OutlineMenuWrapper.IMenuTypeMapper TABLE_MENU_TYPE_MAPPER = menuType -> {
        if (menuType == TableMenuType.EmptySpace || menuType == TableMenuType.SingleSelection) {
            return TreeMenuType.SingleSelection;
        }
        return menuType;
    };
    private byte m_visible;
    private IPage<?> m_contextPage;
    private IPageChangeStrategy m_pageChangeStrategy;
    private OptimisticLock m_contextPageOptimisticLock;
    private OutlineMediator m_outlineMediator;
    private List<IMenu> m_inheritedMenusOfPage;

    public AbstractOutline() {
    }

    public AbstractOutline(boolean callInitialzier) {
        super(callInitialzier);
    }

    @Override
    protected void initConfigInternal() {
        this.createDisplayParentRunContext().run(() -> AbstractOutline.super.initConfigInternal());
    }

    @Override
    public ClientRunContext createDisplayParentRunContext() {
        return ClientRunContexts.copyCurrent().withOutline(this, true);
    }

    @ConfigProperty(value="BOOLEAN")
    @Order(value=90.0)
    protected boolean getConfiguredVisible() {
        return true;
    }

    @ConfigProperty(value="DOUBLE")
    @Order(value=120.0)
    protected double getConfiguredViewOrder() {
        return 9.876543212345678E16;
    }

    @ConfigProperty(value="FORM")
    @Order(value=130.0)
    protected Class<? extends IForm> getConfiguredDefaultDetailForm() {
        return null;
    }

    protected boolean getConfiguredOutlineOverviewVisible() {
        return true;
    }

    @Override
    protected boolean getConfiguredToggleBreadcrumbStyleEnabled() {
        return true;
    }

    @Override
    @Order(value=150.0)
    protected String getConfiguredIconId() {
        return "font:\ue02b";
    }

    @ConfigProperty(value="BOOLEAN")
    @Order(value=160.0)
    protected boolean getConfiguredNavigateButtonsVisible() {
        return true;
    }

    @ConfigOperation
    @Order(value=85.0)
    protected IPage<?> execCreateRootPage() {
        return new InvisibleRootPage();
    }

    @ConfigOperation
    @Order(value=90.0)
    protected void execCreateChildPages(List<IPage<?>> pageList) {
    }

    protected void createChildPagesInternal(List<IPage<?>> pageList) {
        this.interceptCreateChildPages(pageList);
    }

    @Override
    protected void execDrop(ITreeNode node, TransferObject t) {
        Object table;
        if (node instanceof IPageWithTable && (table = ((IPage)node).getTable()).getDropType() != 0) {
            table.getUIFacade().fireRowDropActionFromUI(null, t);
        }
    }

    @Order(value=120.0)
    @ConfigOperation
    protected void execInitDefaultDetailForm() {
    }

    @Order(value=130.0)
    @ConfigOperation
    protected void execActivated() {
    }

    @Order(value=130.0)
    @ConfigOperation
    protected void execDeactivated() {
    }

    @Override
    protected void initConfig() {
        this.m_visible = (byte)-1;
        this.m_contextPageOptimisticLock = new OptimisticLock();
        this.setPageChangeStrategy(this.createPageChangeStrategy());
        this.m_outlineMediator = this.createOutlineMediator();
        this.addTreeListener(this.createLocalTreeListener(), new Integer[]{705, 730, 740, 50, 30, 10, 20, 870});
        this.addNodeFilter(new P_TableFilterBasedTreeNodeFilter());
        super.initConfig();
        IPage<?> rootPage = this.interceptCreateRootPage();
        this.setRootNode(rootPage);
        this.setVisible(this.getConfiguredVisible());
        this.setOrder(this.calculateViewOrder());
        this.setNavigateButtonsVisible(this.getConfiguredNavigateButtonsVisible());
        this.setOutlineOverviewVisible(this.getConfiguredOutlineOverviewVisible());
        this.ensureDefaultDetailFormCreated();
        this.ensureDefaultDetailFormStarted();
    }

    @Override
    public AbstractEventBuffer<TreeEvent> createEventBuffer() {
        return (AbstractEventBuffer)BEANS.get(OutlineEventBuffer.class);
    }

    @Override
    public IPage<?> getActivePage() {
        return (IPage)this.getSelectedNode();
    }

    protected double calculateViewOrder() {
        double viewOrder = this.getConfiguredViewOrder();
        if (viewOrder == 9.876543212345678E16) {
            Class<?> cls = this.getClass();
            while (cls != null && IOutline.class.isAssignableFrom(cls)) {
                if (cls.isAnnotationPresent(Order.class)) {
                    Order order = cls.getAnnotation(Order.class);
                    return order.value();
                }
                cls = cls.getSuperclass();
            }
        }
        return viewOrder;
    }

    @Override
    public void refreshPages(Class<?> ... pageTypes) {
        if (pageTypes == null || pageTypes.length < 1) {
            return;
        }
        ArrayList list = new ArrayList(pageTypes.length);
        Class<?>[] classArray = pageTypes;
        int n = pageTypes.length;
        int n2 = 0;
        while (n2 < n) {
            Class<?> c = classArray[n2];
            if (IPage.class.isAssignableFrom(c)) {
                list.add(c);
            }
            ++n2;
        }
        this.refreshPages(list);
    }

    @Override
    public void refreshPages(final List<Class<? extends IPage<?>>> pageTypes) {
        final ArrayList candidates = new ArrayList();
        DepthFirstTreeVisitor<ITreeNode> v = new DepthFirstTreeVisitor<ITreeNode>(){

            public TreeVisitResult preVisit(ITreeNode element, int level, int index) {
                IPage page = (IPage)element;
                Class<?> pageClass = page.getClass();
                for (Class c : pageTypes) {
                    if (!c.isAssignableFrom(pageClass)) continue;
                    candidates.add(page);
                }
                return TreeVisitResult.CONTINUE;
            }
        };
        this.visitNode(this.getRootNode(), (IDepthFirstTreeVisitor<ITreeNode>)v);
        for (IPage page : candidates) {
            if (page.getTree() == null) continue;
            page.dataChanged(new Object[0]);
        }
    }

    @Override
    public void releaseUnusedPages() {
        block8: {
            final HashSet preservationSet = new HashSet();
            IPage<?> oldSelection = (IPage<?>)this.getSelectedNode();
            IPage<?> p = oldSelection;
            if (p != null) {
                while (p != null) {
                    preservationSet.add(p);
                    p = p.getParentPage();
                }
            }
            DepthFirstTreeVisitor<ITreeNode> v = new DepthFirstTreeVisitor<ITreeNode>(){

                public TreeVisitResult preVisit(ITreeNode element, int level, int index) {
                    IPage page = (IPage)element;
                    if (!(preservationSet.contains(page) || !page.isChildrenLoaded() || page.isExpanded() && page.getParentPage() != null && page.getParentPage().isChildrenLoaded())) {
                        try {
                            AbstractOutline.this.unloadNode(page);
                        }
                        catch (RuntimeException | PlatformError e) {
                            ((ExceptionHandler)BEANS.get(ExceptionHandler.class)).handle(e);
                        }
                    }
                    return TreeVisitResult.CONTINUE;
                }
            };
            try {
                IPage selectedPage;
                this.setTreeChanging(true);
                this.visitNode(this.getRootNode(), (IDepthFirstTreeVisitor<ITreeNode>)v);
                if (oldSelection == null || (selectedPage = (IPage)this.getSelectedNode()) != null) break block8;
                try {
                    this.getRootNode().ensureChildrenLoaded();
                    List<ITreeNode> children = this.getRootNode().getFilteredChildNodes();
                    if (CollectionUtility.hasElements(children)) {
                        this.selectNode((ITreeNode)CollectionUtility.firstElement(children));
                    }
                }
                catch (RuntimeException | PlatformError e) {
                    LOG.warn("Exception while selecting first page in outline [{}]", (Object)this.getClass().getName(), (Object)e);
                }
            }
            finally {
                this.setTreeChanging(false);
            }
        }
    }

    @Override
    public <T extends IPage> T findPage(Class<T> pageType) {
        return this.findPage(pageType, this.getRootPage());
    }

    @Override
    public <T extends IPage> T findPage(final Class<T> pageType, IPage rootPage) {
        final Holder result = new Holder(pageType, null);
        DepthFirstTreeVisitor<ITreeNode> v = new DepthFirstTreeVisitor<ITreeNode>(){

            public TreeVisitResult preVisit(ITreeNode element, int level, int index) {
                IPage page = (IPage)element;
                Class<?> pageClass = page.getClass();
                if (pageType.isAssignableFrom(pageClass)) {
                    result.setValue((Object)page);
                    return TreeVisitResult.TERMINATE;
                }
                return TreeVisitResult.CONTINUE;
            }
        };
        this.visitNode(rootPage, (IDepthFirstTreeVisitor<ITreeNode>)v);
        return (T)((IPage)result.getValue());
    }

    @Override
    public void setVisiblePermission(Permission p) {
        boolean b = true;
        if (p != null) {
            b = ACCESS.check((Permission)p);
        }
        this.setVisibleGranted(b);
    }

    @Override
    public boolean isVisibleGranted() {
        return this.isVisible("VISIBLE_GRANTED");
    }

    @Override
    public void setVisibleGranted(boolean visible) {
        this.setVisible(visible, "VISIBLE_GRANTED");
    }

    @Override
    public boolean isVisible() {
        return this.propertySupport.getPropertyBool("visible");
    }

    @Override
    public void setVisible(boolean visible) {
        this.setVisible(visible, "VISIBLE");
    }

    private void calculateVisible() {
        this.propertySupport.setPropertyBool("visible", NamedBitMaskHelper.allBitsSet((byte)this.m_visible));
    }

    public void setVisible(boolean visible, String dimension) {
        this.m_visible = VISIBLE_BIT_HELPER.changeBit(dimension, visible, this.m_visible);
        this.calculateVisible();
    }

    public boolean isVisible(String dimension) {
        return VISIBLE_BIT_HELPER.isBitSet(dimension, this.m_visible);
    }

    @Override
    public boolean isNavigateButtonsVisible() {
        return this.propertySupport.getPropertyBool("navigateButtonsVisible");
    }

    @Override
    public void setNavigateButtonsVisible(boolean b) {
        this.propertySupport.setPropertyBool("navigateButtonsVisible", b);
    }

    @Override
    public IForm getDefaultDetailForm() {
        return (IForm)this.propertySupport.getProperty("defaultDetailForm");
    }

    protected void setDefaultDetailFormInternal(IForm form) {
        this.propertySupport.setProperty("defaultDetailForm", (Object)form);
    }

    @Override
    public IForm getDetailForm() {
        return (IForm)this.propertySupport.getProperty("detailForm");
    }

    @Override
    public void setDetailForm(IForm form) {
        this.propertySupport.setProperty("detailForm", (Object)form);
    }

    @Override
    public void setOutlineOverviewVisible(boolean visible) {
        this.propertySupport.setPropertyBool("outlineOverviewVisible", visible);
    }

    @Override
    public boolean isOutlineOverviewVisible() {
        return this.propertySupport.getPropertyBool("outlineOverviewVisible");
    }

    @Override
    public ITable getDetailTable() {
        return (ITable)this.propertySupport.getProperty("detailTable");
    }

    @Override
    public void setDetailTable(ITable table) {
        this.propertySupport.setProperty("detailTable", (Object)table);
    }

    @Override
    public IForm getSearchForm() {
        return (IForm)this.propertySupport.getProperty("searchForm");
    }

    @Override
    public void setSearchForm(IForm form) {
        this.propertySupport.setProperty("searchForm", (Object)form);
    }

    public double getOrder() {
        return this.propertySupport.getPropertyDouble("order");
    }

    public void setOrder(double order) {
        this.propertySupport.setPropertyDouble("order", order);
    }

    @Override
    public IPage<?> getRootPage() {
        return (IPage)this.getRootNode();
    }

    @Override
    public void unloadNode(ITreeNode node) {
        this.setTreeChanging(true);
        try {
            Object table;
            super.unloadNode(node);
            if (node instanceof IPage && (table = ((IPage)node).getTable(false)) != null) {
                table.deleteAllRows();
            }
        }
        finally {
            this.setTreeChanging(false);
        }
    }

    @Override
    public void resetOutline() {
        this.resetOutline(true);
    }

    @Override
    public void resetOutline(boolean selectFirstNode) {
        ITreeNode rootNode = this.getRootNode();
        if (rootNode == null) {
            return;
        }
        this.createDisplayParentRunContext().run(() -> {
            ITreeNode selectedNode;
            ISearchForm searchForm;
            this.setTreeChanging(true);
            try {
                this.selectNode(null);
                this.unloadNode(rootNode);
                rootNode.ensureChildrenLoaded();
            }
            finally {
                this.setTreeChanging(false);
            }
            if (rootNode instanceof IPageWithTable && (searchForm = ((IPageWithTable)rootNode).getSearchFormInternal()) != null) {
                searchForm.doReset();
            }
            if (!this.isRootNodeVisible()) {
                rootNode.setExpanded(true);
            }
            if (selectFirstNode && (selectedNode = this.selectFirstNode()) instanceof IPageWithTable) {
                selectedNode.setExpanded(true);
            }
        });
    }

    @Override
    public void makeActivePageToContextPage() {
        IPage<?> activePage = this.getActivePage();
        if (activePage != null && this.m_contextPage != activePage) {
            this.m_contextPage = activePage;
            this.addMenusOfActivePageToContextMenu(activePage);
            activePage.pageActivatedNotify();
        }
    }

    @Override
    public List<IMenu> getMenusForPage(IPage<?> page) {
        List pageMenus = page.getMenus();
        List<IMenu> inheritedMenus = this.computeInheritedMenusOfPage(page);
        ArrayList<IMenu> result = new ArrayList<IMenu>(pageMenus.size() + inheritedMenus.size());
        result.addAll(pageMenus);
        result.addAll(inheritedMenus);
        return result;
    }

    @Override
    public List<? extends IWidget> getChildren() {
        return CollectionUtility.flatten((Collection[])new Collection[]{super.getChildren(), Collections.singletonList(this.getDefaultDetailForm())});
    }

    protected List<IMenu> computeInheritedMenusOfPage(IPage<?> activePage) {
        IPage<?> parentPage;
        ArrayList<IMenu> menus = new ArrayList<IMenu>();
        if (activePage instanceof IPageWithTable) {
            IPageWithTable pageWithTable = (IPageWithTable)activePage;
            menus.addAll(pageWithTable.computeTableEmptySpaceMenus());
        }
        if ((parentPage = activePage.getParentPage()) instanceof IPageWithTable) {
            IPageWithTable parentTablePage = (IPageWithTable)parentPage;
            menus.addAll(activePage.computeParentTablePageMenus(parentTablePage));
        }
        return menus;
    }

    protected void addMenusOfActivePageToContextMenu(IPage<?> activePage) {
        ArrayList<IMenu> wrappedMenus = new ArrayList<IMenu>();
        for (IMenu m : this.computeInheritedMenusOfPage(activePage)) {
            wrappedMenus.add(MenuWrapper.wrapMenu(m, TABLE_MENU_TYPE_MAPPER));
        }
        this.m_inheritedMenusOfPage = wrappedMenus;
        this.getContextMenu().addChildActions(this.m_inheritedMenusOfPage);
    }

    @Override
    public void clearContextPage() {
        IPage<?> page = this.m_contextPage;
        if (page != null) {
            this.removeMenusOfActivePageToContextMenu();
            this.m_contextPage = null;
            page.pageDeactivatedNotify();
        }
    }

    protected void removeMenusOfActivePageToContextMenu() {
        if (this.m_inheritedMenusOfPage != null) {
            this.getContextMenu().removeChildActions(this.m_inheritedMenusOfPage);
            this.m_inheritedMenusOfPage = null;
        }
    }

    @Override
    protected void nodesSelectedInternal(Set<ITreeNode> oldSelection, Set<ITreeNode> newSelection) {
        super.nodesSelectedInternal(oldSelection, newSelection);
        IPage deselectedPage = null;
        if (CollectionUtility.hasElements(oldSelection)) {
            deselectedPage = (IPage)CollectionUtility.firstElement(oldSelection);
        }
        IPage newSelectedPage = null;
        if (CollectionUtility.hasElements(newSelection)) {
            newSelectedPage = (IPage)CollectionUtility.firstElement(newSelection);
        }
        this.handleActivePageChanged(deselectedPage, newSelectedPage);
    }

    private void handleActivePageChanged(IPage<?> deselectedPage, IPage<?> selectedPage) {
        if (this.m_pageChangeStrategy == null) {
            return;
        }
        try {
            if (this.m_contextPageOptimisticLock.acquire()) {
                this.m_pageChangeStrategy.pageChanged(this, deselectedPage, selectedPage);
            }
        }
        finally {
            this.m_contextPageOptimisticLock.release();
        }
    }

    @Override
    public void setDefaultDetailForm(IForm form) {
        if (form != null) {
            if (form.getDisplayHint() != 20) {
                form.setDisplayHint(20);
            }
            if (form.getDisplayViewId() == null) {
                form.setDisplayViewId("PAGE_DETAIL");
            }
            form.setShowOnStart(false);
        }
        this.setDefaultDetailFormInternal(form);
    }

    protected void startDefaultDetailForm() {
        this.getDefaultDetailForm().start();
    }

    public void ensureDefaultDetailFormCreated() {
        if (this.getDefaultDetailForm() != null) {
            return;
        }
        IForm form = this.createDefaultDetailForm();
        if (form != null) {
            this.setDefaultDetailForm(form);
            this.interceptInitDefaultDetailForm();
        }
    }

    public void ensureDefaultDetailFormStarted() {
        if (this.getDefaultDetailForm() == null || !this.getDefaultDetailForm().isFormStartable()) {
            return;
        }
        this.startDefaultDetailForm();
    }

    protected void disposeDefaultDetailForm() {
        IForm defaultDetailForm = this.getDefaultDetailForm();
        if (defaultDetailForm != null) {
            defaultDetailForm.doClose();
            this.setDefaultDetailForm(null);
        }
    }

    protected IForm createDefaultDetailForm() {
        if (this.getConfiguredDefaultDetailForm() == null) {
            return null;
        }
        try {
            return this.getConfiguredDefaultDetailForm().getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception e) {
            ((ExceptionHandler)BEANS.get(ExceptionHandler.class)).handle((Throwable)new ProcessingException("error creating instance of class '" + this.getConfiguredDefaultDetailForm().getName() + "'.", new Object[]{e}));
            return null;
        }
    }

    @Override
    public void activate() {
        this.interceptActivated();
    }

    @Override
    public void deactivate() {
        this.interceptDeativated();
    }

    @Override
    public OutlineMediator getOutlineMediator() {
        return this.m_outlineMediator;
    }

    protected OutlineMediator createOutlineMediator() {
        return new OutlineMediator();
    }

    protected IPageChangeStrategy createPageChangeStrategy() {
        return new DefaultPageChangeStrategy();
    }

    @Override
    public void setPageChangeStrategy(IPageChangeStrategy pageChangeStrategy) {
        this.m_pageChangeStrategy = pageChangeStrategy;
    }

    @Override
    public IPageChangeStrategy getPageChangeStrategy() {
        return this.m_pageChangeStrategy;
    }

    protected TreeListener createLocalTreeListener() {
        return e -> {
            ITreeNode commonParentNode = e.getCommonParentNode();
            if (commonParentNode instanceof IPageWithNodes) {
                this.handlePageWithNodesTreeEvent(e, (IPageWithNodes)commonParentNode);
            } else if (commonParentNode instanceof IPageWithTable) {
                this.handlePageWithTableTreeEvent(e, (IPageWithTable)commonParentNode);
            }
        };
    }

    protected void handlePageWithTableTreeEvent(TreeEvent e, IPageWithTable<?> pageWithTable) {
        OutlineMediator outlineMediator = this.getOutlineMediator();
        if (outlineMediator == null) {
            return;
        }
        switch (e.getType()) {
            case 705: {
                outlineMediator.mediateTreeNodeAction(e, pageWithTable);
                break;
            }
            case 730: {
                outlineMediator.mediateTreeNodesDragRequest(e, pageWithTable);
                break;
            }
            case 740: {
                outlineMediator.mediateTreeNodeDropAction(e, pageWithTable);
            }
        }
    }

    protected void handlePageWithNodesTreeEvent(TreeEvent e, IPageWithNodes pageWithNodes) {
        OutlineMediator outlineMediator = this.getOutlineMediator();
        if (outlineMediator == null) {
            return;
        }
        switch (e.getType()) {
            case 10: 
            case 20: 
            case 30: 
            case 50: 
            case 870: {
                outlineMediator.mediateTreeNodesChanged(pageWithNodes);
            }
        }
    }

    @Override
    public String classId() {
        return ConfigurationUtility.getAnnotatedClassIdWithFallback(this.getClass(), (boolean)false);
    }

    protected final IPage<?> interceptCreateRootPage() {
        List<? extends ITreeExtension<? extends AbstractTree>> extensions = this.getAllExtensions();
        OutlineChains.OutlineCreateRootPageChain chain = new OutlineChains.OutlineCreateRootPageChain(extensions);
        return chain.execCreateRootPage();
    }

    protected final void interceptCreateChildPages(List<IPage<?>> pageList) {
        List<? extends ITreeExtension<? extends AbstractTree>> extensions = this.getAllExtensions();
        OutlineChains.OutlineCreateChildPagesChain chain = new OutlineChains.OutlineCreateChildPagesChain(extensions);
        chain.execCreateChildPages(pageList);
    }

    protected final void interceptInitDefaultDetailForm() {
        List<? extends ITreeExtension<? extends AbstractTree>> extensions = this.getAllExtensions();
        OutlineChains.OutlineInitDefaultDetailFormChain chain = new OutlineChains.OutlineInitDefaultDetailFormChain(extensions);
        chain.execInitDefaultDetailForm();
    }

    protected final void interceptActivated() {
        List<? extends ITreeExtension<? extends AbstractTree>> extensions = this.getAllExtensions();
        OutlineChains.OutlineActivatedChain chain = new OutlineChains.OutlineActivatedChain(extensions);
        chain.execActivated();
    }

    protected final void interceptDeativated() {
        List<? extends ITreeExtension<? extends AbstractTree>> extensions = this.getAllExtensions();
        OutlineChains.OutlineDeactivatedChain chain = new OutlineChains.OutlineDeactivatedChain(extensions);
        chain.execDeactivated();
    }

    protected IOutlineExtension<? extends AbstractOutline> createLocalExtension() {
        return new LocalOutlineExtension<AbstractOutline>(this);
    }

    @Override
    public void firePageChanged(IPage<?> page) {
        if (page != null && page.isInitializing()) {
            return;
        }
        this.fireTreeEventInternal(new OutlineEvent((ITree)this, 1001, page, true));
    }

    @Override
    public void fireBeforeDataLoaded(IPage<?> page) {
        this.fireTreeEventInternal(new OutlineEvent((ITree)this, 1002, page, false));
    }

    @Override
    public void fireAfterDataLoaded(IPage<?> page) {
        this.fireTreeEventInternal(new OutlineEvent((ITree)this, 1003, page, false));
    }

    @Override
    public void fireAfterTableInit(IPage<?> page) {
        this.fireTreeEventInternal(new OutlineEvent((ITree)this, 1004, page, false));
    }

    @Override
    public void fireAfterPageInit(IPage<?> page) {
        this.fireTreeEventInternal(new OutlineEvent((ITree)this, 1005, page, false));
    }

    @Override
    public void fireAfterSearchFormStart(IPage<?> page) {
        this.fireTreeEventInternal(new OutlineEvent((ITree)this, 1006, page, false));
    }

    @Override
    public void fireAfterPageDispose(IPage<?> page) {
        this.fireTreeEventInternal(new OutlineEvent((ITree)this, 1007, page, true));
    }

    @Override
    public void firePageActivated(IPage<?> page) {
        this.fireTreeEventInternal(new OutlineEvent((ITree)this, 1008, page, false));
    }

    protected void fireTreeEventInternal(OutlineEvent e) {
        if (e.isBuffered()) {
            super.fireTreeEventInternal(e);
        } else {
            this.doFireTreeEvent(e);
        }
    }

    @Override
    protected void disposeChildren(List<? extends IWidget> widgetsToDispose) {
        widgetsToDispose.remove(this.getDefaultDetailForm());
        super.disposeChildren(widgetsToDispose);
    }

    @Override
    protected void disposeTreeInternal() {
        try {
            this.disposeDefaultDetailForm();
        }
        catch (RuntimeException | PlatformError e) {
            ((ExceptionHandler)BEANS.get(ExceptionHandler.class)).handle(e);
        }
        super.disposeTreeInternal();
    }

    @ClassId(value="90c662a2-28ac-4ca3-b34c-9b58cf14b3d9")
    private class InvisibleRootPage
    extends AbstractPageWithNodes {
        private InvisibleRootPage() {
        }

        @Override
        protected void execCreateChildPages(List<IPage<?>> pageList) {
            AbstractOutline.this.createChildPagesInternal(pageList);
        }
    }

    protected static class LocalOutlineExtension<OWNER extends AbstractOutline>
    extends AbstractTree.LocalTreeExtension<OWNER>
    implements IOutlineExtension<OWNER> {
        public LocalOutlineExtension(OWNER owner) {
            super(owner);
        }

        @Override
        public void execCreateChildPages(OutlineChains.OutlineCreateChildPagesChain chain, List<IPage<?>> pageList) {
            ((AbstractOutline)this.getOwner()).execCreateChildPages(pageList);
        }

        @Override
        public IPage<?> execCreateRootPage(OutlineChains.OutlineCreateRootPageChain chain) {
            return ((AbstractOutline)this.getOwner()).execCreateRootPage();
        }

        @Override
        public void execInitDefaultDetailForm(OutlineChains.OutlineInitDefaultDetailFormChain chain) {
            ((AbstractOutline)this.getOwner()).execInitDefaultDetailForm();
        }

        @Override
        public void execActivated(OutlineChains.OutlineActivatedChain chain) {
            ((AbstractOutline)this.getOwner()).execActivated();
        }

        @Override
        public void execDeactivated(OutlineChains.OutlineDeactivatedChain chain) {
            ((AbstractOutline)this.getOwner()).execDeactivated();
        }
    }

    private class P_TableFilterBasedTreeNodeFilter
    implements ITreeNodeFilter {
        private P_TableFilterBasedTreeNodeFilter() {
        }

        @Override
        public boolean accept(ITreeNode node, int level) {
            ITreeNode parentNode = node.getParentNode();
            if (parentNode != null && !parentNode.isFilterAccepted()) {
                node.setRejectedByUser(parentNode.isRejectedByUser());
                return false;
            }
            if (!(parentNode instanceof IPage)) {
                return true;
            }
            IPage parentPage = (IPage)parentNode;
            ITableRow tableRow = parentPage.getTableRowFor(node);
            if (tableRow == null) {
                return true;
            }
            if (!tableRow.isFilterAccepted()) {
                node.setRejectedByUser(tableRow.isRejectedByUser());
            }
            return tableRow.isFilterAccepted();
        }
    }
}

