/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.client.ui.form;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.scout.rt.client.extension.ui.action.IActionExtension;
import org.eclipse.scout.rt.client.extension.ui.form.FormMenuChains;
import org.eclipse.scout.rt.client.extension.ui.form.IFormMenuExtension;
import org.eclipse.scout.rt.client.ui.IWidget;
import org.eclipse.scout.rt.client.ui.action.AbstractAction;
import org.eclipse.scout.rt.client.ui.action.menu.AbstractMenu;
import org.eclipse.scout.rt.client.ui.form.IForm;
import org.eclipse.scout.rt.client.ui.form.IFormMenu;
import org.eclipse.scout.rt.platform.BEANS;
import org.eclipse.scout.rt.platform.Order;
import org.eclipse.scout.rt.platform.annotations.ConfigOperation;
import org.eclipse.scout.rt.platform.annotations.ConfigProperty;
import org.eclipse.scout.rt.platform.classid.ClassId;
import org.eclipse.scout.rt.platform.exception.ExceptionHandler;
import org.eclipse.scout.rt.platform.exception.ProcessingException;
import org.eclipse.scout.rt.platform.util.CollectionUtility;

@ClassId(value="c40132fa-5aac-4d25-8330-76b9210c07ca")
public abstract class AbstractFormMenu<FORM extends IForm>
extends AbstractMenu
implements IFormMenu<FORM> {
    @Override
    protected boolean getConfiguredToggleAction() {
        return true;
    }

    @Override
    public FORM getForm() {
        return (FORM)((IForm)this.propertySupport.getProperty("form"));
    }

    @Override
    public void setForm(FORM f) {
        this.propertySupport.setProperty("form", f);
    }

    @ConfigProperty(value="FORM")
    @Order(value=90.0)
    protected Class<FORM> getConfiguredForm() {
        return null;
    }

    @Override
    public List<? extends IWidget> getChildren() {
        return CollectionUtility.flatten((Collection[])new Collection[]{super.getChildren(), Collections.singletonList(this.getForm())});
    }

    @ConfigOperation
    @Order(value=120.0)
    protected void execInitForm(IForm form) {
    }

    @Override
    protected void execSelectionChanged(boolean selected) {
        if (!selected) {
            return;
        }
        this.ensureFormCreated();
        this.ensureFormStarted();
    }

    public void ensureFormCreated() {
        if (this.getForm() != null) {
            return;
        }
        FORM form = this.createForm();
        if (form != null) {
            form.addFormListener(e -> {
                if (e.getType() == 3010) {
                    this.setSelected(false);
                    this.setForm(null);
                }
            });
            this.decorateForm(form);
            this.interceptInitForm(form);
            this.setForm(form);
        }
    }

    public void ensureFormStarted() {
        if (this.getForm() == null || !this.getForm().isFormStartable()) {
            return;
        }
        this.startForm();
    }

    protected FORM createForm() {
        if (this.getConfiguredForm() == null) {
            return null;
        }
        try {
            return (FORM)((IForm)this.getConfiguredForm().getConstructor(new Class[0]).newInstance(new Object[0]));
        }
        catch (Exception e) {
            ((ExceptionHandler)BEANS.get(ExceptionHandler.class)).handle((Throwable)new ProcessingException("error creating instance of class '" + this.getConfiguredForm().getName() + "'.", new Object[]{e}));
            return null;
        }
    }

    protected void startForm() {
        this.getForm().start();
    }

    protected void decorateForm(FORM form) {
        form.setShowOnStart(false);
        form.setDisplayHint(20);
        form.setDisplayViewId("E");
    }

    protected final void interceptInitForm(FORM form) {
        List<? extends IActionExtension<? extends AbstractAction>> extensions = this.getAllExtensions();
        FormMenuChains.FormMenuInitFormChain<FORM> chain = new FormMenuChains.FormMenuInitFormChain<FORM>(extensions);
        chain.execInitForm(form);
    }

    @Override
    protected void disposeChildren(List<? extends IWidget> widgetsToDispose) {
        widgetsToDispose.remove(this.getForm());
        super.disposeChildren(widgetsToDispose);
    }

    @Override
    protected void initChildren(List<? extends IWidget> widgets) {
        widgets.remove(this.getForm());
        super.initChildren(widgets);
    }

    @Override
    public void disposeActionInternal() {
        FORM form = this.getForm();
        if (form != null && !form.isFormClosed()) {
            form.doClose();
        }
        super.disposeActionInternal();
    }

    @Override
    protected IFormMenuExtension<FORM, ? extends AbstractFormMenu<FORM>> createLocalExtension() {
        return new LocalFormMenuExtension(this);
    }

    protected static class LocalFormMenuExtension<FORM extends IForm, OWNER extends AbstractFormMenu<FORM>>
    extends AbstractMenu.LocalMenuExtension<OWNER>
    implements IFormMenuExtension<FORM, OWNER> {
        public LocalFormMenuExtension(OWNER owner) {
            super(owner);
        }

        @Override
        public void execInitForm(FormMenuChains.FormMenuInitFormChain<FORM> chain, FORM form) {
            ((AbstractFormMenu)this.getOwner()).execInitForm((IForm)form);
        }
    }
}

