/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.client.ui.form.fields;

import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.scout.rt.client.extension.ui.form.fields.ICompositeFieldExtension;
import org.eclipse.scout.rt.client.ui.IWidget;
import org.eclipse.scout.rt.client.ui.form.AbstractForm;
import org.eclipse.scout.rt.client.ui.form.DefaultFormFieldInjection;
import org.eclipse.scout.rt.client.ui.form.FormFieldInjectionThreadLocal;
import org.eclipse.scout.rt.client.ui.form.IForm;
import org.eclipse.scout.rt.client.ui.form.fields.AbstractFormField;
import org.eclipse.scout.rt.client.ui.form.fields.CompositeFieldUtility;
import org.eclipse.scout.rt.client.ui.form.fields.ICompositeField;
import org.eclipse.scout.rt.client.ui.form.fields.IFormField;
import org.eclipse.scout.rt.client.ui.form.fields.groupbox.AbstractGroupBox;
import org.eclipse.scout.rt.client.ui.form.fields.sequencebox.AbstractSequenceBox;
import org.eclipse.scout.rt.client.ui.form.fields.splitbox.AbstractSplitBox;
import org.eclipse.scout.rt.client.ui.form.fields.tabbox.AbstractTabBox;
import org.eclipse.scout.rt.platform.IOrdered;
import org.eclipse.scout.rt.platform.classid.ClassId;
import org.eclipse.scout.rt.platform.holders.Holder;
import org.eclipse.scout.rt.platform.reflect.ConfigurationUtility;
import org.eclipse.scout.rt.platform.util.CollectionUtility;
import org.eclipse.scout.rt.platform.util.ObjectUtility;
import org.eclipse.scout.rt.platform.util.collection.OrderedCollection;
import org.eclipse.scout.rt.platform.util.visitor.TreeVisitResult;

@ClassId(value="4a641cd4-801f-45d2-9f08-5798e20b03c4")
public abstract class AbstractCompositeField
extends AbstractFormField
implements ICompositeField {
    private Map<Class<?>, Class<? extends IFormField>> m_formFieldReplacements;
    private Map<Class<? extends IFormField>, IFormField> m_movedFormFieldsByClass;
    private static final ThreadLocal<Boolean> REPLACEMENT_LOOKUP_DONE = ThreadLocal.withInitial(() -> false);

    public AbstractCompositeField() {
        this(true);
    }

    public AbstractCompositeField(boolean callInitializer) {
        super(callInitializer);
    }

    protected List<Class<IFormField>> getConfiguredFields() {
        Class[] dca = ConfigurationUtility.getDeclaredPublicClasses(this.getClass());
        return ConfigurationUtility.filterClasses((Class[])dca, IFormField.class);
    }

    @Override
    protected boolean getConfiguredStatusVisible() {
        return super.getConfiguredStatusVisible();
    }

    @Override
    protected boolean execCalculateVisible() {
        return this.hasVisibleFieldsInternal();
    }

    @Override
    protected void initConfig() {
        this.setFieldsInternal(CollectionUtility.emptyArrayList());
        this.m_movedFormFieldsByClass = new HashMap<Class<? extends IFormField>, IFormField>();
        super.initConfig();
        DefaultFormFieldInjection injectedFields = null;
        List<Class<IFormField>> declaredFields = this.getConfiguredFields();
        ArrayList<Class<? extends IFormField>> configuredFields = new ArrayList<Class<? extends IFormField>>(declaredFields.size());
        for (Class<IFormField> clazz : declaredFields) {
            if (ConfigurationUtility.isInjectFieldAnnotationPresent(clazz)) {
                if (injectedFields == null) {
                    injectedFields = new DefaultFormFieldInjection(this);
                }
                injectedFields.addField(clazz);
                continue;
            }
            configuredFields.add(clazz);
        }
        try {
            List contributedFields = this.m_contributionHolder.getContributionsByClass(IFormField.class);
            if (injectedFields != null) {
                FormFieldInjectionThreadLocal.push(injectedFields);
            }
            FormFieldInjectionThreadLocal.pushContainerField(this);
            this.filterFieldsInternal(configuredFields);
            OrderedCollection fields = new OrderedCollection();
            for (Class clazz : configuredFields) {
                IFormField f = (IFormField)ConfigurationUtility.newInnerInstance((Object)this, (Class)clazz);
                fields.addOrdered((IOrdered)f);
            }
            fields.addAllOrdered((Collection)contributedFields);
            this.injectFieldsInternal((OrderedCollection<IFormField>)fields);
            for (IFormField iFormField : fields) {
                CompositeFieldUtility.connectFields(iFormField, this);
            }
            this.setFieldsInternal(fields.getOrderedList());
        }
        finally {
            if (injectedFields != null) {
                this.m_formFieldReplacements = injectedFields.getReplacementMapping();
                FormFieldInjectionThreadLocal.pop(injectedFields);
            }
            FormFieldInjectionThreadLocal.popContainerField(this);
        }
    }

    @Override
    public void addField(IFormField f) {
        CompositeFieldUtility.addField(f, this, this.getFieldsInternal());
        this.addChildFieldPropertyChangeListener(f);
        this.handleFieldsChanged();
    }

    @Override
    public void removeField(IFormField f) {
        CompositeFieldUtility.removeField(f, this, this.getFieldsInternal());
        this.removeChildFieldPropertyChangeListener(f);
        this.handleFieldsChanged();
    }

    @Override
    public void moveFieldTo(IFormField f, ICompositeField newContainer) {
        CompositeFieldUtility.moveFieldTo(f, this, newContainer, this.m_movedFormFieldsByClass);
    }

    @Override
    public Map<Class<? extends IFormField>, IFormField> getMovedFields() {
        return Collections.unmodifiableMap(this.m_movedFormFieldsByClass);
    }

    protected void handleFieldsChanged() {
        this.handleChildFieldVisibilityChanged();
        this.checkSaveNeeded();
        this.checkEmpty();
        this.propertySupport.setPropertyAlwaysFire("fields", this.getFieldsInternal());
    }

    protected void filterFieldsInternal(List<Class<? extends IFormField>> fieldList) {
        FormFieldInjectionThreadLocal.filterFields(this, fieldList);
    }

    protected void injectFieldsInternal(OrderedCollection<IFormField> fields) {
        FormFieldInjectionThreadLocal.injectFields(this, fields);
    }

    @Override
    public void setFormInternal(IForm form) {
        super.setFormInternal(form);
        if (form instanceof AbstractForm && this == form.getRootGroupBox()) {
            ((AbstractForm)form).registerFormFieldReplacementsInternal(this.m_formFieldReplacements);
        }
    }

    @Override
    public boolean setParentInternal(IWidget parentField) {
        boolean result = super.setParentInternal(parentField);
        if (!(parentField instanceof AbstractCompositeField)) {
            return result;
        }
        if (this.isTemplateField()) {
            return result;
        }
        ((AbstractCompositeField)parentField).registerFormFieldReplacements(this.m_formFieldReplacements);
        return result;
    }

    public boolean isTemplateField() {
        Class<?> c = this.getClass();
        while (c.getSuperclass() != null) {
            if (!Modifier.isAbstract((c = c.getSuperclass()).getModifiers())) continue;
            if (ObjectUtility.isOneOf(c, AbstractCompositeField.class, (Object[])new Object[]{AbstractGroupBox.class, AbstractSequenceBox.class, AbstractSplitBox.class, AbstractTabBox.class})) {
                return false;
            }
            Class<?>[] classArray = c.getDeclaredClasses();
            int n = classArray.length;
            int n2 = 0;
            while (n2 < n) {
                Class<?> innerClass = classArray[n2];
                int m = innerClass.getModifiers();
                if (Modifier.isPublic(m) && !Modifier.isAbstract(m) && IFormField.class.isAssignableFrom(innerClass)) {
                    return true;
                }
                ++n2;
            }
        }
        return false;
    }

    @Override
    public int getFieldIndex(IFormField f) {
        return this.getFieldsInternal().indexOf(f);
    }

    @Override
    public int getFieldCount() {
        return this.getFieldsInternal().size();
    }

    @Override
    public IFormField getFieldById(String id) {
        return CompositeFieldUtility.getFieldById(this, id);
    }

    @Override
    public <T extends IFormField> T getFieldById(String id, Class<T> type) {
        return CompositeFieldUtility.getFieldById(this, id, type);
    }

    @Override
    public <T extends IWidget> TreeVisitResult getWidgetByClassInternal(Holder<T> result, Class<T> widgetClassToFind) {
        Class<T> classToFind = widgetClassToFind;
        boolean replacementLookupDone = false;
        if (!REPLACEMENT_LOOKUP_DONE.get().booleanValue()) {
            classToFind = this.getReplacingFieldClass(widgetClassToFind);
            replacementLookupDone = true;
            REPLACEMENT_LOOKUP_DONE.set(true);
        }
        try {
            TreeVisitResult visitResult = super.getWidgetByClassInternal(result, classToFind);
            if (visitResult == TreeVisitResult.SKIP_SUBTREE || visitResult == TreeVisitResult.TERMINATE) {
                TreeVisitResult treeVisitResult = visitResult;
                return treeVisitResult;
            }
            for (IWidget iWidget : this.getChildren()) {
                T widget = iWidget.getWidgetByClass(classToFind);
                if (widget == null) continue;
                result.setValue(widget);
                TreeVisitResult treeVisitResult = TreeVisitResult.TERMINATE;
                return treeVisitResult;
            }
        }
        finally {
            if (replacementLookupDone) {
                REPLACEMENT_LOOKUP_DONE.remove();
            }
        }
        return TreeVisitResult.SKIP_SUBTREE;
    }

    @Override
    public <T extends IFormField> T getFieldByClass(Class<T> fieldToFind) {
        return (T)((IFormField)this.getWidgetByClass(fieldToFind));
    }

    private void registerFormFieldReplacements(Map<Class<?>, Class<? extends IFormField>> replacements) {
        if (replacements == null || replacements.isEmpty()) {
            return;
        }
        if (this.m_formFieldReplacements == null) {
            this.m_formFieldReplacements = new HashMap();
        }
        this.m_formFieldReplacements.putAll(replacements);
    }

    private <T extends IWidget> Class<T> getReplacingFieldClass(Class<T> c) {
        Class<? extends IFormField> replacementFieldClass;
        Map<Class<?>, Class<IFormField>> mapping;
        Class<? extends IFormField> replacementFieldClass2;
        if (this.m_formFieldReplacements != null && (replacementFieldClass2 = this.m_formFieldReplacements.get(c)) != null) {
            return replacementFieldClass2;
        }
        IForm form = this.getForm();
        if (form instanceof AbstractForm && (mapping = ((AbstractForm)form).getFormFieldReplacementsInternal()) != null && (replacementFieldClass = mapping.get(c)) != null) {
            return replacementFieldClass;
        }
        ICompositeField parentField = this.getParentField();
        while (parentField != null) {
            Class<? extends IFormField> replacementFieldClass3;
            Map<Class<?>, Class<IFormField>> parentReplacements;
            if (parentField instanceof AbstractCompositeField && (parentReplacements = ((AbstractCompositeField)parentField).m_formFieldReplacements) != null && (replacementFieldClass3 = parentReplacements.get(c)) != null) {
                return replacementFieldClass3;
            }
            parentField = parentField.getParentField();
        }
        return c;
    }

    @Override
    public void setFields(List<IFormField> fields) {
        this.setFieldsInternal(CollectionUtility.arrayList(fields));
    }

    protected void setFieldsInternal(List<IFormField> fields) {
        this.propertySupport.setPropertyList("fields", fields);
    }

    @Override
    public List<IFormField> getFields() {
        return CollectionUtility.arrayList(this.getFieldsInternal());
    }

    protected List<IFormField> getFieldsInternal() {
        return this.propertySupport.getPropertyList("fields");
    }

    @Override
    public List<? extends IWidget> getChildren() {
        return CollectionUtility.flatten((Collection[])new Collection[]{super.getChildren(), this.getFieldsInternal()});
    }

    @Override
    protected void handleChildFieldVisibilityChanged() {
        super.handleChildFieldVisibilityChanged();
        this.setHasVisibleFieldsInternal(this.calcHasVisibleFieldsInternal());
        this.calculateVisibleInternal();
    }

    protected boolean calcHasVisibleFieldsInternal() {
        if (CollectionUtility.isEmpty(this.getFieldsInternal())) {
            return false;
        }
        for (IFormField field : this.getFieldsInternal()) {
            if (!field.isVisible()) continue;
            return true;
        }
        return false;
    }

    @Override
    public void rebuildFieldGrid() {
    }

    protected void setHasVisibleFieldsInternal(boolean hasVisibleFields) {
        this.propertySupport.setPropertyBool("hasVisibleFields", hasVisibleFields);
    }

    protected boolean hasVisibleFieldsInternal() {
        return this.propertySupport.getPropertyBool("hasVisibleFields");
    }

    protected ICompositeFieldExtension<? extends AbstractCompositeField> createLocalExtension() {
        return new LocalCompositeFieldExtension<AbstractCompositeField>(this);
    }

    protected static class LocalCompositeFieldExtension<OWNER extends AbstractCompositeField>
    extends AbstractFormField.LocalFormFieldExtension<OWNER>
    implements ICompositeFieldExtension<OWNER> {
        public LocalCompositeFieldExtension(OWNER owner) {
            super(owner);
        }
    }
}

