/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.client.ui.form.fields;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.security.Permission;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import org.eclipse.scout.rt.client.dto.FormData;
import org.eclipse.scout.rt.client.extension.ui.form.fields.FormFieldChains;
import org.eclipse.scout.rt.client.extension.ui.form.fields.IFormFieldExtension;
import org.eclipse.scout.rt.client.services.common.search.ISearchFilterService;
import org.eclipse.scout.rt.client.ui.AbstractWidget;
import org.eclipse.scout.rt.client.ui.IWidget;
import org.eclipse.scout.rt.client.ui.action.keystroke.IKeyStroke;
import org.eclipse.scout.rt.client.ui.desktop.IDesktop;
import org.eclipse.scout.rt.client.ui.desktop.datachange.IDataChangeListener;
import org.eclipse.scout.rt.client.ui.form.IForm;
import org.eclipse.scout.rt.client.ui.form.fields.AbstractCompositeField;
import org.eclipse.scout.rt.client.ui.form.fields.CompositeFieldUtility;
import org.eclipse.scout.rt.client.ui.form.fields.DefaultFieldStatus;
import org.eclipse.scout.rt.client.ui.form.fields.GridData;
import org.eclipse.scout.rt.client.ui.form.fields.ICompositeField;
import org.eclipse.scout.rt.client.ui.form.fields.IFormField;
import org.eclipse.scout.rt.client.ui.form.fields.IValidateContentDescriptor;
import org.eclipse.scout.rt.client.ui.form.fields.IValueField;
import org.eclipse.scout.rt.client.ui.form.fields.MasterListener;
import org.eclipse.scout.rt.client.ui.form.fields.ValidateFormFieldDescriptor;
import org.eclipse.scout.rt.client.ui.form.fields.groupbox.IGroupBox;
import org.eclipse.scout.rt.platform.BEANS;
import org.eclipse.scout.rt.platform.Order;
import org.eclipse.scout.rt.platform.Replace;
import org.eclipse.scout.rt.platform.annotations.ConfigOperation;
import org.eclipse.scout.rt.platform.annotations.ConfigProperty;
import org.eclipse.scout.rt.platform.classid.ClassId;
import org.eclipse.scout.rt.platform.exception.ExceptionHandler;
import org.eclipse.scout.rt.platform.exception.PlatformError;
import org.eclipse.scout.rt.platform.exception.ProcessingException;
import org.eclipse.scout.rt.platform.holders.Holder;
import org.eclipse.scout.rt.platform.reflect.BasicPropertySupport;
import org.eclipse.scout.rt.platform.reflect.ConfigurationUtility;
import org.eclipse.scout.rt.platform.reflect.IPropertyObserver;
import org.eclipse.scout.rt.platform.status.IMultiStatus;
import org.eclipse.scout.rt.platform.status.IStatus;
import org.eclipse.scout.rt.platform.status.MultiStatus;
import org.eclipse.scout.rt.platform.util.CollectionUtility;
import org.eclipse.scout.rt.platform.util.XmlUtility;
import org.eclipse.scout.rt.platform.util.visitor.IBreadthFirstTreeVisitor;
import org.eclipse.scout.rt.platform.util.visitor.TreeVisitResult;
import org.eclipse.scout.rt.security.ACCESS;
import org.eclipse.scout.rt.shared.data.basic.FontSpec;
import org.eclipse.scout.rt.shared.data.basic.NamedBitMaskHelper;
import org.eclipse.scout.rt.shared.data.form.fields.AbstractFormFieldData;
import org.eclipse.scout.rt.shared.extension.AbstractExtension;
import org.eclipse.scout.rt.shared.extension.ContributionComposite;
import org.eclipse.scout.rt.shared.extension.IContributionOwner;
import org.eclipse.scout.rt.shared.extension.IExtensibleObject;
import org.eclipse.scout.rt.shared.extension.IExtension;
import org.eclipse.scout.rt.shared.extension.ObjectExtensions;
import org.eclipse.scout.rt.shared.services.common.jdbc.SearchFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

@ClassId(value="cb3204c4-71bf-4dc6-88a4-3a8f81a7ca10")
@FormData(value=AbstractFormFieldData.class, sdkCommand=FormData.SdkCommand.USE)
public abstract class AbstractFormField
extends AbstractWidget
implements IFormField,
IContributionOwner,
IExtensibleObject {
    private static final String ENABLED_SLAVE = "ENABLED_SLAVE";
    private static final String TOUCHED = "TOUCHED";
    private static final String LABEL_VISIBLE = "LABEL_VISIBLE";
    private static final String MASTER_REQUIRED = "MASTER_REQUIRED";
    private static final Logger LOG = LoggerFactory.getLogger(AbstractFormField.class);
    private static final NamedBitMaskHelper VISIBLE_BIT_HELPER = new NamedBitMaskHelper(new String[]{"VISIBLE", "VISIBLE_GRANTED"});
    private static final NamedBitMaskHelper LABEL_VISIBLE_BIT_HELPER = new NamedBitMaskHelper(new String[]{"LABEL_VISIBLE"});
    private static final NamedBitMaskHelper FLAGS_BIT_HELPER = new NamedBitMaskHelper(new String[]{"TOUCHED", "MASTER_REQUIRED"});
    private byte m_visible;
    private byte m_labelVisible;
    private byte m_flags;
    private IForm m_form;
    private byte m_labelHorizontalAlignment;
    private Permission m_visiblePermission;
    private IValueField<?> m_masterField;
    protected int m_valueChangeTriggerEnabled = 1;
    private BasicPropertySupport m_subtreePropertyChangeSupport;
    private P_MasterListener m_currentMasterListener;
    private final P_FieldPropertyChangeListener m_fieldPropertyChangeListener;
    private IDataChangeListener m_internalDataChangeListener;
    protected ContributionComposite m_contributionHolder;
    private String m_initialLabel;
    private final ObjectExtensions<AbstractFormField, IFormFieldExtension<? extends AbstractFormField>> m_objectExtensions;

    public AbstractFormField() {
        this(true);
    }

    public AbstractFormField(boolean callInitializer) {
        super(false);
        this.setEnabled(true, ENABLED_SLAVE);
        this.m_visible = (byte)-1;
        this.m_labelVisible = (byte)-1;
        this.m_objectExtensions = new ObjectExtensions((Object)this, false);
        this.m_fieldPropertyChangeListener = new P_FieldPropertyChangeListener();
        if (callInitializer) {
            this.callInitializer();
        }
    }

    public final List<Object> getAllContributions() {
        return this.m_contributionHolder.getAllContributions();
    }

    public final <T> List<T> getContributionsByClass(Class<T> type) {
        return this.m_contributionHolder.getContributionsByClass(type);
    }

    public final <T> T getContribution(Class<T> contribution) {
        return (T)this.m_contributionHolder.getContribution(contribution);
    }

    public final <T> T optContribution(Class<T> contribution) {
        return (T)this.m_contributionHolder.optContribution(contribution);
    }

    @Override
    public <T extends IWidget> TreeVisitResult getWidgetByClassInternal(Holder<T> result, Class<T> widgetClassToFind) {
        return CompositeFieldUtility.getWidgetByClassInternal(this, result, widgetClassToFind);
    }

    @Override
    protected void initConfigInternal() {
        try {
            this.setValueChangeTriggerEnabled(false);
            this.m_objectExtensions.initConfigAndBackupExtensionContext(this.createLocalExtension(), this::initConfig);
            this.handleChildFieldVisibilityChanged();
            for (IWidget iWidget : this.getFirstChildFormFields(false)) {
                this.addChildFieldPropertyChangeListener(iWidget);
            }
        }
        finally {
            this.setValueChangeTriggerEnabled(true);
        }
    }

    public final List<? extends IFormFieldExtension<? extends AbstractFormField>> getAllExtensions() {
        return this.m_objectExtensions.getAllExtensions();
    }

    protected IFormFieldExtension<? extends AbstractFormField> createLocalExtension() {
        return new LocalFormFieldExtension<AbstractFormField>(this);
    }

    public <T extends IExtension<?>> T getExtension(Class<T> c) {
        return (T)this.m_objectExtensions.getExtension(c);
    }

    @ConfigProperty(value="TEXT")
    @Order(value=10.0)
    protected String getConfiguredLabel() {
        return null;
    }

    @Order(value=15.0)
    @ConfigProperty(value="LABEL_POSITION")
    protected byte getConfiguredLabelPosition() {
        return 0;
    }

    @ConfigProperty(value="INTEGER")
    @Order(value=16.0)
    protected int getConfiguredLabelWidthInPixel() {
        return 0;
    }

    @Order(value=17.0)
    @ConfigProperty(value="LABEL_HORIZONTAL_ALIGNMENT")
    protected byte getConfiguredLabelHorizontalAlignment() {
        return 127;
    }

    @ConfigProperty(value="BOOLEAN")
    @Order(value=20.0)
    protected boolean getConfiguredLabelVisible() {
        return true;
    }

    @ConfigProperty(value="BOOLEAN")
    @Order(value=25.0)
    protected boolean getConfiguredLabelHtmlEnabled() {
        return false;
    }

    @ConfigProperty(value="INTEGER")
    @Order(value=32.0)
    protected String getConfiguredFieldStyle() {
        return "alternative";
    }

    @ConfigProperty(value="INTEGER")
    @Order(value=35.0)
    protected int getConfiguredDisabledStyle() {
        return 0;
    }

    @ConfigProperty(value="BOOLEAN")
    @Order(value=40.0)
    protected boolean getConfiguredVisible() {
        return true;
    }

    @ConfigProperty(value="BOOLEAN")
    @Order(value=45.0)
    protected boolean getConfiguredMandatory() {
        return false;
    }

    @ConfigProperty(value="DOUBLE")
    @Order(value=145.0)
    protected double getConfiguredViewOrder() {
        return 9.876543212345678E16;
    }

    @ConfigProperty(value="TEXT")
    @Order(value=50.0)
    protected String getConfiguredTooltipText() {
        return null;
    }

    @ConfigProperty(value="TEXT")
    @Order(value=55.0)
    protected String getConfiguredTooltipAnchor() {
        return "default";
    }

    @ConfigProperty(value="COLOR")
    @Order(value=60.0)
    protected String getConfiguredForegroundColor() {
        return null;
    }

    @ConfigProperty(value="COLOR")
    @Order(value=70.0)
    protected String getConfiguredBackgroundColor() {
        return null;
    }

    @ConfigProperty(value="FONT")
    @Order(value=80.0)
    protected String getConfiguredFont() {
        return null;
    }

    @ConfigProperty(value="COLOR")
    @Order(value=60.0)
    protected String getConfiguredLabelForegroundColor() {
        return null;
    }

    @ConfigProperty(value="COLOR")
    @Order(value=70.0)
    protected String getConfiguredLabelBackgroundColor() {
        return null;
    }

    @ConfigProperty(value="FONT")
    @Order(value=80.0)
    protected String getConfiguredLabelFont() {
        return null;
    }

    @ConfigProperty(value="HORIZONTAL_ALIGNMENT")
    @Order(value=85.0)
    protected int getConfiguredHorizontalAlignment() {
        return -1;
    }

    @ConfigProperty(value="VERTICAL_ALIGNMENT")
    @Order(value=86.0)
    protected int getConfiguredVerticalAlignment() {
        return -1;
    }

    @ConfigProperty(value="BOOLEAN")
    @Order(value=87.0)
    protected boolean getConfiguredFillHorizontal() {
        return true;
    }

    @ConfigProperty(value="BOOLEAN")
    @Order(value=88.0)
    protected boolean getConfiguredFillVertical() {
        return true;
    }

    @ConfigProperty(value="INTEGER")
    @Order(value=90.0)
    protected int getConfiguredGridX() {
        return -1;
    }

    @ConfigProperty(value="INTEGER")
    @Order(value=95.0)
    protected int getConfiguredGridY() {
        return -1;
    }

    @ConfigProperty(value="INTEGER")
    @Order(value=100.0)
    protected int getConfiguredGridW() {
        return 1;
    }

    @ConfigProperty(value="INTEGER")
    @Order(value=105.0)
    protected int getConfiguredGridH() {
        return 1;
    }

    @ConfigProperty(value="DOUBLE")
    @Order(value=130.0)
    protected double getConfiguredGridWeightX() {
        return -1.0;
    }

    @ConfigProperty(value="DOUBLE")
    @Order(value=140.0)
    protected double getConfiguredGridWeightY() {
        return -1.0;
    }

    @ConfigProperty(value="BOOLEAN")
    @Order(value=142.0)
    protected boolean getConfiguredGridUseUiWidth() {
        return false;
    }

    @ConfigProperty(value="BOOLEAN")
    @Order(value=142.0)
    protected boolean getConfiguredGridUseUiHeight() {
        return false;
    }

    @ConfigProperty(value="INTEGER")
    @Order(value=150.0)
    protected int getConfiguredWidthInPixel() {
        return 0;
    }

    @ConfigProperty(value="INTEGER")
    @Order(value=160.0)
    protected int getConfiguredHeightInPixel() {
        return 0;
    }

    @ConfigProperty(value="MASTER_FIELD")
    @Order(value=170.0)
    protected Class<? extends IValueField> getConfiguredMasterField() {
        return null;
    }

    @ConfigProperty(value="BOOLEAN")
    @Order(value=180.0)
    protected boolean getConfiguredMasterRequired() {
        return false;
    }

    @ConfigProperty(value="BOOLEAN")
    @Order(value=195.0)
    protected boolean getConfiguredPreventInitialFocus() {
        return false;
    }

    @ConfigProperty(value="BOOLEAN")
    @Order(value=200.0)
    protected boolean getConfiguredStatusVisible() {
        return true;
    }

    @ConfigProperty(value="BOOLEAN")
    @Order(value=200.0)
    protected String getConfiguredStatusPosition() {
        return "default";
    }

    private List<Class<? extends IKeyStroke>> getConfiguredKeyStrokes() {
        Class[] dca = ConfigurationUtility.getDeclaredPublicClasses(this.getClass());
        List fca = ConfigurationUtility.filterClasses((Class[])dca, IKeyStroke.class);
        return ConfigurationUtility.removeReplacedClasses((List)fca);
    }

    @Override
    public List<? extends IWidget> getChildren() {
        return CollectionUtility.flatten((Collection[])new Collection[]{super.getChildren(), this.getKeyStrokesInternal()});
    }

    @ConfigOperation
    @Order(value=10.0)
    protected void execInitField() {
    }

    @ConfigOperation
    @Order(value=11.0)
    protected boolean execIsSaveNeeded() {
        for (IFormField f : this.getFirstChildFormFields(false)) {
            if (!f.isSaveNeeded()) continue;
            return true;
        }
        return false;
    }

    @ConfigOperation
    @Order(value=12.0)
    protected void execMarkSaved() {
    }

    protected boolean areChildrenEmpty() {
        for (IFormField f : this.getFirstChildFormFields(false)) {
            if (f.isEmpty()) continue;
            return false;
        }
        return true;
    }

    @ConfigOperation
    @Order(value=13.0)
    protected boolean execIsEmpty() {
        return this.areChildrenEmpty();
    }

    @ConfigOperation
    @Order(value=14.0)
    protected void execDataChanged(Object ... dataTypes) {
    }

    @ConfigOperation
    @Order(value=15.0)
    protected void execDisposeField() {
    }

    @Override
    public final void applySearch(SearchFilter search) {
        this.interceptAddSearchTerms(search);
    }

    @ConfigOperation
    protected void execAddSearchTerms(SearchFilter search) {
        this.applySearchInternal(search);
    }

    protected void applySearchInternal(SearchFilter search) {
        ISearchFilterService sfs = (ISearchFilterService)BEANS.get(ISearchFilterService.class);
        if (sfs != null) {
            sfs.applySearchDelegate(this, search, true);
        }
    }

    @ConfigOperation
    @Order(value=50.0)
    protected void execChangedMasterValue(Object newMasterValue) {
    }

    @Override
    protected void initConfig() {
        super.initConfig();
        this.setGridDataInternal(new GridData(-1, -1, 1, 1, -1.0, -1.0));
        this.setGridDataHints(new GridData(-1, -1, 1, 1, -1.0, -1.0));
        this.propertySupport.setPropertyBool("empty", true);
        this.m_contributionHolder = new ContributionComposite((Object)this);
        this.m_form = IForm.CURRENT.get();
        this.setFieldStyle(this.getConfiguredFieldStyle());
        this.setDisabledStyle(this.getConfiguredDisabledStyle());
        this.setVisible(this.getConfiguredVisible());
        this.setMandatory(this.getConfiguredMandatory());
        this.setOrder(this.calculateViewOrder());
        this.setTooltipText(this.getConfiguredTooltipText());
        this.setTooltipAnchor(this.getConfiguredTooltipAnchor());
        this.setInitialLabel(this.getConfiguredLabel());
        this.setLabel(this.getConfiguredLabel());
        this.setLabelPosition(this.getConfiguredLabelPosition());
        this.setLabelWidthInPixel(this.getConfiguredLabelWidthInPixel());
        this.setLabelHorizontalAlignment(this.getConfiguredLabelHorizontalAlignment());
        this.setLabelVisible(this.getConfiguredLabelVisible());
        this.setLabelHtmlEnabled(this.getConfiguredLabelHtmlEnabled());
        this.setStatusVisible(this.getConfiguredStatusVisible());
        this.setStatusPosition(this.getConfiguredStatusPosition());
        this.setCssClass(this.getConfiguredCssClass());
        if (this.getConfiguredBackgroundColor() != null) {
            this.setBackgroundColor(this.getConfiguredBackgroundColor());
        }
        if (this.getConfiguredForegroundColor() != null) {
            this.setForegroundColor(this.getConfiguredForegroundColor());
        }
        if (this.getConfiguredFont() != null) {
            this.setFont(FontSpec.parse((String)this.getConfiguredFont()));
        }
        if (this.getConfiguredLabelBackgroundColor() != null) {
            this.setLabelBackgroundColor(this.getConfiguredLabelBackgroundColor());
        }
        if (this.getConfiguredLabelForegroundColor() != null) {
            this.setLabelForegroundColor(this.getConfiguredLabelForegroundColor());
        }
        if (this.getConfiguredLabelFont() != null) {
            this.setLabelFont(FontSpec.parse((String)this.getConfiguredLabelFont()));
        }
        this.setPreventInitialFocus(this.getConfiguredPreventInitialFocus());
        this.setGridDataHints(new GridData(this.getConfiguredGridX(), this.getConfiguredGridY(), this.getConfiguredGridW(), this.getConfiguredGridH(), this.getConfiguredGridWeightX(), this.getConfiguredGridWeightY(), this.getConfiguredGridUseUiWidth(), this.getConfiguredGridUseUiHeight(), this.getConfiguredHorizontalAlignment(), this.getConfiguredVerticalAlignment(), this.getConfiguredFillHorizontal(), this.getConfiguredFillVertical(), this.getConfiguredWidthInPixel(), this.getConfiguredHeightInPixel()));
        this.setMasterRequired(this.getConfiguredMasterRequired());
        this.addPropertyChangeListener(this::fireSubtreePropertyChange);
    }

    protected double calculateViewOrder() {
        double viewOrder = this.getConfiguredViewOrder();
        if (viewOrder == 9.876543212345678E16) {
            Class<?> cls = this.getClass();
            while (cls != null && IFormField.class.isAssignableFrom(cls)) {
                if (cls.isAnnotationPresent(Order.class)) {
                    Order order = cls.getAnnotation(Order.class);
                    return order.value();
                }
                cls = cls.getSuperclass();
            }
        }
        return viewOrder;
    }

    private <T extends IFormField> T findNearestFieldByClass(Class<T> c) {
        List<ICompositeField> enclosingFields = this.getEnclosingFieldList();
        if (enclosingFields.isEmpty()) {
            return this.getForm().getFieldByClass(c);
        }
        Collections.reverse(enclosingFields);
        for (ICompositeField parentField : enclosingFields) {
            T field = parentField.getFieldByClass(c);
            if (field == null) continue;
            return field;
        }
        return this.getForm().getFieldByClass(c);
    }

    @Override
    protected void initInternal() {
        super.initInternal();
        this.updateKeyStrokes();
        if (this.getConfiguredMasterField() != null) {
            IValueField master = this.findNearestFieldByClass(this.getConfiguredMasterField());
            this.setMasterField(master);
        }
        try {
            this.setValueChangeTriggerEnabled(false);
            this.initFieldInternal();
            this.interceptInitField();
        }
        finally {
            this.setValueChangeTriggerEnabled(true);
        }
    }

    protected List<IFormField> getFirstChildFormFields(boolean limitToSameFieldTree) {
        ArrayList<IFormField> nextFormFieldCollector = new ArrayList<IFormField>();
        Function<IWidget, TreeVisitResult> nextFormFieldsVisitor = w -> {
            if (w == this) {
                return TreeVisitResult.CONTINUE;
            }
            if (w instanceof IFormField) {
                nextFormFieldCollector.add((IFormField)w);
                return TreeVisitResult.SKIP_SUBTREE;
            }
            if (limitToSameFieldTree) {
                return w instanceof IForm ? TreeVisitResult.CONTINUE : TreeVisitResult.SKIP_SUBTREE;
            }
            return TreeVisitResult.CONTINUE;
        };
        this.visit(nextFormFieldsVisitor);
        return nextFormFieldCollector;
    }

    protected void initFieldInternal() {
        this.checkSaveNeeded();
        this.checkEmpty();
    }

    @Override
    protected final void disposeInternal() {
        try {
            this.disposeFieldInternal();
        }
        catch (RuntimeException e) {
            LOG.warn("Cannot dispose field [{}]", (Object)this.getClass().getName(), (Object)e);
        }
        try {
            this.interceptDisposeField();
        }
        catch (RuntimeException e) {
            LOG.warn("Cannot dispose field [{}]", (Object)this.getClass().getName(), (Object)e);
        }
        super.disposeInternal();
    }

    protected void disposeFieldInternal() {
        this.unregisterDataChangeListener(new Object[0]);
    }

    @Override
    public void registerDataChangeListener(Object ... dataTypes) {
        if (this.m_internalDataChangeListener == null) {
            this.m_internalDataChangeListener = event -> this.interceptDataChanged(event.getDataType());
        }
        IDesktop.CURRENT.get().dataChangeListeners().add(this.m_internalDataChangeListener, true, dataTypes);
    }

    @Override
    public void unregisterDataChangeListener(Object ... dataTypes) {
        if (this.m_internalDataChangeListener != null) {
            IDesktop.CURRENT.get().removeDataChangeListener(this.m_internalDataChangeListener, dataTypes);
        }
    }

    protected void fireSubtreePropertyChange(PropertyChangeEvent e) {
        ICompositeField parentField = this.getParentField();
        if (parentField instanceof AbstractFormField) {
            ((AbstractFormField)((Object)parentField)).fireSubtreePropertyChange(e);
        }
        if (this.m_subtreePropertyChangeSupport != null) {
            this.m_subtreePropertyChangeSupport.firePropertyChange(e);
        }
    }

    @Override
    public IForm getForm() {
        return this.m_form;
    }

    @Override
    public IGroupBox getParentGroupBox() {
        return this.getParentOfType(IGroupBox.class);
    }

    @Override
    public ICompositeField getParentField() {
        return this.getParentOfType(ICompositeField.class);
    }

    @Override
    public void setFormInternal(IForm form) {
        this.m_form = form;
        this.setFormOnChildren(form);
    }

    protected void setFormOnChildren(IForm form) {
        for (IFormField child : this.getFirstChildFormFields(false)) {
            child.setFormInternal(form);
        }
    }

    public String toString() {
        return String.valueOf(this.getLabel()) + "/" + this.getFieldId() + " (" + this.getClass().getName() + ")";
    }

    @Override
    public void setView(boolean visible, boolean enabled, boolean mandatory) {
        this.setVisible(visible);
        this.setEnabled(enabled);
        this.setMandatory(mandatory);
    }

    @Override
    public boolean isValueChangeTriggerEnabled() {
        return this.m_valueChangeTriggerEnabled >= 1;
    }

    @Override
    public void setValueChangeTriggerEnabled(boolean b) {
        this.m_valueChangeTriggerEnabled = b ? ++this.m_valueChangeTriggerEnabled : --this.m_valueChangeTriggerEnabled;
    }

    @Override
    public void addSubtreePropertyChangeListener(PropertyChangeListener listener) {
        if (listener == null) {
            return;
        }
        if (this.m_subtreePropertyChangeSupport == null) {
            this.m_subtreePropertyChangeSupport = new BasicPropertySupport((Object)this);
        }
        this.m_subtreePropertyChangeSupport.addPropertyChangeListener(listener);
    }

    @Override
    public void addSubtreePropertyChangeListener(String propName, PropertyChangeListener listener) {
        if (listener == null) {
            return;
        }
        if (this.m_subtreePropertyChangeSupport == null) {
            this.m_subtreePropertyChangeSupport = new BasicPropertySupport((Object)this);
        }
        this.m_subtreePropertyChangeSupport.addPropertyChangeListener(propName, listener);
    }

    @Override
    public void removeSubtreePropertyChangeListener(PropertyChangeListener listener) {
        if (this.m_subtreePropertyChangeSupport != null) {
            this.m_subtreePropertyChangeSupport.removePropertyChangeListener(listener);
        }
    }

    @Override
    public void removeSubtreePropertyChangeListener(String propName, PropertyChangeListener listener) {
        if (this.m_subtreePropertyChangeSupport != null) {
            this.m_subtreePropertyChangeSupport.removePropertyChangeListener(propName, listener);
        }
    }

    @Override
    public boolean isFieldChanging() {
        return this.propertySupport.isPropertiesChanging();
    }

    @Override
    public void setFieldChanging(boolean b) {
        this.propertySupport.setPropertiesChanging(b);
    }

    @Override
    public String getFieldId() {
        Class<?> c = this.getClass();
        while (c.isAnnotationPresent(Replace.class)) {
            c = c.getSuperclass();
        }
        return c.getSimpleName();
    }

    @Override
    public String classId() {
        boolean duplicate;
        boolean appendFormId;
        StringBuilder classId = new StringBuilder(this.computeClassId());
        boolean bl = appendFormId = !this.getClass().isAnnotationPresent(ClassId.class);
        if (appendFormId && this.getForm() != null) {
            classId.append("_").append(this.getForm().classId());
        }
        if (duplicate = this.existsDuplicateClassId()) {
            LOG.warn("Found a duplicate classid for {}, adding field index. Override classId for dynamically injected fields.", (Object)classId);
            int fieldIndex = this.getParentField() == null ? 0 : this.getParentField().getFieldIndex(this);
            classId.append("_").append(fieldIndex);
        }
        return classId.toString();
    }

    private String computeClassId() {
        StringBuilder fieldId = new StringBuilder();
        String simpleClassId = ConfigurationUtility.getAnnotatedClassIdWithFallback(this.getClass(), (boolean)true);
        fieldId.append(simpleClassId);
        List<ICompositeField> enclosingFieldList = this.getEnclosingFieldList();
        int i = enclosingFieldList.size() - 1;
        while (i >= 0) {
            ICompositeField enclosingField = enclosingFieldList.get(i);
            String enclosingClassId = ConfigurationUtility.getAnnotatedClassIdWithFallback(enclosingField.getClass(), (boolean)true);
            fieldId.append("_").append(enclosingClassId);
            --i;
        }
        return fieldId.toString();
    }

    private boolean existsDuplicateClassId() {
        IForm form = this.getForm();
        if (form != null) {
            FindClassIdVisitor visitor = new FindClassIdVisitor(this.computeClassId(), this);
            form.visit(visitor, IFormField.class);
            return visitor.isFound();
        }
        return false;
    }

    @Override
    public void exportFormFieldData(AbstractFormFieldData target) {
    }

    @Override
    public void importFormFieldData(AbstractFormFieldData source, boolean valueChangeTriggersEnabled) {
    }

    @Override
    public void storeToXml(Element x) {
        List<ICompositeField> enclosingFieldList = this.getEnclosingFieldList();
        for (ICompositeField field : enclosingFieldList) {
            Element enclosingField = x.getOwnerDocument().createElement("enclosingField");
            this.setXmlFormFieldId(enclosingField, field);
            x.appendChild(enclosingField);
        }
        this.setXmlFormFieldId(x, this);
    }

    @Override
    public List<ICompositeField> getEnclosingFieldList() {
        ArrayList<ICompositeField> enclosingFieldList = new ArrayList<ICompositeField>();
        ICompositeField p = this.getParentField();
        while (p != null) {
            if (!(p instanceof AbstractCompositeField) || ((AbstractCompositeField)p).isTemplateField()) {
                enclosingFieldList.add(0, p);
            }
            p = p.getParentField();
        }
        return enclosingFieldList;
    }

    protected final void setXmlFormFieldId(Element x, IFormField f) {
        x.setAttribute("fieldId", f.getFieldId());
        x.setAttribute("fieldQname", f.getClass().getName());
    }

    @Override
    public void loadFromXml(Element x) {
    }

    @Override
    public final void loadFromXmlString(String xml) {
        if (xml == null) {
            return;
        }
        try {
            Document doc = XmlUtility.getXmlDocument((String)xml);
            Element root = doc.getDocumentElement();
            this.loadFromXml(root);
        }
        catch (Exception e) {
            throw new ProcessingException("Error in AbstractFormField.setXML: ", new Object[]{e});
        }
    }

    @Override
    public final String storeToXmlString() {
        Document x = XmlUtility.createNewXmlDocument((String)"field");
        this.storeToXml(x.getDocumentElement());
        return XmlUtility.wellformDocument((Document)x);
    }

    @Override
    public String getInitialLabel() {
        return this.m_initialLabel;
    }

    @Override
    public void setInitialLabel(String name) {
        this.m_initialLabel = name;
    }

    @Override
    public String getLabel() {
        return this.propertySupport.getPropertyString("label");
    }

    @Override
    public void setLabel(String name) {
        this.propertySupport.setPropertyString("label", name);
    }

    @Override
    public byte getLabelPosition() {
        return this.propertySupport.getPropertyByte("labelPosition");
    }

    @Override
    public void setLabelPosition(byte position) {
        this.propertySupport.setPropertyByte("labelPosition", position);
    }

    @Override
    public int getLabelWidthInPixel() {
        return this.propertySupport.getPropertyInt("labelWidthInPixel");
    }

    @Override
    public void setLabelWidthInPixel(int w) {
        this.propertySupport.setPropertyInt("labelWidthInPixel", w);
    }

    @Override
    public byte getLabelHorizontalAlignment() {
        return this.m_labelHorizontalAlignment;
    }

    @Override
    public void setLabelHorizontalAlignment(byte a) {
        this.m_labelHorizontalAlignment = a;
    }

    @Override
    public String getFullyQualifiedLabel(String separator) {
        String s;
        StringBuilder b = new StringBuilder();
        ICompositeField p = this.getParentField();
        if (p != null && (s = p.getFullyQualifiedLabel(separator)) != null) {
            b.append(s);
        }
        if ((s = this.getLabel()) != null) {
            if (b.length() > 0) {
                b.append(separator);
            }
            b.append(s);
        }
        return b.toString();
    }

    @Override
    public boolean isLabelVisible() {
        return this.propertySupport.getPropertyBool("labelVisible");
    }

    @Override
    public void setLabelVisible(boolean labelVisible) {
        this.setLabelVisible(labelVisible, LABEL_VISIBLE);
    }

    @Override
    public void setLabelVisible(boolean visible, String dimension) {
        this.m_labelVisible = LABEL_VISIBLE_BIT_HELPER.changeBit(dimension, visible, this.m_labelVisible);
        this.calculateLabelVisibleInternal();
    }

    @Override
    public boolean isLabelVisible(String dimension) {
        return LABEL_VISIBLE_BIT_HELPER.isBitSet(dimension, this.m_labelVisible);
    }

    protected void calculateLabelVisibleInternal() {
        this.propertySupport.setPropertyBool("labelVisible", NamedBitMaskHelper.allBitsSet((byte)this.m_labelVisible));
    }

    @Override
    public void setLabelHtmlEnabled(boolean labelHtmlEnabled) {
        this.propertySupport.setProperty("labelHtmlEnabled", (Object)labelHtmlEnabled);
    }

    @Override
    public boolean isLabelHtmlEnabled() {
        return this.propertySupport.getPropertyBool("labelHtmlEnabled");
    }

    private void setEnabledSlave(boolean enabled) {
        this.setEnabled(enabled, ENABLED_SLAVE);
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        if (enabled) {
            this.setEnabledSlave(true);
        }
    }

    @Override
    public void setFieldStyle(String fieldStyle) {
        this.setFieldStyle(fieldStyle, this.isInitConfigDone());
    }

    @Override
    public void setFieldStyle(String fieldStyle, boolean recursive) {
        this.propertySupport.setPropertyString("fieldStyle", fieldStyle);
        if (recursive) {
            for (IFormField f : this.getFirstChildFormFields(true)) {
                f.setFieldStyle(fieldStyle, true);
            }
        }
    }

    @Override
    public String getFieldStyle() {
        return this.propertySupport.getPropertyString("fieldStyle");
    }

    @Override
    public void setDisabledStyle(int disabledStyle) {
        this.setDisabledStyle(disabledStyle, this.isInitConfigDone());
    }

    @Override
    public void setDisabledStyle(int disabledStyle, boolean recursive) {
        this.propertySupport.setPropertyInt("disabledStyle", disabledStyle);
        if (recursive) {
            for (IFormField f : this.getFirstChildFormFields(true)) {
                f.setDisabledStyle(disabledStyle, true);
            }
        }
    }

    @Override
    public int getDisabledStyle() {
        return this.propertySupport.getPropertyInt("disabledStyle");
    }

    @Override
    public Permission getVisiblePermission() {
        return this.m_visiblePermission;
    }

    @Override
    public void setVisiblePermission(Permission p) {
        this.m_visiblePermission = p;
        boolean b = true;
        if (p != null) {
            b = ACCESS.check((Permission)p);
        }
        this.setVisibleGranted(b);
    }

    @Override
    public final boolean isSaveNeeded() {
        return this.propertySupport.getPropertyBool("saveNeeded");
    }

    @Override
    public final void checkSaveNeeded() {
        if (this.isInitConfigDone()) {
            try {
                this.propertySupport.setPropertyBool("saveNeeded", this.isTouched() || this.interceptIsSaveNeeded());
            }
            catch (RuntimeException | PlatformError e) {
                ((ExceptionHandler)BEANS.get(ExceptionHandler.class)).handle(e);
            }
        }
    }

    private boolean isTouched() {
        return FLAGS_BIT_HELPER.isBitSet(TOUCHED, this.m_flags);
    }

    private void setTouched(boolean touched) {
        this.m_flags = FLAGS_BIT_HELPER.changeBit(TOUCHED, touched, this.m_flags);
    }

    @Override
    public void touch() {
        this.setTouched(true);
        this.checkSaveNeeded();
    }

    @Override
    public final void markSaved() {
        for (IFormField f : this.getFirstChildFormFields(false)) {
            f.markSaved();
        }
        try {
            this.setTouched(false);
            this.interceptMarkSaved();
            this.checkSaveNeeded();
        }
        catch (RuntimeException | PlatformError e) {
            ((ExceptionHandler)BEANS.get(ExceptionHandler.class)).handle(e);
        }
    }

    @Override
    public final boolean isEmpty() {
        return this.propertySupport.getPropertyBool("empty");
    }

    protected final void checkEmpty() {
        if (this.isInitConfigDone()) {
            try {
                this.propertySupport.setPropertyBool("empty", this.interceptIsEmpty());
            }
            catch (RuntimeException | PlatformError e) {
                ((ExceptionHandler)BEANS.get(ExceptionHandler.class)).handle(e);
            }
        }
    }

    @Override
    public boolean isVisibleGranted() {
        return this.isVisible("VISIBLE_GRANTED");
    }

    @Override
    public void setVisibleGranted(boolean visible) {
        this.setVisibleGranted(visible, false);
    }

    @Override
    public void setVisibleGranted(boolean visible, boolean updateParents) {
        this.setVisibleGranted(visible, updateParents, false);
    }

    @Override
    public void setVisibleGranted(boolean visible, boolean updateParents, boolean updateChildren) {
        this.setVisible(visible, updateParents, updateChildren, "VISIBLE_GRANTED");
    }

    @Override
    public boolean isVisible() {
        return this.propertySupport.getPropertyBool("visible");
    }

    @Override
    public void setVisible(boolean visible) {
        this.setVisible(visible, false);
    }

    @Override
    public void setVisible(boolean visible, boolean updateParents) {
        this.setVisible(visible, updateParents, false);
    }

    @Override
    public void setVisible(boolean visible, boolean updateParents, boolean updateChildren) {
        this.setVisible(visible, updateParents, updateChildren, "VISIBLE");
    }

    @Override
    public void setVisible(boolean visible, boolean updateParents, String dimension) {
        this.setVisible(visible, updateParents, false, dimension);
    }

    @Override
    public void setVisible(boolean visible, boolean updateParents, boolean updateChildren, String dimension) {
        this.m_visible = VISIBLE_BIT_HELPER.changeBit(dimension, visible, this.m_visible);
        this.calculateVisibleInternal();
        if (visible && updateParents) {
            this.visitParents((T field) -> {
                field.setVisible(true, dimension);
                return true;
            }, IFormField.class);
        }
        if (updateChildren) {
            for (IWidget iWidget : this.getChildren()) {
                Consumer<IFormField> visitor = field -> field.setVisible(visible, dimension);
                iWidget.visit(visitor, IFormField.class);
            }
        }
    }

    @Override
    public void setVisible(boolean visible, String dimension) {
        this.setVisible(visible, false, dimension);
    }

    @ConfigOperation
    protected boolean execCalculateVisible() {
        return true;
    }

    public boolean isVisible(String dimension) {
        return VISIBLE_BIT_HELPER.isBitSet(dimension, this.m_visible);
    }

    @Override
    public boolean isVisibleIncludingParents() {
        if (!this.isVisible()) {
            return false;
        }
        Predicate<IFormField> visitor = IFormField::isVisible;
        return this.visitParents(visitor, IFormField.class);
    }

    protected void calculateVisibleInternal() {
        boolean changed = this.propertySupport.setPropertyBool("visible", NamedBitMaskHelper.allBitsSet((byte)this.m_visible) && this.interceptCalculateVisible());
        if (!changed) {
            return;
        }
        IForm form = this.getForm();
        if (form != null) {
            form.structureChanged(this);
        }
    }

    @Override
    public boolean isMandatory() {
        return this.propertySupport.getPropertyBool("mandatory");
    }

    @Override
    public void setMandatory(boolean b) {
        this.setMandatory(b, this.isInitConfigDone());
    }

    @Override
    public void setMandatory(boolean b, boolean recursive) {
        this.propertySupport.setPropertyBool("mandatory", b);
        if (recursive) {
            for (IFormField f : this.getFirstChildFormFields(false)) {
                f.setMandatory(b, true);
            }
        }
    }

    public double getOrder() {
        return this.propertySupport.getPropertyDouble("order");
    }

    public void setOrder(double order) {
        this.propertySupport.setPropertyDouble("order", order);
    }

    @Override
    public IMultiStatus getErrorStatus() {
        MultiStatus ms = this.getErrorStatusInternal();
        return ms == null ? null : new MultiStatus((IMultiStatus)ms);
    }

    protected MultiStatus getErrorStatusInternal() {
        return (MultiStatus)this.propertySupport.getProperty("errorStatus");
    }

    @Override
    public void setErrorStatus(IMultiStatus status) {
        this.setErrorStatusInternal(new MultiStatus(status));
    }

    protected void setErrorStatusInternal(MultiStatus status) {
        this.propertySupport.setProperty("errorStatus", (Object)status);
    }

    @Override
    public void clearErrorStatus() {
        this.propertySupport.setProperty("errorStatus", null);
    }

    @Override
    public void addErrorStatus(String message) {
        this.addErrorStatus(new DefaultFieldStatus(message));
    }

    @Override
    public void addErrorStatus(IStatus newStatus) {
        MultiStatus status = this.ensureMultiStatus((IStatus)this.getErrorStatusInternal());
        MultiStatus copy = new MultiStatus((IMultiStatus)status);
        copy.add(newStatus);
        this.setErrorStatus((IMultiStatus)copy);
    }

    @Override
    public void removeErrorStatus(Class<? extends IStatus> statusClazz) {
        MultiStatus ms = this.getErrorStatusInternal();
        if (ms != null && ms.containsStatus(statusClazz)) {
            MultiStatus copy = new MultiStatus((IMultiStatus)ms);
            copy.removeAll(statusClazz);
            if (copy.getChildren().isEmpty()) {
                this.clearErrorStatus();
            } else {
                this.setErrorStatusInternal(copy);
            }
        }
    }

    private MultiStatus ensureMultiStatus(IStatus s) {
        if (s instanceof MultiStatus) {
            return (MultiStatus)s;
        }
        MultiStatus ms = new MultiStatus();
        if (s != null) {
            ms.add(s);
        }
        return ms;
    }

    @Override
    public IValidateContentDescriptor validateContent() {
        if (!this.isContentValid()) {
            return new ValidateFormFieldDescriptor(this);
        }
        return null;
    }

    @Override
    public boolean isContentValid() {
        return !this.hasError() && this.isMandatoryFulfilled();
    }

    @Override
    public boolean isMandatoryFulfilled() {
        return !this.isMandatory() || !this.isEmpty();
    }

    protected boolean hasError() {
        IMultiStatus errorStatus = this.getErrorStatus();
        return errorStatus != null && errorStatus.getSeverity() >= 0x1000000;
    }

    @Override
    public void setTooltipText(String text) {
        this.propertySupport.setPropertyString("tooltipText", text);
    }

    @Override
    public String getTooltipText() {
        return this.propertySupport.getPropertyString("tooltipText");
    }

    @Override
    public void setTooltipAnchor(String tooltipAnchor) {
        this.propertySupport.setPropertyString("tooltipAnchor", tooltipAnchor);
    }

    @Override
    public String getTooltipAnchor() {
        return this.propertySupport.getPropertyString("tooltipAnchor");
    }

    @Override
    public void setForegroundColor(String c) {
        this.propertySupport.setProperty("foregroundColor", (Object)c);
    }

    @Override
    public String getForegroundColor() {
        return (String)this.propertySupport.getProperty("foregroundColor");
    }

    @Override
    public void setBackgroundColor(String c) {
        this.propertySupport.setProperty("backgroundColor", (Object)c);
    }

    @Override
    public String getBackgroundColor() {
        return (String)this.propertySupport.getProperty("backgroundColor");
    }

    @Override
    public void setFont(FontSpec f) {
        this.propertySupport.setProperty("font", (Object)f);
    }

    @Override
    public FontSpec getFont() {
        return (FontSpec)this.propertySupport.getProperty("font");
    }

    @Override
    public void setLabelForegroundColor(String c) {
        this.propertySupport.setProperty("labelForegroundColor", (Object)c);
    }

    @Override
    public String getLabelForegroundColor() {
        return (String)this.propertySupport.getProperty("labelForegroundColor");
    }

    @Override
    public void setLabelBackgroundColor(String c) {
        this.propertySupport.setProperty("labelBackgroundColor", (Object)c);
    }

    @Override
    public String getLabelBackgroundColor() {
        return (String)this.propertySupport.getProperty("labelBackgroundColor");
    }

    @Override
    public void setLabelFont(FontSpec f) {
        this.propertySupport.setProperty("labelFont", (Object)f);
    }

    @Override
    public FontSpec getLabelFont() {
        return (FontSpec)this.propertySupport.getProperty("labelFont");
    }

    @Override
    public GridData getGridData() {
        return (GridData)this.propertySupport.getProperty("gridData");
    }

    @Override
    public void setGridDataInternal(GridData data) {
        this.propertySupport.setProperty("gridData", (Object)data);
    }

    @Override
    public GridData getGridDataHints() {
        return new GridData((GridData)this.propertySupport.getProperty("gridDataHints"));
    }

    @Override
    public void setGridDataHints(GridData hints) {
        this.propertySupport.setProperty("gridDataHints", (Object)new GridData(hints));
    }

    @Override
    public void requestFocus() {
        IForm form = this.getForm();
        if (form != null) {
            form.requestFocus(this);
        }
    }

    @Override
    public void requestInput() {
        IForm form = this.getForm();
        if (form != null) {
            form.requestInput(this);
        }
    }

    @Override
    public void setPreventInitialFocus(boolean preventInitialFocus) {
        this.propertySupport.setPropertyBool("preventInitialFocus", preventInitialFocus);
    }

    @Override
    public boolean isPreventInitialFocus() {
        return this.propertySupport.getPropertyBool("preventInitialFocus");
    }

    @Override
    public void setMasterField(IValueField field) {
        IValueField oldMasterField = this.getMasterField();
        if (oldMasterField != null && this.m_currentMasterListener != null) {
            oldMasterField.removeMasterListener(this.m_currentMasterListener);
            this.m_currentMasterListener = null;
        }
        if (field != null) {
            this.m_currentMasterListener = new P_MasterListener();
            field.addMasterListener(this.m_currentMasterListener);
            this.setEnabledSlave(field.getValue() != null || !this.isMasterRequired());
        }
        this.m_masterField = field;
    }

    @Override
    public IValueField getMasterField() {
        return this.m_masterField;
    }

    @Override
    public Object getMasterValue() {
        if (this.getMasterField() != null) {
            return this.getMasterField().getValue();
        }
        return null;
    }

    @Override
    public void setMasterRequired(boolean masterRequired) {
        this.m_flags = FLAGS_BIT_HELPER.changeBit(MASTER_REQUIRED, masterRequired, this.m_flags);
    }

    @Override
    public boolean isMasterRequired() {
        return FLAGS_BIT_HELPER.isBitSet(MASTER_REQUIRED, this.m_flags);
    }

    @Override
    public void updateKeyStrokes() {
        this.m_objectExtensions.runInExtensionContext(() -> {
            this.m_contributionHolder.resetContributionsByClass((Object)this, IKeyStroke.class);
            List<IKeyStroke> keyStrokes = this.initLocalKeyStrokes();
            this.propertySupport.setPropertyList("keyStrokes", keyStrokes);
        });
    }

    protected List<IKeyStroke> initLocalKeyStrokes() {
        List<Class<? extends IKeyStroke>> configuredKeyStrokes = this.getConfiguredKeyStrokes();
        List contributedKeyStrokes = this.m_contributionHolder.getContributionsByClass(IKeyStroke.class);
        HashMap<String, IKeyStroke> ksMap = new HashMap<String, IKeyStroke>(configuredKeyStrokes.size() + contributedKeyStrokes.size());
        for (Class<? extends IKeyStroke> keystrokeClazz : configuredKeyStrokes) {
            IKeyStroke ks = (IKeyStroke)ConfigurationUtility.newInnerInstance((Object)this, keystrokeClazz);
            ks.init();
            if (ks.getKeyStroke() == null) continue;
            ksMap.put(ks.getKeyStroke().toUpperCase(), ks);
        }
        for (IKeyStroke ks : contributedKeyStrokes) {
            ks.init();
            if (ks.getKeyStroke() == null) continue;
            ksMap.put(ks.getKeyStroke().toUpperCase(), ks);
        }
        return CollectionUtility.arrayListWithoutNullElements(ksMap.values());
    }

    @Override
    public List<IKeyStroke> getKeyStrokes() {
        return CollectionUtility.arrayList(this.getKeyStrokesInternal());
    }

    protected List<IKeyStroke> getKeyStrokesInternal() {
        return this.propertySupport.getPropertyList("keyStrokes");
    }

    @Override
    public boolean isStatusVisible() {
        return this.propertySupport.getPropertyBool("statusVisible");
    }

    @Override
    public void setStatusVisible(boolean statusVisible) {
        this.setStatusVisible(statusVisible, this.isInitConfigDone());
    }

    @Override
    public void setStatusVisible(boolean statusVisible, boolean recursive) {
        this.propertySupport.setPropertyBool("statusVisible", statusVisible);
        if (recursive) {
            for (IFormField f : this.getFirstChildFormFields(true)) {
                f.setStatusVisible(statusVisible, true);
            }
        }
    }

    @Override
    public String getStatusPosition() {
        return this.propertySupport.getPropertyString("statusPosition");
    }

    @Override
    public void setStatusPosition(String statusPosition) {
        this.propertySupport.setPropertyString("statusPosition", statusPosition);
    }

    protected void handleChildFieldVisibilityChanged() {
    }

    protected void removeChildFieldPropertyChangeListener(IPropertyObserver f) {
        f.removePropertyChangeListener((PropertyChangeListener)this.m_fieldPropertyChangeListener);
    }

    protected void addChildFieldPropertyChangeListener(IPropertyObserver f) {
        f.addPropertyChangeListener((PropertyChangeListener)this.m_fieldPropertyChangeListener);
    }

    protected final void interceptDataChanged(Object ... dataTypes) {
        List<? extends IFormFieldExtension<? extends AbstractFormField>> extensions = this.getAllExtensions();
        FormFieldChains.FormFieldDataChangedChain chain = new FormFieldChains.FormFieldDataChangedChain(extensions);
        chain.execDataChanged(dataTypes);
    }

    protected final void interceptAddSearchTerms(SearchFilter search) {
        List<? extends IFormFieldExtension<? extends AbstractFormField>> extensions = this.getAllExtensions();
        FormFieldChains.FormFieldAddSearchTermsChain chain = new FormFieldChains.FormFieldAddSearchTermsChain(extensions);
        chain.execAddSearchTerms(search);
    }

    protected final void interceptChangedMasterValue(Object newMasterValue) {
        List<? extends IFormFieldExtension<? extends AbstractFormField>> extensions = this.getAllExtensions();
        FormFieldChains.FormFieldChangedMasterValueChain chain = new FormFieldChains.FormFieldChangedMasterValueChain(extensions);
        chain.execChangedMasterValue(newMasterValue);
    }

    protected final void interceptDisposeField() {
        List<? extends IFormFieldExtension<? extends AbstractFormField>> extensions = this.getAllExtensions();
        FormFieldChains.FormFieldDisposeFieldChain chain = new FormFieldChains.FormFieldDisposeFieldChain(extensions);
        chain.execDisposeField();
    }

    protected final void interceptInitField() {
        List<? extends IFormFieldExtension<? extends AbstractFormField>> extensions = this.getAllExtensions();
        FormFieldChains.FormFieldInitFieldChain chain = new FormFieldChains.FormFieldInitFieldChain(extensions);
        chain.execInitField();
    }

    protected final boolean interceptCalculateVisible() {
        List<? extends IFormFieldExtension<? extends AbstractFormField>> extensions = this.getAllExtensions();
        FormFieldChains.FormFieldCalculateVisibleChain chain = new FormFieldChains.FormFieldCalculateVisibleChain(extensions);
        return chain.execCalculateVisible();
    }

    protected final void interceptMarkSaved() {
        List<? extends IFormFieldExtension<? extends AbstractFormField>> extensions = this.getAllExtensions();
        FormFieldChains.FormFieldMarkSavedChain chain = new FormFieldChains.FormFieldMarkSavedChain(extensions);
        chain.execMarkSaved();
    }

    protected final boolean interceptIsEmpty() {
        List<? extends IFormFieldExtension<? extends AbstractFormField>> extensions = this.getAllExtensions();
        FormFieldChains.FormFieldIsEmptyChain chain = new FormFieldChains.FormFieldIsEmptyChain(extensions);
        return chain.execIsEmpty();
    }

    protected final boolean interceptIsSaveNeeded() {
        List<? extends IFormFieldExtension<? extends AbstractFormField>> extensions = this.getAllExtensions();
        FormFieldChains.FormFieldIsSaveNeededChain chain = new FormFieldChains.FormFieldIsSaveNeededChain(extensions);
        return chain.execIsSaveNeeded();
    }

    private final class FindClassIdVisitor
    implements IBreadthFirstTreeVisitor<IFormField> {
        private final String m_currentClassId;
        private boolean m_found = false;
        private final AbstractFormField m_fixedField;

        private FindClassIdVisitor(String currentClassId, AbstractFormField fixedField) {
            this.m_currentClassId = currentClassId;
            this.m_fixedField = fixedField;
        }

        public TreeVisitResult visit(IFormField element, int level, int index) {
            if (this.m_fixedField != element && this.m_currentClassId.equals(ConfigurationUtility.getAnnotatedClassIdWithFallback(element.getClass(), (boolean)true))) {
                this.m_found = true;
                return TreeVisitResult.TERMINATE;
            }
            return TreeVisitResult.CONTINUE;
        }

        public boolean isFound() {
            return this.m_found;
        }
    }

    protected static class LocalFormFieldExtension<OWNER extends AbstractFormField>
    extends AbstractExtension<OWNER>
    implements IFormFieldExtension<OWNER> {
        public LocalFormFieldExtension(OWNER owner) {
            super(owner);
        }

        @Override
        public void execDataChanged(FormFieldChains.FormFieldDataChangedChain chain, Object ... dataTypes) {
            ((AbstractFormField)this.getOwner()).execDataChanged(dataTypes);
        }

        @Override
        public void execAddSearchTerms(FormFieldChains.FormFieldAddSearchTermsChain chain, SearchFilter search) {
            ((AbstractFormField)this.getOwner()).execAddSearchTerms(search);
        }

        @Override
        public void execChangedMasterValue(FormFieldChains.FormFieldChangedMasterValueChain chain, Object newMasterValue) {
            ((AbstractFormField)this.getOwner()).execChangedMasterValue(newMasterValue);
        }

        @Override
        public void execDisposeField(FormFieldChains.FormFieldDisposeFieldChain chain) {
            ((AbstractFormField)this.getOwner()).execDisposeField();
        }

        @Override
        public void execInitField(FormFieldChains.FormFieldInitFieldChain chain) {
            ((AbstractFormField)this.getOwner()).execInitField();
        }

        @Override
        public boolean execCalculateVisible(FormFieldChains.FormFieldCalculateVisibleChain chain) {
            return ((AbstractFormField)this.getOwner()).execCalculateVisible();
        }

        @Override
        public void execMarkSaved(FormFieldChains.FormFieldMarkSavedChain chain) {
            ((AbstractFormField)this.getOwner()).execMarkSaved();
        }

        @Override
        public boolean execIsEmpty(FormFieldChains.FormFieldIsEmptyChain chain) {
            return ((AbstractFormField)this.getOwner()).execIsEmpty();
        }

        @Override
        public boolean execIsSaveNeeded(FormFieldChains.FormFieldIsSaveNeededChain chain) {
            return ((AbstractFormField)this.getOwner()).execIsSaveNeeded();
        }
    }

    class P_FieldPropertyChangeListener
    implements PropertyChangeListener {
        P_FieldPropertyChangeListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent e) {
            if ("visible".equals(e.getPropertyName())) {
                AbstractFormField.this.handleChildFieldVisibilityChanged();
            } else if ("saveNeeded".equals(e.getPropertyName())) {
                AbstractFormField.this.checkSaveNeeded();
            } else if ("empty".equals(e.getPropertyName())) {
                AbstractFormField.this.checkEmpty();
            }
        }
    }

    private class P_MasterListener
    implements MasterListener {
        private P_MasterListener() {
        }

        @Override
        public void masterChanged(Object newMasterValue) {
            if (this == AbstractFormField.this.m_currentMasterListener) {
                AbstractFormField.this.setEnabledSlave(newMasterValue != null || !AbstractFormField.this.isMasterRequired());
                try {
                    AbstractFormField.this.interceptChangedMasterValue(newMasterValue);
                }
                catch (RuntimeException | PlatformError e) {
                    ((ExceptionHandler)BEANS.get(ExceptionHandler.class)).handle(e);
                }
            }
        }
    }
}

