/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.client.ui.form.fields;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.scout.rt.client.ui.form.fields.IFormField;
import org.eclipse.scout.rt.client.ui.form.fields.IFormFieldFilter;

public class ExcludeFormFieldFilter
implements IFormFieldFilter {
    private Set<String> m_excludedFields;

    public ExcludeFormFieldFilter(IFormField ... fields) {
        if (fields != null && fields.length > 0) {
            this.m_excludedFields = new HashSet<String>(fields.length);
            IFormField[] iFormFieldArray = fields;
            int n = fields.length;
            int n2 = 0;
            while (n2 < n) {
                IFormField f = iFormFieldArray[n2];
                if (f != null) {
                    this.m_excludedFields.add(f.getFieldId());
                }
                ++n2;
            }
        }
    }

    @Override
    public boolean accept(IFormField field) {
        if (this.m_excludedFields == null) {
            return true;
        }
        if (field == null) {
            return false;
        }
        return !this.m_excludedFields.contains(field.getFieldId());
    }
}

