/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.client.ui.form.fields.bigintegerfield;

import java.math.BigDecimal;
import java.math.BigInteger;
import org.eclipse.scout.rt.client.extension.ui.form.fields.bigintegerfield.IBigIntegerFieldExtension;
import org.eclipse.scout.rt.client.ui.form.fields.bigintegerfield.IBigIntegerField;
import org.eclipse.scout.rt.client.ui.form.fields.numberfield.AbstractNumberField;
import org.eclipse.scout.rt.platform.Order;
import org.eclipse.scout.rt.platform.annotations.ConfigProperty;
import org.eclipse.scout.rt.platform.classid.ClassId;

@ClassId(value="4c09f9f0-84fe-4c6c-95dd-1f51e92058d8")
public abstract class AbstractBigIntegerField
extends AbstractNumberField<BigInteger>
implements IBigIntegerField {
    private static final BigInteger DEFAULT_MIN_VALUE = new BigInteger("-999999999999999999999999999999999999999999999999999999999999");
    private static final BigInteger DEFAULT_MAX_VALUE = new BigInteger("999999999999999999999999999999999999999999999999999999999999");

    public AbstractBigIntegerField() {
        this(true);
    }

    public AbstractBigIntegerField(boolean callInitializer) {
        super(callInitializer);
    }

    @Override
    @ConfigProperty(value="BIG_INTEGER")
    @Order(value=250.0)
    protected BigInteger getConfiguredMinValue() {
        return DEFAULT_MIN_VALUE;
    }

    @Override
    @ConfigProperty(value="BIG_INTEGER")
    @Order(value=260.0)
    protected BigInteger getConfiguredMaxValue() {
        return DEFAULT_MAX_VALUE;
    }

    @Override
    protected BigInteger getMinPossibleValue() {
        return DEFAULT_MIN_VALUE;
    }

    @Override
    protected BigInteger getMaxPossibleValue() {
        return DEFAULT_MAX_VALUE;
    }

    @Override
    protected BigInteger parseValueInternal(String text) {
        BigInteger retVal = null;
        BigDecimal parsedVal = this.parseToBigDecimalInternal(text);
        if (parsedVal != null) {
            retVal = parsedVal.toBigIntegerExact();
        }
        return retVal;
    }

    @Override
    protected IBigIntegerFieldExtension<? extends AbstractBigIntegerField> createLocalExtension() {
        return new LocalBigIntegerFieldExtension<AbstractBigIntegerField>(this);
    }

    protected static class LocalBigIntegerFieldExtension<OWNER extends AbstractBigIntegerField>
    extends AbstractNumberField.LocalNumberFieldExtension<BigInteger, OWNER>
    implements IBigIntegerFieldExtension<OWNER> {
        public LocalBigIntegerFieldExtension(OWNER owner) {
            super(owner);
        }
    }
}

