/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.client.ui.form.fields.composer.internal;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.scout.rt.client.ui.form.AbstractForm;
import org.eclipse.scout.rt.client.ui.form.AbstractFormHandler;
import org.eclipse.scout.rt.client.ui.form.fields.button.AbstractCancelButton;
import org.eclipse.scout.rt.client.ui.form.fields.button.AbstractOkButton;
import org.eclipse.scout.rt.client.ui.form.fields.composer.AbstractComposerValueBox;
import org.eclipse.scout.rt.client.ui.form.fields.composer.IComposerValueField;
import org.eclipse.scout.rt.client.ui.form.fields.groupbox.AbstractGroupBox;
import org.eclipse.scout.rt.client.ui.form.fields.listbox.AbstractListBox;
import org.eclipse.scout.rt.client.ui.form.fields.sequencebox.AbstractSequenceBox;
import org.eclipse.scout.rt.platform.BEANS;
import org.eclipse.scout.rt.platform.Order;
import org.eclipse.scout.rt.platform.classid.ClassId;
import org.eclipse.scout.rt.platform.exception.ExceptionHandler;
import org.eclipse.scout.rt.platform.exception.PlatformError;
import org.eclipse.scout.rt.platform.text.TEXTS;
import org.eclipse.scout.rt.platform.util.CollectionUtility;
import org.eclipse.scout.rt.shared.data.model.IDataModelAttribute;
import org.eclipse.scout.rt.shared.data.model.IDataModelAttributeOp;
import org.eclipse.scout.rt.shared.services.lookup.ILookupRow;
import org.eclipse.scout.rt.shared.services.lookup.LookupRow;

@ClassId(value="d9667ad1-93a3-4675-a158-c1da9931c7df")
public class ComposerAttributeForm
extends AbstractForm {
    private List<IDataModelAttribute> m_validAttributes;
    private List<Object> m_selectedValues;
    private List<String> m_selectedDisplayValues;

    public List<IDataModelAttribute> getAvailableAttributes() {
        return CollectionUtility.arrayList(this.m_validAttributes);
    }

    public void setAvailableAttributes(List<? extends IDataModelAttribute> attributes0) {
        this.m_validAttributes = CollectionUtility.arrayListWithoutNullElements(attributes0);
        this.getAttributeField().loadListBoxData();
    }

    public List<Object> getSelectedValues() {
        return CollectionUtility.arrayList(this.m_selectedValues);
    }

    public void setSelectedValues(List<?> o) {
        this.setSelectedValuesInternal(o);
        this.activateValueField();
    }

    private void setSelectedValuesInternal(List<?> values0) {
        this.m_selectedValues = CollectionUtility.arrayListWithoutNullElements(values0);
    }

    public List<String> getSelectedDisplayValues() {
        return CollectionUtility.arrayList(this.m_selectedDisplayValues);
    }

    public void setSelectedDisplayValues(List<String> s) {
        this.setSelectedDisplayValuesInternal(s);
    }

    private void setSelectedDisplayValuesInternal(List<String> displayValues0) {
        this.m_selectedDisplayValues = CollectionUtility.arrayListWithoutNullElements(displayValues0);
    }

    public IDataModelAttribute getSelectedAttribute() {
        return (IDataModelAttribute)this.getAttributeField().getCheckedKey();
    }

    public void setSelectedAttribute(IDataModelAttribute a) {
        this.getAttributeField().checkKey(a);
    }

    public IDataModelAttributeOp getSelectedOp() {
        return (IDataModelAttributeOp)this.getOperatorField().getCheckedKey();
    }

    public void setSelectedOp(IDataModelAttributeOp op) {
        this.getOperatorField().checkKey(op);
    }

    @Override
    protected String getConfiguredTitle() {
        return TEXTS.get((String)"ExtendedSearchAddAttribute");
    }

    private void activateValueField() {
        IDataModelAttribute att = (IDataModelAttribute)this.getAttributeField().getCheckedKey();
        IDataModelAttributeOp op = (IDataModelAttributeOp)this.getOperatorField().getCheckedKey();
        List<Object> newValues = this.getSelectedValues();
        if (att == null) {
            this.getValueField().clearSelectionContext();
        } else {
            this.getValueField().setSelectionContext(att, op, newValues);
        }
    }

    public MainBox getMainBox() {
        return (MainBox)this.getRootGroupBox();
    }

    public MainBox.SequenceBox.AttributeField getAttributeField() {
        return this.getRootGroupBox().getFieldByClass(MainBox.SequenceBox.AttributeField.class);
    }

    public MainBox.SequenceBox.OperatorField getOperatorField() {
        return this.getRootGroupBox().getFieldByClass(MainBox.SequenceBox.OperatorField.class);
    }

    public MainBox.SequenceBox.ValueField getValueField() {
        return this.getRootGroupBox().getFieldByClass(MainBox.SequenceBox.ValueField.class);
    }

    public MainBox.OkButton getOkButton() {
        return this.getRootGroupBox().getFieldByClass(MainBox.OkButton.class);
    }

    public MainBox.CancelButton getCancelButton() {
        return this.getRootGroupBox().getFieldByClass(MainBox.CancelButton.class);
    }

    public void startNew() {
        this.startInternal(new NewHandler());
    }

    public void startModify() {
        this.startInternal(new ModifyHandler());
    }

    @Order(value=1.0)
    @ClassId(value="1e682698-544a-4636-9332-4a3e0405f257")
    public class MainBox
    extends AbstractGroupBox {
        @Override
        protected int getConfiguredGridColumnCount() {
            return 2;
        }

        @Order(value=101.0)
        @ClassId(value="83c8bafb-ca6a-49e9-9e8e-49414bfb1511")
        public class CancelButton
        extends AbstractCancelButton {
        }

        @Order(value=100.0)
        @ClassId(value="1b3d5630-209e-492e-8d0e-1f1ab7672730")
        public class OkButton
        extends AbstractOkButton {
        }

        @Order(value=1.0)
        @ClassId(value="1f790491-1a71-4252-9209-e9277dbd77d5")
        public class SequenceBox
        extends AbstractSequenceBox {
            @Override
            protected boolean getConfiguredLabelVisible() {
                return false;
            }

            @Override
            protected int getConfiguredGridW() {
                return 2;
            }

            @Override
            protected int getConfiguredGridH() {
                return 12;
            }

            @Override
            protected boolean getConfiguredAutoCheckFromTo() {
                return false;
            }

            @Order(value=1.0)
            @ClassId(value="4d2fc7d9-186e-4ea6-bce8-cb35c1f3b35b")
            public class AttributeField
            extends AbstractListBox<IDataModelAttribute> {
                @Override
                protected String getConfiguredLabel() {
                    return TEXTS.get((String)"Attribute");
                }

                @Override
                protected List<ILookupRow<IDataModelAttribute>> execLoadTableData() {
                    List<IDataModelAttribute> a = ComposerAttributeForm.this.getAvailableAttributes();
                    ArrayList<ILookupRow<IDataModelAttribute>> result = new ArrayList<ILookupRow<IDataModelAttribute>>(a.size());
                    for (IDataModelAttribute attribute : a) {
                        if (!attribute.isVisible()) continue;
                        result.add((ILookupRow<IDataModelAttribute>)new LookupRow((Object)attribute, attribute.getText()).withIconId(attribute.getIconId()));
                    }
                    return result;
                }

                @Override
                protected boolean getConfiguredMandatory() {
                    return true;
                }

                @Override
                protected boolean getConfiguredLabelVisible() {
                    return false;
                }

                @Override
                protected int getConfiguredGridH() {
                    return 12;
                }

                @Override
                protected void execInitField() {
                    this.getTable().setMultiCheck(false);
                }

                @Override
                protected void execChangedValue() {
                    try {
                        Object ops;
                        IDataModelAttributeOp oldOp = (IDataModelAttributeOp)ComposerAttributeForm.this.getOperatorField().getCheckedKey();
                        ComposerAttributeForm.this.getOperatorField().loadListBoxData();
                        ComposerAttributeForm.this.getOperatorField().checkKey(oldOp);
                        if (ComposerAttributeForm.this.getOperatorField().getCheckedKey() == null && CollectionUtility.hasElements((Collection)(ops = ComposerAttributeForm.this.getOperatorField().getValue()))) {
                            ComposerAttributeForm.this.getOperatorField().checkKey((IDataModelAttributeOp)CollectionUtility.firstElement((Collection)ops));
                        }
                    }
                    catch (RuntimeException | PlatformError e) {
                        ((ExceptionHandler)BEANS.get(ExceptionHandler.class)).handle(e);
                    }
                    ComposerAttributeForm.this.activateValueField();
                }
            }

            @Order(value=2.0)
            @ClassId(value="dd082fb2-2f03-41df-be38-ffa9811fa614")
            public class OperatorField
            extends AbstractListBox<IDataModelAttributeOp> {
                @Override
                protected String getConfiguredLabel() {
                    return TEXTS.get((String)"Op");
                }

                @Override
                protected List<ILookupRow<IDataModelAttributeOp>> execLoadTableData() {
                    List ops = null;
                    IDataModelAttribute att = (IDataModelAttribute)ComposerAttributeForm.this.getAttributeField().getCheckedKey();
                    if (att != null) {
                        ops = att.getOperators();
                    }
                    if (ops != null) {
                        ArrayList<ILookupRow<IDataModelAttributeOp>> result = new ArrayList<ILookupRow<IDataModelAttributeOp>>(ops.size());
                        for (IDataModelAttributeOp op : ops) {
                            String text = op.getText();
                            if (text != null && text.contains("{0}")) {
                                text = text.replace("{0}", "n");
                            }
                            if (text != null && text.contains("{1}")) {
                                text = text.replace("{1}", "m");
                            }
                            result.add((ILookupRow<IDataModelAttributeOp>)new LookupRow((Object)op, text));
                        }
                        return result;
                    }
                    return new ArrayList<ILookupRow<IDataModelAttributeOp>>(0);
                }

                @Override
                protected void execChangedValue() {
                    ComposerAttributeForm.this.activateValueField();
                }

                @Override
                protected String getConfiguredIconId() {
                    return null;
                }

                @Override
                protected boolean getConfiguredMandatory() {
                    return true;
                }

                @Override
                protected boolean getConfiguredLabelVisible() {
                    return false;
                }

                @Override
                protected int getConfiguredGridH() {
                    return 12;
                }

                @Override
                protected void execInitField() {
                    this.getTable().setMultiCheck(false);
                }
            }

            @Order(value=3.0)
            @ClassId(value="6fd21045-eee6-41fd-a8d6-ef1cfd40209a")
            public class ValueField
            extends AbstractComposerValueBox {
                @Override
                protected String getConfiguredLabel() {
                    return TEXTS.get((String)"Value");
                }

                @Override
                protected boolean getConfiguredLabelVisible() {
                    return false;
                }

                @Override
                protected int getConfiguredGridH() {
                    return 12;
                }

                @Override
                protected void execChangedValue() {
                    IComposerValueField f = this.getSelectedField();
                    if (f == null) {
                        ComposerAttributeForm.this.setSelectedValuesInternal(null);
                        ComposerAttributeForm.this.setSelectedDisplayValuesInternal(null);
                    } else {
                        ComposerAttributeForm.this.setSelectedValuesInternal(f.getValues());
                        ComposerAttributeForm.this.setSelectedDisplayValuesInternal(f.getTexts());
                    }
                }
            }
        }
    }

    public class ModifyHandler
    extends AbstractFormHandler {
    }

    public class NewHandler
    extends AbstractFormHandler {
        @Override
        protected void execLoad() {
            ComposerAttributeForm.this.getAttributeField().getTable().selectFirstRow();
            ComposerAttributeForm.this.getOperatorField().getTable().selectFirstRow();
        }
    }
}

