/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.client.ui.form.fields.composer.node;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import org.eclipse.scout.rt.client.ui.action.menu.AbstractMenu;
import org.eclipse.scout.rt.client.ui.basic.tree.ITreeNode;
import org.eclipse.scout.rt.client.ui.form.fields.composer.IComposerField;
import org.eclipse.scout.rt.platform.classid.ClassId;
import org.eclipse.scout.rt.platform.text.TEXTS;
import org.eclipse.scout.rt.shared.data.model.IDataModelEntity;

@ClassId(value="08771479-8a4b-42de-bf8c-521215cc214e")
public class AddEntityMenu
extends AbstractMenu {
    private final IComposerField m_field;
    private final ITreeNode m_parentNode;
    private final IDataModelEntity m_entity;
    private PropertyChangeListener m_propertyChangeListener;

    public AddEntityMenu(IComposerField field, ITreeNode parentNode, IDataModelEntity e) {
        super(false);
        this.m_field = field;
        this.m_parentNode = parentNode;
        this.m_entity = e;
        this.callInitializer();
    }

    @Override
    protected void execInitAction() {
        this.setText(String.valueOf(TEXTS.get((String)"ExtendedSearchAddEntityPrefix")) + " " + this.m_entity.getText());
        this.setIconId(this.m_entity.getIconId());
        if (this.m_propertyChangeListener == null) {
            this.m_propertyChangeListener = new P_PropertyChangeListener();
            this.m_entity.addPropertyChangeListener(this.m_propertyChangeListener);
        }
        this.updateVisibility();
    }

    @Override
    public void disposeActionInternal() {
        super.disposeActionInternal();
        if (this.m_propertyChangeListener != null) {
            this.m_entity.removePropertyChangeListener(this.m_propertyChangeListener);
            this.m_propertyChangeListener = null;
        }
    }

    private void updateVisibility() {
        this.setVisible(this.m_entity.isVisible());
    }

    @Override
    protected void execAction() {
        this.m_field.addEntityNode(this.m_parentNode, this.m_entity, false, null, null);
    }

    private class P_PropertyChangeListener
    implements PropertyChangeListener {
        private P_PropertyChangeListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if ("visible".equals(evt.getPropertyName())) {
                AddEntityMenu.this.updateVisibility();
            }
        }
    }
}

