/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.client.ui.form.fields.composer.node;

import java.util.ArrayList;
import org.eclipse.scout.rt.client.ui.action.menu.AbstractMenu;
import org.eclipse.scout.rt.client.ui.action.menu.AbstractMenuSeparator;
import org.eclipse.scout.rt.client.ui.action.menu.IMenu;
import org.eclipse.scout.rt.client.ui.basic.cell.Cell;
import org.eclipse.scout.rt.client.ui.basic.tree.ITreeNode;
import org.eclipse.scout.rt.client.ui.form.fields.composer.IComposerField;
import org.eclipse.scout.rt.client.ui.form.fields.composer.node.AbstractAddAttributeMenu;
import org.eclipse.scout.rt.client.ui.form.fields.composer.node.AbstractComposerNode;
import org.eclipse.scout.rt.platform.Order;
import org.eclipse.scout.rt.platform.classid.ClassId;
import org.eclipse.scout.rt.platform.text.TEXTS;

public class EitherOrNode
extends AbstractComposerNode {
    private boolean m_beginEitherOr;
    private boolean m_negated = false;

    public EitherOrNode(IComposerField composerField, boolean beginEitherOr) {
        super(composerField, false);
        this.m_beginEitherOr = beginEitherOr;
        this.callInitializer();
    }

    public boolean isBeginOfEitherOr() {
        return this.m_beginEitherOr;
    }

    public void setBeginOfEitherOr(boolean b) {
        this.m_beginEitherOr = b;
    }

    public boolean isEndOfEitherOr() {
        ITreeNode next = this.getSiblingAfter();
        return !(next instanceof EitherOrNode) || ((EitherOrNode)next).isBeginOfEitherOr();
    }

    public boolean isNegative() {
        return this.m_negated;
    }

    public void setNegative(boolean b) {
        this.m_negated = b;
    }

    @Override
    protected void execInitTreeNode() {
        ArrayList<IMenu> menus = new ArrayList<IMenu>();
        for (IMenu m : this.getMenus()) {
            if (m.getClass() == AddEntityOnEitherOrPlaceholderMenu.class) {
                this.attachAddEntityMenus(menus);
                continue;
            }
            menus.add(m);
        }
        this.setMenus(menus);
    }

    @Override
    protected void execDecorateCell(Cell cell) {
        String text = "";
        ITreeNode siblingBefore = this.getSiblingBefore();
        if (this.isBeginOfEitherOr() && siblingBefore != null) {
            text = String.valueOf(text) + TEXTS.get((String)"ExtendedSearchAnd") + " ";
        }
        text = this.isBeginOfEitherOr() ? String.valueOf(text) + TEXTS.get((String)"ExtendedSearchEither") : String.valueOf(text) + TEXTS.get((String)"ExtendedSearchOr");
        if (this.isNegative()) {
            text = String.valueOf(text) + " " + TEXTS.get((String)"ExtendedSearchNot");
        }
        cell.setText(text);
    }

    @Order(value=1.0)
    @ClassId(value="86864de8-85bf-4274-a134-2ec8ae602315")
    public class AddAdditionalOrMenu
    extends AbstractMenu {
        @Override
        protected String getConfiguredText() {
            return TEXTS.get((String)"ExtendedSearchAddAdditionalOrMenu");
        }

        @Override
        protected void execAction() {
            EitherOrNode.this.getComposerField().addAdditionalOrNode(EitherOrNode.this, false);
        }
    }

    @Order(value=50.0)
    @ClassId(value="b444ace8-d032-44d0-941a-a261bc48777b")
    public class AddAttributeOnEitherOrMenu
    extends AbstractAddAttributeMenu {
        public AddAttributeOnEitherOrMenu() {
            super(EitherOrNode.this.getComposerField(), EitherOrNode.this);
        }
    }

    @Order(value=5.0)
    @ClassId(value="7a388969-391d-4920-8f90-23759f53f86c")
    public class AddEitherOrMenu
    extends AbstractMenu {
        @Override
        protected String getConfiguredText() {
            return TEXTS.get((String)"ExtendedSearchAddEitherOrMenu");
        }

        @Override
        protected void execAction() {
            EitherOrNode node = EitherOrNode.this.getComposerField().addEitherNode(EitherOrNode.this, false);
            EitherOrNode.this.getComposerField().addAdditionalOrNode(node, false);
        }
    }

    @Order(value=70.0)
    @ClassId(value="567ee492-6de3-4801-a4bc-2476c5392b7c")
    public class AddEntityOnEitherOrPlaceholderMenu
    extends AbstractMenuSeparator {
    }

    @Order(value=30.0)
    @ClassId(value="7461e694-1f88-438f-91b4-93e65db76f3e")
    public class DeleteEitherOrMenu
    extends AbstractMenu {
        @Override
        protected String getConfiguredText() {
            return TEXTS.get((String)"ExtendedSearchRemoveMenu");
        }

        @Override
        protected String getConfiguredKeyStroke() {
            return "delete";
        }

        @Override
        protected void execAction() {
            EitherOrNode eitherOrNode;
            ITreeNode next = EitherOrNode.this.getSiblingAfter();
            if (EitherOrNode.this.isBeginOfEitherOr() && next instanceof EitherOrNode && !(eitherOrNode = (EitherOrNode)next).isBeginOfEitherOr()) {
                eitherOrNode.setBeginOfEitherOr(true);
                eitherOrNode.update();
            }
            EitherOrNode.this.getTree().selectPreviousParentNode();
            EitherOrNode.this.getTree().removeNode(EitherOrNode.this);
        }
    }

    @Order(value=20.0)
    @ClassId(value="b8237afc-8794-498b-a6a5-efa1848ef201")
    public class NegateEitherOrMenu
    extends AbstractMenu {
        @Override
        protected String getConfiguredText() {
            return TEXTS.get((String)"ExtendedSearchNegateMenu");
        }

        @Override
        protected void execAction() {
            EitherOrNode.this.setNegative(!EitherOrNode.this.isNegative());
            if (!EitherOrNode.this.isStatusInserted()) {
                EitherOrNode.this.setStatusInternal(2);
            }
            EitherOrNode.this.update();
        }
    }

    @Order(value=10.0)
    @ClassId(value="28fc0085-83af-4b19-95f7-1ed70c43f1c8")
    public class Separator1Menu
    extends AbstractMenuSeparator {
    }

    @Order(value=40.0)
    @ClassId(value="59c754f8-684b-4eea-80ff-11e1b1b916c2")
    public class Separator2Menu
    extends AbstractMenuSeparator {
    }

    @Order(value=60.0)
    @ClassId(value="1914f76c-4635-4b54-ae29-6ec1857bca90")
    public class Separator3Menu
    extends AbstractMenuSeparator {
    }
}

