/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.client.ui.form.fields.modeselector;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Collection;
import java.util.List;
import org.eclipse.scout.rt.client.ui.IWidget;
import org.eclipse.scout.rt.client.ui.form.fields.AbstractValueField;
import org.eclipse.scout.rt.client.ui.form.fields.mode.IMode;
import org.eclipse.scout.rt.client.ui.form.fields.modeselector.IModeSelectorField;
import org.eclipse.scout.rt.platform.IOrdered;
import org.eclipse.scout.rt.platform.classid.ClassId;
import org.eclipse.scout.rt.platform.exception.ProcessingException;
import org.eclipse.scout.rt.platform.reflect.ConfigurationUtility;
import org.eclipse.scout.rt.platform.util.CollectionUtility;
import org.eclipse.scout.rt.platform.util.ObjectUtility;
import org.eclipse.scout.rt.platform.util.collection.OrderedCollection;

@ClassId(value="0b8931d2-e694-437b-bf31-94ad5a44ad71")
public abstract class AbstractModeSelectorField<T>
extends AbstractValueField<T>
implements IModeSelectorField<T> {
    private boolean m_valueAndSelectionMediatorActive;

    @Override
    protected void initConfig() {
        super.initConfig();
        List<Class<IMode<T>>> configuredModes = this.getConfiguredModes();
        OrderedCollection modes = new OrderedCollection();
        for (Class<IMode<T>> modeClazz : configuredModes) {
            IMode mode = (IMode)ConfigurationUtility.newInnerInstance((Object)this, modeClazz);
            mode.init();
            mode.addPropertyChangeListener(new P_ModePropertyChangeListener());
            modes.addOrdered((IOrdered)mode);
        }
        this.setModesInternal(modes.getOrderedList());
    }

    protected List<Class<? extends IMode<T>>> getConfiguredModes() {
        Class[] dca = ConfigurationUtility.getDeclaredPublicClasses(this.getClass());
        List fca = ConfigurationUtility.filterClasses((Class[])dca, IMode.class);
        return ConfigurationUtility.removeReplacedClasses((List)fca);
    }

    protected void setModesInternal(List<IMode<T>> modes) {
        this.propertySupport.setPropertyList("modes", modes);
    }

    public List<IMode<T>> getModesInternal() {
        return this.propertySupport.getPropertyList("modes");
    }

    @Override
    public List<IMode<T>> getModes() {
        return CollectionUtility.arrayList(this.getModesInternal());
    }

    @Override
    public IMode<T> getModeFor(T value) {
        for (IMode<T> b : this.getModes()) {
            T modeValue = b.getRef();
            if (!ObjectUtility.equals(modeValue, value)) continue;
            return b;
        }
        return null;
    }

    @Override
    public List<? extends IWidget> getChildren() {
        return CollectionUtility.flatten((Collection[])new Collection[]{super.getChildren(), this.getModes()});
    }

    @Override
    protected void valueChangedInternal() {
        super.valueChangedInternal();
        this.syncValueToModes();
    }

    @Override
    protected T validateValueInternal(T rawValue) {
        T validValue;
        if (rawValue == null) {
            validValue = null;
        } else {
            IMode<T> m = this.getModeFor(rawValue);
            if (m != null) {
                validValue = rawValue;
            } else {
                throw new ProcessingException("Illegal mode value: " + rawValue, new Object[0]);
            }
        }
        return validValue;
    }

    private void syncValueToModes() {
        if (this.m_valueAndSelectionMediatorActive) {
            return;
        }
        try {
            this.m_valueAndSelectionMediatorActive = true;
            Object selectedKey = this.getValue();
            IMode selectedMode = this.getModeFor(selectedKey);
            for (IMode<T> m : this.getModes()) {
                m.setSelected(m == selectedMode);
            }
        }
        finally {
            this.m_valueAndSelectionMediatorActive = false;
        }
    }

    private void syncModesToValue(IMode<T> selectedMode) {
        if (this.m_valueAndSelectionMediatorActive) {
            return;
        }
        try {
            this.m_valueAndSelectionMediatorActive = true;
            for (IMode<T> b : this.getModes()) {
                b.setSelected(b == selectedMode);
            }
            this.setValue(selectedMode.getRef());
        }
        finally {
            this.m_valueAndSelectionMediatorActive = false;
        }
    }

    private final class P_ModePropertyChangeListener
    implements PropertyChangeListener {
        private P_ModePropertyChangeListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent e) {
            if (e.getPropertyName().equals("selected") && ((Boolean)e.getNewValue()).booleanValue()) {
                AbstractModeSelectorField.this.syncModesToValue((IMode)e.getSource());
            }
        }
    }
}

