/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.client.ui.form.fields.plannerfield;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.scout.rt.client.extension.ui.form.fields.IFormFieldExtension;
import org.eclipse.scout.rt.client.extension.ui.form.fields.plannerfield.IPlannerFieldExtension;
import org.eclipse.scout.rt.client.extension.ui.form.fields.plannerfield.PlannerFieldChains;
import org.eclipse.scout.rt.client.ui.IWidget;
import org.eclipse.scout.rt.client.ui.basic.planner.AbstractPlanner;
import org.eclipse.scout.rt.client.ui.basic.planner.IPlanner;
import org.eclipse.scout.rt.client.ui.basic.planner.Resource;
import org.eclipse.scout.rt.client.ui.form.fields.AbstractFormField;
import org.eclipse.scout.rt.client.ui.form.fields.plannerfield.IPlannerField;
import org.eclipse.scout.rt.platform.Order;
import org.eclipse.scout.rt.platform.annotations.ConfigOperation;
import org.eclipse.scout.rt.platform.classid.ClassId;
import org.eclipse.scout.rt.platform.reflect.ConfigurationUtility;
import org.eclipse.scout.rt.platform.util.CollectionUtility;

@ClassId(value="9520b5cc-221e-4d0f-8cc3-5c4a1ba06b77")
public abstract class AbstractPlannerField<P extends IPlanner<RI, AI>, RI, AI>
extends AbstractFormField
implements IPlannerField<P> {
    private P m_planner;

    public AbstractPlannerField() {
        this(true);
    }

    public AbstractPlannerField(boolean callInitializer) {
        super(callInitializer);
    }

    private Class<? extends IPlanner> getConfiguredPlanner() {
        Class[] dca = ConfigurationUtility.getDeclaredPublicClasses(this.getClass());
        return ConfigurationUtility.filterClass((Class[])dca, IPlanner.class);
    }

    @Override
    protected int getConfiguredGridH() {
        return 6;
    }

    @Override
    protected void execChangedMasterValue(Object newMasterValue) {
        this.loadResources();
    }

    @Override
    public List<? extends IWidget> getChildren() {
        return CollectionUtility.flatten((Collection[])new Collection[]{super.getChildren(), Collections.singletonList(this.getPlanner())});
    }

    @ConfigOperation
    @Order(value=10.0)
    protected List<Resource<RI>> execLoadResources() {
        return null;
    }

    @ConfigOperation
    @Order(value=20.0)
    protected void execPopulateResources() {
        List resources = this.interceptLoadResources();
        this.getPlanner().replaceResources(resources);
    }

    @Override
    protected void initConfig() {
        Class<IPlanner> configuredPlanner;
        super.initConfig();
        List contributedPlanners = this.m_contributionHolder.getContributionsByClass(IPlanner.class);
        this.m_planner = (IPlanner)CollectionUtility.firstElement((List)contributedPlanners);
        if (this.m_planner == null && (configuredPlanner = this.getConfiguredPlanner()) != null) {
            this.m_planner = (IPlanner)ConfigurationUtility.newInnerInstance((Object)this, configuredPlanner);
        }
        if (this.m_planner == null) {
            throw new IllegalStateException("No planner found.");
        }
        if (this.m_planner instanceof AbstractPlanner) {
            ((AbstractPlanner)this.m_planner).setParentInternal(this);
        }
    }

    @Override
    public final P getPlanner() {
        return this.m_planner;
    }

    @Override
    public void loadResources() {
        this.interceptPopulateResources();
    }

    protected final List<Resource<RI>> interceptLoadResources() {
        List<? extends IFormFieldExtension<? extends AbstractFormField>> extensions = this.getAllExtensions();
        PlannerFieldChains.PlannerFieldLoadResourcesChain chain = new PlannerFieldChains.PlannerFieldLoadResourcesChain(extensions);
        return chain.execLoadResourceTableData();
    }

    protected final void interceptPopulateResources() {
        List<? extends IFormFieldExtension<? extends AbstractFormField>> extensions = this.getAllExtensions();
        PlannerFieldChains.PlannerFieldPopulateResourcesChain chain = new PlannerFieldChains.PlannerFieldPopulateResourcesChain(extensions);
        chain.execPopulateResources();
    }

    protected IPlannerFieldExtension<P, RI, AI, ? extends AbstractPlannerField<P, RI, AI>> createLocalExtension() {
        return new LocalPlannerFieldExtension(this);
    }

    protected static class LocalPlannerFieldExtension<P extends IPlanner<RI, AI>, RI, AI, OWNER extends AbstractPlannerField<P, RI, AI>>
    extends AbstractFormField.LocalFormFieldExtension<OWNER>
    implements IPlannerFieldExtension<P, RI, AI, OWNER> {
        public LocalPlannerFieldExtension(OWNER owner) {
            super(owner);
        }

        @Override
        public List<Resource<RI>> execLoadResources(PlannerFieldChains.PlannerFieldLoadResourcesChain<? extends IPlanner<RI, AI>, RI, AI> chain) {
            return ((AbstractPlannerField)this.getOwner()).execLoadResources();
        }

        @Override
        public void execPopulateResources(PlannerFieldChains.PlannerFieldPopulateResourcesChain<? extends IPlanner<RI, AI>, RI, AI> chain) {
            ((AbstractPlannerField)this.getOwner()).execPopulateResources();
        }
    }
}

