/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.client.ui.form.fields.smartfield;

import org.eclipse.scout.rt.client.ModelContextProxy;
import org.eclipse.scout.rt.client.ui.form.fields.smartfield.AbstractSmartField;
import org.eclipse.scout.rt.client.ui.form.fields.smartfield.IProposalField;
import org.eclipse.scout.rt.client.ui.form.fields.smartfield.IProposalFieldUIFacade;
import org.eclipse.scout.rt.client.ui.form.fields.smartfield.ISmartFieldUIFacade;
import org.eclipse.scout.rt.client.ui.form.fields.smartfield.ProposalFieldUIFacade;
import org.eclipse.scout.rt.platform.BEANS;
import org.eclipse.scout.rt.platform.annotations.ConfigProperty;
import org.eclipse.scout.rt.platform.classid.ClassId;
import org.eclipse.scout.rt.platform.util.StringUtility;
import org.eclipse.scout.rt.shared.services.lookup.ILookupRow;

@ClassId(value="1c8c645d-9e75-4bb1-9f79-c0532d2cdb72")
public abstract class AbstractProposalField<VALUE>
extends AbstractSmartField<VALUE>
implements IProposalField<VALUE> {
    public AbstractProposalField() {
        this(true);
    }

    public AbstractProposalField(boolean callInitializer) {
        super(callInitializer);
    }

    @Override
    protected ISmartFieldUIFacade<VALUE> createUIFacade() {
        return ((ModelContextProxy)BEANS.get(ModelContextProxy.class)).newProxy(new ProposalFieldUIFacade(this), ModelContextProxy.ModelContext.copyCurrent());
    }

    @Override
    protected void initConfig() {
        super.initConfig();
        this.setMaxLength(this.getConfiguredMaxLength());
        this.setTrimText(this.getConfiguredTrimText());
    }

    @ConfigProperty(value="INTEGER")
    protected int getConfiguredMaxLength() {
        return 4000;
    }

    @ConfigProperty(value="BOOLEAN")
    protected boolean getConfiguredTrimText() {
        return true;
    }

    @Override
    public String getValueAsString() {
        return (String)this.getValue();
    }

    @Override
    public void setValueAsString(String value) {
        this.setValue(value);
    }

    @Override
    protected String formatValueInternal(VALUE value) {
        return value != null ? value.toString() : "";
    }

    @Override
    public void setMaxLength(int maxLength) {
        boolean changed = this.propertySupport.setPropertyInt("maxLength", Math.max(0, maxLength));
        if (changed && this.isInitConfigDone()) {
            this.setValue(this.getValue());
        }
    }

    @Override
    public int getMaxLength() {
        return this.propertySupport.getPropertyInt("maxLength");
    }

    @Override
    public void setTrimText(boolean trimText) {
        boolean changed = this.propertySupport.setPropertyBool("trimText", trimText);
        if (trimText && changed && this.isInitConfigDone()) {
            this.setValue(this.getValue());
        }
    }

    @Override
    public boolean isTrimText() {
        return this.propertySupport.getPropertyBool("trimText");
    }

    @Override
    protected VALUE getValueFromLookupRow(ILookupRow<VALUE> row) {
        return (VALUE)row.getText();
    }

    @Override
    public IProposalFieldUIFacade<VALUE> getUIFacade() {
        return (IProposalFieldUIFacade)super.getUIFacade();
    }

    @Override
    protected VALUE validateValueInternal(VALUE rawValue) {
        Object validValue = super.validateValueInternal(rawValue);
        if (validValue != null) {
            String stringValue = (String)validValue;
            if (this.isTrimText()) {
                stringValue = stringValue.trim();
            }
            if (stringValue.length() > this.getMaxLength()) {
                stringValue = stringValue.substring(0, this.getMaxLength());
                if (this.isTrimText()) {
                    stringValue = stringValue.trim();
                }
            }
            if (!this.isMultilineText()) {
                stringValue = StringUtility.trimNewLines((String)stringValue);
                stringValue = stringValue.replaceAll("\r\n", " ").replaceAll("[\r\n]", " ");
            }
            validValue = StringUtility.nullIfEmpty((Object)stringValue);
        }
        return validValue;
    }

    @Override
    protected void valueChangedInternal() {
    }
}

