/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.client.ui.form.fields.tablefield;

import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.TreeSet;
import org.eclipse.scout.rt.client.dto.FormData;
import org.eclipse.scout.rt.client.extension.ui.form.fields.IFormFieldExtension;
import org.eclipse.scout.rt.client.extension.ui.form.fields.tablefield.ITableFieldExtension;
import org.eclipse.scout.rt.client.extension.ui.form.fields.tablefield.TableFieldChains;
import org.eclipse.scout.rt.client.ui.IWidget;
import org.eclipse.scout.rt.client.ui.basic.table.AbstractTable;
import org.eclipse.scout.rt.client.ui.basic.table.ITable;
import org.eclipse.scout.rt.client.ui.basic.table.ITableRow;
import org.eclipse.scout.rt.client.ui.basic.table.TableListener;
import org.eclipse.scout.rt.client.ui.basic.table.columns.IColumn;
import org.eclipse.scout.rt.client.ui.form.fields.AbstractFormField;
import org.eclipse.scout.rt.client.ui.form.fields.IValidateContentDescriptor;
import org.eclipse.scout.rt.client.ui.form.fields.tablefield.ITableField;
import org.eclipse.scout.rt.client.ui.form.fields.tablefield.ValidateTableFieldDescriptor;
import org.eclipse.scout.rt.platform.Order;
import org.eclipse.scout.rt.platform.annotations.ConfigOperation;
import org.eclipse.scout.rt.platform.classid.ClassId;
import org.eclipse.scout.rt.platform.reflect.ConfigurationUtility;
import org.eclipse.scout.rt.platform.status.IStatus;
import org.eclipse.scout.rt.platform.text.TEXTS;
import org.eclipse.scout.rt.platform.util.Assertions;
import org.eclipse.scout.rt.platform.util.BooleanUtility;
import org.eclipse.scout.rt.platform.util.CollectionUtility;
import org.eclipse.scout.rt.platform.util.XmlUtility;
import org.eclipse.scout.rt.shared.data.form.fields.AbstractFormFieldData;
import org.eclipse.scout.rt.shared.data.form.fields.tablefield.AbstractTableFieldBeanData;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;

@ClassId(value="76887bde-6815-4f7d-9cbd-60409b49488d")
@FormData(value=AbstractTableFieldBeanData.class, sdkCommand=FormData.SdkCommand.USE, defaultSubtypeSdkCommand=FormData.DefaultSubtypeSdkCommand.CREATE)
public abstract class AbstractTableField<T extends ITable>
extends AbstractFormField
implements ITableField<T> {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractTableField.class);
    private T m_table;
    private boolean m_tableExternallyManaged;
    private TableListener m_managedTableListener;

    public AbstractTableField() {
        this(true);
    }

    public AbstractTableField(boolean callInitializer) {
        super(callInitializer);
    }

    @ConfigOperation
    @Order(value=190.0)
    protected void execReloadTableData() {
    }

    @ConfigOperation
    @Order(value=200.0)
    protected void execSave(List<? extends ITableRow> insertedRows, List<? extends ITableRow> updatedRows, List<? extends ITableRow> deletedRows) {
    }

    @ConfigOperation
    @Order(value=210.0)
    protected void execSaveDeletedRow(ITableRow row) {
    }

    @ConfigOperation
    @Order(value=220.0)
    protected void execSaveInsertedRow(ITableRow row) {
    }

    @ConfigOperation
    @Order(value=230.0)
    protected void execSaveUpdatedRow(ITableRow row) {
    }

    @Override
    protected void execChangedMasterValue(Object newMasterValue) {
        this.reloadTableData();
    }

    protected Class<? extends ITable> getConfiguredTable() {
        Class[] dca = ConfigurationUtility.getDeclaredPublicClasses(this.getClass());
        List f = ConfigurationUtility.filterClasses((Class[])dca, ITable.class);
        if (f.size() == 1) {
            return (Class)CollectionUtility.firstElement((List)f);
        }
        for (Class c : f) {
            if (c.getDeclaringClass() == AbstractTableField.class) continue;
            return c;
        }
        return null;
    }

    @Override
    protected double getConfiguredGridWeightY() {
        return 1.0;
    }

    @Override
    protected int getConfiguredGridH() {
        return 3;
    }

    @Override
    protected void initConfig() {
        super.initConfig();
        this.setTableInternal(this.createTable());
    }

    protected T createTable() {
        List contributedFields = this.m_contributionHolder.getContributionsByClass(ITable.class);
        ITable result = (ITable)CollectionUtility.firstElement((List)contributedFields);
        if (result != null) {
            return (T)result;
        }
        Class<ITable> configuredTable = this.getConfiguredTable();
        if (configuredTable != null) {
            return (T)((ITable)ConfigurationUtility.newInnerInstance((Object)this, configuredTable));
        }
        return null;
    }

    @Override
    protected void disposeChildren(List<? extends IWidget> widgetsToDispose) {
        if (this.m_tableExternallyManaged) {
            widgetsToDispose.remove(this.getTable());
        }
        super.disposeChildren(widgetsToDispose);
    }

    @Override
    protected void initChildren(List<? extends IWidget> widgets) {
        if (this.m_tableExternallyManaged) {
            widgets.remove(this.getTable());
        }
        super.initChildren(widgets);
    }

    @Override
    public final T getTable() {
        return this.m_table;
    }

    @Override
    public void setTable(T newTable, boolean externallyManaged) {
        this.m_tableExternallyManaged = externallyManaged;
        this.setTableInternal(newTable);
    }

    protected void setTableInternal(T table) {
        boolean changed;
        int i;
        if (this.m_table == table) {
            return;
        }
        if (this.m_table != null) {
            this.m_table.setParentInternal(null);
            if (!this.m_tableExternallyManaged && this.m_managedTableListener != null) {
                this.m_table.removeTableListener(this.m_managedTableListener, new Integer[0]);
                this.m_managedTableListener = null;
            }
            if (this.isInitConfigDone()) {
                i = this.m_valueChangeTriggerEnabled;
                while (i <= 0) {
                    this.m_table.setValueChangeTriggerEnabled(true);
                    ++i;
                }
            }
        }
        this.m_table = table;
        if (this.m_table != null) {
            this.m_table.setParentInternal(this);
            if (!this.m_tableExternallyManaged) {
                this.m_managedTableListener = e -> {
                    this.checkSaveNeeded();
                    this.checkEmpty();
                };
                this.m_table.addTableListener(this.m_managedTableListener, 105, 102, 100, 101, 1);
            }
            if (this.isInitConfigDone()) {
                i = this.m_valueChangeTriggerEnabled;
                while (i <= 0) {
                    this.m_table.setValueChangeTriggerEnabled(false);
                    ++i;
                }
            }
        }
        if (changed = this.propertySupport.setProperty("table", this.m_table)) {
            if (this.getForm() != null) {
                this.getForm().structureChanged(this);
            }
            this.updateKeyStrokes();
        }
    }

    @Override
    public void exportFormFieldData(AbstractFormFieldData target) {
        if (this.m_table != null && target instanceof AbstractTableFieldBeanData) {
            AbstractTableFieldBeanData tableBeanData = (AbstractTableFieldBeanData)target;
            this.m_table.exportToTableBeanData(tableBeanData);
            target.setValueSet(true);
        }
    }

    @Override
    public void importFormFieldData(AbstractFormFieldData source, boolean valueChangeTriggersEnabled) {
        Assertions.assertNotNull((Object)source);
        if (source.isValueSet() && this.m_table != null) {
            try {
                if (!valueChangeTriggersEnabled) {
                    this.setValueChangeTriggerEnabled(false);
                }
                if (source instanceof AbstractTableFieldBeanData) {
                    AbstractTableFieldBeanData tableBeanData = (AbstractTableFieldBeanData)source;
                    this.m_table.importFromTableBeanData(tableBeanData);
                }
                if (this.m_table.isCheckable() && this.m_table.getCheckableColumn() != null) {
                    for (ITableRow row : this.m_table.getRows()) {
                        row.setChecked(BooleanUtility.nvl((Boolean)((Boolean)this.m_table.getCheckableColumn().getValue(row))));
                    }
                }
            }
            finally {
                if (!valueChangeTriggersEnabled) {
                    this.setValueChangeTriggerEnabled(true);
                }
            }
        }
    }

    @Override
    public void loadFromXml(Element x) {
        super.loadFromXml(x);
        if (this.m_table != null) {
            int[] selectedRowIndices = null;
            try {
                selectedRowIndices = (int[])XmlUtility.getObjectAttribute((Element)x, (String)"selectedRowIndices");
            }
            catch (Exception e) {
                LOG.warn("reading attribute 'selectedRowIndices'", (Throwable)e);
            }
            Object[][] dataMatrix = null;
            try {
                dataMatrix = (Object[][])XmlUtility.getObjectAttribute((Element)x, (String)"rows");
            }
            catch (Exception e) {
                LOG.warn("reading attribute 'rows'", (Throwable)e);
            }
            this.m_table.discardAllRows();
            if (dataMatrix != null && dataMatrix.length > 0) {
                this.m_table.addRowsByMatrix(dataMatrix);
            }
            if (selectedRowIndices != null && selectedRowIndices.length > 0) {
                this.m_table.selectRows(this.m_table.getRows(selectedRowIndices));
            }
        }
    }

    @Override
    public void storeToXml(Element x) {
        super.storeToXml(x);
        if (this.m_table != null) {
            List<ITableRow> selectedRows = this.m_table.getSelectedRows();
            int[] selectedRowIndices = new int[selectedRows.size()];
            int i = 0;
            for (ITableRow selrow : selectedRows) {
                selectedRowIndices[i] = selrow.getRowIndex();
                ++i;
            }
            try {
                XmlUtility.setObjectAttribute((Element)x, (String)"selectedRowIndices", (Object)selectedRowIndices);
            }
            catch (Exception e) {
                LOG.warn("writing attribute 'selectedRowIndices'", (Throwable)e);
            }
            Object[][] dataMatrix = this.m_table.getTableData();
            int r = 0;
            while (r < dataMatrix.length) {
                int c = 0;
                while (c < dataMatrix[r].length) {
                    Object o = dataMatrix[r][c];
                    if (o != null && !(o instanceof Serializable)) {
                        LOG.warn("ignoring not serializable value at row={}, col={}: {}[{}]", new Object[]{r, c, o, o.getClass()});
                        dataMatrix[r][c] = null;
                    }
                    ++c;
                }
                ++r;
            }
            try {
                XmlUtility.setObjectAttribute((Element)x, (String)"rows", (Object)dataMatrix);
            }
            catch (Exception e) {
                LOG.warn("writing attribute 'rows'", (Throwable)e);
            }
        }
    }

    @Override
    protected boolean execIsSaveNeeded() {
        boolean saveNeeded = super.execIsSaveNeeded();
        if (saveNeeded) {
            return true;
        }
        if (this.m_table == null || this.m_tableExternallyManaged) {
            return false;
        }
        return this.m_table.getDeletedRowCount() > 0 || this.m_table.getInsertedRowCount() > 0 || this.m_table.getUpdatedRowCount() > 0;
    }

    @Override
    protected void execMarkSaved() {
        super.execMarkSaved();
        if (this.m_table != null && !this.m_tableExternallyManaged) {
            try {
                this.m_table.setTableChanging(true);
                int i = 0;
                while (i < this.m_table.getRowCount()) {
                    ITableRow row = this.m_table.getRow(i);
                    if (!row.isStatusNonchanged()) {
                        row.setStatusNonchanged();
                    }
                    ++i;
                }
                this.m_table.discardAllDeletedRows();
            }
            finally {
                this.m_table.setTableChanging(false);
            }
        }
    }

    @Override
    protected boolean execIsEmpty() {
        if (!super.execIsEmpty()) {
            return false;
        }
        if (this.m_table != null) {
            return this.m_table.getRowCount() == 0;
        }
        return true;
    }

    @Override
    public IValidateContentDescriptor validateContent() {
        IValidateContentDescriptor desc = super.validateContent();
        if (desc != null) {
            return desc;
        }
        T table = this.getTable();
        if (table instanceof AbstractTable) {
            table.completeCellEdit();
        }
        ValidateTableFieldDescriptor tableDesc = null;
        TreeSet<String> columnNames = new TreeSet<String>();
        if (table != null) {
            for (ITableRow row : table.getRows()) {
                for (IColumn<?> col : table.getColumns()) {
                    if (col.isContentValid(row)) continue;
                    if (tableDesc == null) {
                        tableDesc = new ValidateTableFieldDescriptor(this, row, col);
                    }
                    columnNames.add(this.getColumnName(col));
                }
            }
            table.ensureInvalidColumnsVisible();
        }
        if (tableDesc != null) {
            tableDesc.setDisplayText(String.valueOf(TEXTS.get((String)"TableName")) + " " + this.getLabel() + ": " + CollectionUtility.format(columnNames));
        }
        return tableDesc;
    }

    private String getColumnName(IColumn col) {
        String columnName = col.getHeaderCell().getText();
        if (columnName == null) {
            LOG.warn("Validation Error on Column without header text, using className for error message.");
            columnName = col.getClass().getSimpleName();
        }
        return columnName;
    }

    @Override
    public List<? extends IWidget> getChildren() {
        return CollectionUtility.flatten((Collection[])new Collection[]{super.getChildren(), Collections.singletonList(this.getTable())});
    }

    @Override
    public IStatus getTableStatus() {
        T table = this.getTable();
        if (table != null) {
            return table.getTableStatus();
        }
        return null;
    }

    @Override
    public void setTableStatus(IStatus tableStatus) {
        T table = this.getTable();
        if (table != null) {
            table.setTableStatus(tableStatus);
        }
    }

    @Override
    public boolean isTableStatusVisible() {
        T table = this.getTable();
        if (table != null) {
            return table.isTableStatusVisible();
        }
        return false;
    }

    @Override
    public void setTableStatusVisible(boolean tableStatusVisible) {
        T table = this.getTable();
        if (table != null) {
            table.setTableStatusVisible(tableStatusVisible);
        }
    }

    @Override
    public void doSave() {
        if (this.m_table != null && !this.m_tableExternallyManaged) {
            try {
                this.m_table.setTableChanging(true);
                this.interceptSave(this.m_table.getInsertedRows(), this.m_table.getUpdatedRows(), this.m_table.getDeletedRows());
                for (ITableRow deletedRow : this.m_table.getDeletedRows()) {
                    this.interceptSaveDeletedRow(deletedRow);
                }
                for (ITableRow insertedRow : this.m_table.getInsertedRows()) {
                    this.interceptSaveInsertedRow(insertedRow);
                    insertedRow.setStatusNonchanged();
                    this.m_table.updateRow(insertedRow);
                }
                for (ITableRow updatedRow : this.m_table.getUpdatedRows()) {
                    this.interceptSaveUpdatedRow(updatedRow);
                    updatedRow.setStatusNonchanged();
                    this.m_table.updateRow(updatedRow);
                }
            }
            finally {
                this.m_table.setTableChanging(false);
            }
        }
        this.markSaved();
    }

    @Override
    public void reloadTableData() {
        this.interceptReloadTableData();
    }

    protected ITableFieldExtension<T, ? extends AbstractTableField<T>> createLocalExtension() {
        return new LocalTableFieldExtension(this);
    }

    protected final void interceptReloadTableData() {
        List<? extends IFormFieldExtension<? extends AbstractFormField>> extensions = this.getAllExtensions();
        TableFieldChains.TableFieldReloadTableDataChain chain = new TableFieldChains.TableFieldReloadTableDataChain(extensions);
        chain.execReloadTableData();
    }

    protected final void interceptSaveInsertedRow(ITableRow row) {
        List<? extends IFormFieldExtension<? extends AbstractFormField>> extensions = this.getAllExtensions();
        TableFieldChains.TableFieldSaveInsertedRowChain chain = new TableFieldChains.TableFieldSaveInsertedRowChain(extensions);
        chain.execSaveInsertedRow(row);
    }

    protected final void interceptSaveUpdatedRow(ITableRow row) {
        List<? extends IFormFieldExtension<? extends AbstractFormField>> extensions = this.getAllExtensions();
        TableFieldChains.TableFieldSaveUpdatedRowChain chain = new TableFieldChains.TableFieldSaveUpdatedRowChain(extensions);
        chain.execSaveUpdatedRow(row);
    }

    protected final void interceptSaveDeletedRow(ITableRow row) {
        List<? extends IFormFieldExtension<? extends AbstractFormField>> extensions = this.getAllExtensions();
        TableFieldChains.TableFieldSaveDeletedRowChain chain = new TableFieldChains.TableFieldSaveDeletedRowChain(extensions);
        chain.execSaveDeletedRow(row);
    }

    protected final void interceptSave(List<? extends ITableRow> insertedRows, List<? extends ITableRow> updatedRows, List<? extends ITableRow> deletedRows) {
        List<? extends IFormFieldExtension<? extends AbstractFormField>> extensions = this.getAllExtensions();
        TableFieldChains.TableFieldSaveChain chain = new TableFieldChains.TableFieldSaveChain(extensions);
        chain.execSave(insertedRows, updatedRows, deletedRows);
    }

    @Override
    public void setValueChangeTriggerEnabled(boolean b) {
        super.setValueChangeTriggerEnabled(b);
        if (this.isInitConfigDone() && this.getTable() != null) {
            this.getTable().setValueChangeTriggerEnabled(b);
        }
    }

    protected static class LocalTableFieldExtension<T extends ITable, OWNER extends AbstractTableField<T>>
    extends AbstractFormField.LocalFormFieldExtension<OWNER>
    implements ITableFieldExtension<T, OWNER> {
        public LocalTableFieldExtension(OWNER owner) {
            super(owner);
        }

        @Override
        public void execReloadTableData(TableFieldChains.TableFieldReloadTableDataChain<? extends ITable> chain) {
            ((AbstractTableField)this.getOwner()).execReloadTableData();
        }

        @Override
        public void execSaveInsertedRow(TableFieldChains.TableFieldSaveInsertedRowChain<? extends ITable> chain, ITableRow row) {
            ((AbstractTableField)this.getOwner()).execSaveInsertedRow(row);
        }

        @Override
        public void execSaveUpdatedRow(TableFieldChains.TableFieldSaveUpdatedRowChain<? extends ITable> chain, ITableRow row) {
            ((AbstractTableField)this.getOwner()).execSaveUpdatedRow(row);
        }

        @Override
        public void execSaveDeletedRow(TableFieldChains.TableFieldSaveDeletedRowChain<? extends ITable> chain, ITableRow row) {
            ((AbstractTableField)this.getOwner()).execSaveDeletedRow(row);
        }

        @Override
        public void execSave(TableFieldChains.TableFieldSaveChain<? extends ITable> chain, List<? extends ITableRow> insertedRows, List<? extends ITableRow> updatedRows, List<? extends ITableRow> deletedRows) {
            ((AbstractTableField)this.getOwner()).execSave(insertedRows, updatedRows, deletedRows);
        }
    }
}

