/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.client.ui.messagebox;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import org.eclipse.scout.rt.client.ui.messagebox.IMessageBox;
import org.eclipse.scout.rt.platform.BEANS;
import org.eclipse.scout.rt.platform.text.TEXTS;
import org.eclipse.scout.rt.platform.util.StringUtility;

public final class MessageBoxes {
    private MessageBoxes() {
    }

    public static IMessageBox create() {
        return (IMessageBox)BEANS.get(IMessageBox.class);
    }

    public static IMessageBox createOk() {
        return MessageBoxes.create().withYesButtonText(TEXTS.get((String)"OkButton"));
    }

    public static IMessageBox createYesNo() {
        return MessageBoxes.create().withYesButtonText(TEXTS.get((String)"YesButton")).withNoButtonText(TEXTS.get((String)"NoButton"));
    }

    public static IMessageBox createYesNoCancel() {
        return MessageBoxes.createYesNo().withCancelButtonText(TEXTS.get((String)"CancelButton"));
    }

    public static boolean showDeleteConfirmationMessage(Object items) {
        return MessageBoxes.showDeleteConfirmationMessage(null, items);
    }

    public static boolean showDeleteConfirmationMessage(Collection<?> items) {
        return MessageBoxes.showDeleteConfirmationMessage(null, items);
    }

    public static boolean showDeleteConfirmationMessage(String itemType, Object items) {
        if (items == null) {
            return MessageBoxes.showDeleteConfirmationMessage(itemType, Collections.emptyList());
        }
        if (items instanceof Object[]) {
            return MessageBoxes.showDeleteConfirmationMessage(itemType, Arrays.asList((Object[])items));
        }
        if (items instanceof Collection) {
            return MessageBoxes.showDeleteConfirmationMessage(itemType, (Collection)items);
        }
        return MessageBoxes.showDeleteConfirmationMessage(itemType, Collections.singletonList(items));
    }

    public static boolean showDeleteConfirmationMessage(String itemType, Collection<?> items) {
        StringBuilder t = new StringBuilder();
        int n = 0;
        if (items != null) {
            n = items.size();
            int i = 0;
            for (Object item : items) {
                if (i < 10 || i == n - 1) {
                    t.append("- ");
                    t.append(StringUtility.emptyIfNull(item));
                    t.append("\n");
                } else if (i == 10) {
                    t.append("  ...\n");
                }
                ++i;
            }
        }
        String header = null;
        String body = null;
        if (itemType != null) {
            header = n > 0 ? TEXTS.get((String)"DeleteConfirmationTextX", (String[])new String[]{itemType}) : TEXTS.get((String)"DeleteConfirmationTextNoItemListX", (String[])new String[]{itemType});
            body = n > 0 ? t.toString() : null;
        } else {
            header = n > 0 ? TEXTS.get((String)"DeleteConfirmationText") : TEXTS.get((String)"DeleteConfirmationTextNoItemList");
            body = n > 0 ? t.toString() : null;
        }
        int result = MessageBoxes.createYesNo().withHeader(header).withBody(body).show();
        return result == 0;
    }
}

