/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.client.ui.tile;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.scout.rt.client.extension.ui.tile.ITileAccordionExtension;
import org.eclipse.scout.rt.client.extension.ui.tile.TileAccordionChains;
import org.eclipse.scout.rt.client.ui.MouseButton;
import org.eclipse.scout.rt.client.ui.accordion.AbstractAccordion;
import org.eclipse.scout.rt.client.ui.group.IGroup;
import org.eclipse.scout.rt.client.ui.tile.AbstractTileGrid;
import org.eclipse.scout.rt.client.ui.tile.DefaultGroupManager;
import org.eclipse.scout.rt.client.ui.tile.GroupTemplate;
import org.eclipse.scout.rt.client.ui.tile.ITile;
import org.eclipse.scout.rt.client.ui.tile.ITileAccordion;
import org.eclipse.scout.rt.client.ui.tile.ITileAccordionGroupManager;
import org.eclipse.scout.rt.client.ui.tile.ITileFilter;
import org.eclipse.scout.rt.client.ui.tile.ITileGrid;
import org.eclipse.scout.rt.client.ui.tile.TileGridEvent;
import org.eclipse.scout.rt.client.ui.tile.TileGridLayoutConfig;
import org.eclipse.scout.rt.client.ui.tile.TileGridListener;
import org.eclipse.scout.rt.platform.Order;
import org.eclipse.scout.rt.platform.annotations.ConfigOperation;
import org.eclipse.scout.rt.platform.classid.ClassId;
import org.eclipse.scout.rt.platform.text.TEXTS;
import org.eclipse.scout.rt.platform.util.CollectionUtility;
import org.eclipse.scout.rt.platform.util.ObjectUtility;
import org.eclipse.scout.rt.platform.util.collection.OrderedCollection;
import org.eclipse.scout.rt.platform.util.event.FastListenerList;
import org.eclipse.scout.rt.platform.util.event.IFastListenerList;
import org.eclipse.scout.rt.shared.extension.AbstractExtension;
import org.eclipse.scout.rt.shared.extension.IExtension;
import org.eclipse.scout.rt.shared.extension.ObjectExtensions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ClassId(value="e1e96659-f922-45c8-b350-78f9de059a83")
public abstract class AbstractTileAccordion<T extends ITile>
extends AbstractAccordion
implements ITileAccordion<T> {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractTileAccordion.class);
    private List<ITileFilter<T>> m_tileFilters;
    private Map<Object, ITileAccordionGroupManager<T>> m_groupManagers;
    private ITileAccordionGroupManager<T> m_groupManager;
    private boolean m_selectionUpdateLocked = false;
    private List<IGroup> m_staticGroups = new ArrayList<IGroup>();
    private final FastListenerList<TileGridListener> m_listenerList;
    private final ObjectExtensions<AbstractTileAccordion, ITileAccordionExtension<T, ? extends AbstractTileAccordion>> m_objectExtensions;

    public AbstractTileAccordion() {
        this(true);
    }

    public AbstractTileAccordion(boolean callInitializer) {
        super(false);
        this.m_tileFilters = new ArrayList<ITileFilter<T>>();
        this.m_groupManagers = new HashMap<Object, ITileAccordionGroupManager<T>>();
        this.m_listenerList = new FastListenerList();
        this.m_objectExtensions = new ObjectExtensions((Object)this, false);
        if (callInitializer) {
            this.callInitializer();
        }
    }

    @Override
    protected void initConfigInternal() {
        this.m_objectExtensions.initConfigAndBackupExtensionContext(this.createLocalExtension(), this::initConfig);
    }

    @Override
    protected void initConfig() {
        super.initConfig();
        this.setGroupManager(new DefaultGroupManager());
        this.setComparator(new DefaultComparator());
        ITileGrid<T> defaultGrid = this.getTileGrid((IGroup)this.getDefaultGroup());
        this.setSelectable(defaultGrid.isSelectable());
        this.setMultiSelect(defaultGrid.isMultiSelect());
        this.setWithPlaceholders(defaultGrid.isWithPlaceholders());
        this.setVirtual(defaultGrid.isVirtual());
        this.setGridColumnCount(defaultGrid.getGridColumnCount());
        this.setTileGridLayoutConfig(defaultGrid.getLayoutConfig());
        this.setTileComparator(defaultGrid.getComparator());
    }

    @Override
    protected boolean getConfiguredExclusiveExpand() {
        return false;
    }

    @Override
    public void addTile(T tile) {
        this.addTiles(CollectionUtility.arrayList(tile));
    }

    @Override
    public void addTiles(List<T> tilesToAdd) {
        ArrayList<T> tiles = new ArrayList<T>(this.getTiles());
        tiles.addAll(tilesToAdd);
        this.setTiles(tiles);
    }

    protected IGroup getOrCreateGroupByTile(T tile) {
        IGroup group = this.getGroupByTile(tile);
        if (group != null) {
            return group;
        }
        GroupTemplate template = this.m_groupManager.createGroupForTile(tile);
        if (template == null) {
            group = this.getDefaultGroup();
            if (group == null) {
                throw new IllegalStateException("No default group found!");
            }
            return group;
        }
        group = this.createGroup();
        this.addGroup(group);
        this.adaptGroup(group, template);
        return group;
    }

    @Override
    public IGroup getGroupByTile(T tile) {
        Object groupId = this.m_groupManager.getGroupIdByTile(tile);
        return this.getGroupById(groupId);
    }

    @Override
    public IGroup getGroupById(Object groupId) {
        return this.getGroups().stream().filter(group -> ObjectUtility.equals((Object)groupId, (Object)group.getGroupId())).findFirst().orElse(null);
    }

    @Override
    public <G extends IGroup> G getDefaultGroup() {
        return (G)this.getGroupById(DefaultGroupManager.GROUP_ID_DEFAULT);
    }

    @Override
    public void setTiles(List<T> tiles) {
        IGroup group;
        tiles = (List)ObjectUtility.nvl((Object)tiles, new ArrayList());
        HashMap map = new HashMap();
        for (IGroup iGroup : this.getGroupsInternal()) {
            map.put(iGroup, new ArrayList());
        }
        for (ITile iTile : tiles) {
            group = this.getOrCreateGroupByTile(iTile);
            map.putIfAbsent(group, new ArrayList());
            ((List)map.get(group)).add(iTile);
        }
        for (Map.Entry entry : map.entrySet()) {
            group = (IGroup)entry.getKey();
            this.getTileGrid(group).setTiles((List)entry.getValue());
            if (((List)entry.getValue()).size() != 0 || this.m_staticGroups.contains(group)) continue;
            this.deleteGroup(group);
        }
    }

    protected ITileGrid<T> getTileGrid(IGroup group) {
        return (ITileGrid)group.getBody();
    }

    @Override
    public void setGroupManager(ITileAccordionGroupManager<T> groupManager) {
        this.addGroupManager(groupManager);
        this.activateGroupManager(groupManager.getId());
    }

    @Override
    public ITileAccordionGroupManager<T> getGroupManager() {
        return this.m_groupManager;
    }

    @Override
    public void addGroupManager(ITileAccordionGroupManager<T> groupManager) {
        this.m_groupManagers.put(groupManager.getId(), groupManager);
    }

    @Override
    public void removeGroupManager(ITileAccordionGroupManager<T> groupManager) {
        this.m_groupManagers.remove(groupManager.getId());
        if (groupManager == this.m_groupManager) {
            this.activateGroupManager(DefaultGroupManager.ID);
        }
    }

    @Override
    public void activateGroupManager(Object groupManagerId) {
        IGroup group;
        int i;
        Object defaultGroup;
        ITileAccordionGroupManager<T> groupManager = this.m_groupManagers.get(groupManagerId);
        if (groupManager == null) {
            throw new IllegalArgumentException("No group manager registered for ID " + groupManagerId);
        }
        if (groupManager == this.m_groupManager) {
            return;
        }
        List<T> allTiles = this.getTiles();
        if (this.m_groupManager instanceof DefaultGroupManager && (defaultGroup = this.getDefaultGroup()) != null) {
            this.deleteGroup((IGroup)defaultGroup);
            this.m_staticGroups.remove(defaultGroup);
        }
        this.m_groupManager = groupManager;
        List<IGroup> currentGroups = new ArrayList<IGroup>(this.m_staticGroups);
        GroupTemplate defaultGroup2 = this.createDefaultGroupTemplate();
        ArrayList<GroupTemplate> requiredGroups = new ArrayList<GroupTemplate>();
        List<GroupTemplate> groupTemplates = this.m_groupManager.createGroups();
        requiredGroups.addAll(groupTemplates);
        requiredGroups.add(defaultGroup2);
        int currentSize = currentGroups.size();
        int requiredSize = requiredGroups.size();
        if (currentSize > requiredSize) {
            i = requiredSize;
            while (i < currentSize) {
                this.deleteGroup((IGroup)currentGroups.get(i));
                this.m_staticGroups.remove(currentGroups.get(i));
                ++i;
            }
        }
        if (currentSize < requiredSize) {
            i = currentSize;
            while (i < requiredSize) {
                group = this.createGroup();
                this.addGroup(group);
                this.m_staticGroups.add(group);
                ++i;
            }
        }
        currentGroups = this.getGroupsInternal().stream().filter(g -> this.m_staticGroups.contains(g)).collect(Collectors.toList());
        i = 0;
        while (i < requiredSize) {
            group = currentGroups.get(i);
            GroupTemplate groupTemplate = (GroupTemplate)requiredGroups.get(i);
            this.adaptGroup(group, groupTemplate);
            ++i;
        }
        this.setTiles(allTiles);
        this.sort();
        this.updateDefaultGroupState();
    }

    protected IGroup createGroup() {
        OrderedCollection groups = new OrderedCollection();
        this.injectGroupsInternal((OrderedCollection<IGroup>)groups);
        if (groups.size() != 1) {
            throw new IllegalStateException("Must have excatly one group as inner class, but there are " + groups.size() + " groups");
        }
        return (IGroup)groups.get(0);
    }

    @Override
    protected void addGroupInternal(IGroup group) {
        super.addGroupInternal(group);
        this.handleGroupCollapsedChange(group);
        group.addPropertyChangeListener(new P_GroupPropertyChangeListener());
        this.getTileGrid(group).addPropertyChangeListener(new P_TileGridPropertyChangeListener(group));
        this.getTileGrid(group).addTileGridListener(new P_TileGridListener());
    }

    protected void adaptGroup(IGroup group, GroupTemplate template) {
        group.setTitle(template.getTitle());
        group.setGroupId(template.getGroupId());
        group.setIconId(template.getIconId());
        group.setCssClass(template.getCssClass());
        group.setCollapsed(template.isCollapsed());
        group.setHeaderVisible(template.isHeaderVisible());
        if (this.getDefaultGroup() != group || this.isInitConfigDone()) {
            this.applyTileGridProperties(group);
        }
    }

    protected void applyTileGridProperties(IGroup group) {
        ITileGrid<T> tileGrid = this.getTileGrid(group);
        tileGrid.setSelectable(this.isSelectable());
        tileGrid.setMultiSelect(this.isMultiSelect());
        tileGrid.setGridColumnCount(this.getGridColumnCount());
        tileGrid.setWithPlaceholders(this.isWithPlaceholders());
        tileGrid.setVirtual(this.isVirtual());
        tileGrid.setLayoutConfig(this.getTileGridLayoutConfig());
        tileGrid.setComparator(this.getTileComparator());
        for (ITileFilter<T> filter : this.m_tileFilters) {
            tileGrid.addFilter(filter);
        }
    }

    protected GroupTemplate createDefaultGroupTemplate() {
        return new GroupTemplate(DefaultGroupManager.GROUP_ID_DEFAULT, TEXTS.get((String)"NotGrouped"));
    }

    @Override
    public List<ITileGrid<T>> getTileGrids() {
        ArrayList<ITileGrid<T>> tileGrids = new ArrayList<ITileGrid<T>>();
        for (IGroup iGroup : this.getGroups()) {
            tileGrids.add((ITileGrid)iGroup.getBody());
        }
        return tileGrids;
    }

    @Override
    public Stream<T> streamTiles() {
        return this.getTiles().stream();
    }

    @Override
    public List<T> getTiles() {
        ArrayList allTiles = new ArrayList();
        for (ITileGrid<T> tiles : this.getTileGrids()) {
            allTiles.addAll(((AbstractTileGrid)tiles).getTilesInternal());
        }
        return allTiles;
    }

    @Override
    public int getTileCount() {
        return this.getTileGrids().stream().mapToInt(ITileGrid::getTileCount).sum();
    }

    @Override
    public void addTileFilter(ITileFilter<T> filter) {
        this.m_tileFilters.add(filter);
        this.getTileGrids().forEach(tileGrid -> tileGrid.addFilter(filter));
    }

    @Override
    public void removeTileFilter(ITileFilter<T> filter) {
        this.m_tileFilters.remove(filter);
        this.getTileGrids().forEach(tileGrid -> tileGrid.removeFilter(filter));
    }

    @Override
    public void deleteAllTiles() {
        this.setTiles(new ArrayList());
    }

    @Override
    public void deleteTiles(Collection<T> tiles) {
        tiles.forEach(this::deleteTile);
    }

    @Override
    public void deleteTile(T tile) {
        this.deleteTiles(CollectionUtility.arrayList(tile));
    }

    @Override
    public void deleteTiles(List<T> tilesToDelete) {
        ArrayList<T> tiles = new ArrayList<T>(this.getTiles());
        tiles.removeAll(tilesToDelete);
        this.setTiles(tiles);
    }

    @Override
    public void filterTiles() {
        this.getTileGrids().forEach(ITileGrid::filter);
    }

    @Override
    public List<T> getFilteredTiles() {
        ArrayList allTiles = new ArrayList();
        for (ITileGrid<T> tiles : this.getTileGrids()) {
            allTiles.addAll(((AbstractTileGrid)tiles).getFilteredTilesInternal());
        }
        return allTiles;
    }

    @Override
    public int getFilteredTileCount() {
        return this.getTileGrids().stream().mapToInt(ITileGrid::getFilteredTileCount).sum();
    }

    @Override
    public void setTileComparator(Comparator<T> comparator) {
        this.propertySupport.setProperty("tileComparator", comparator);
        this.getTileGrids().forEach(tileGrid -> tileGrid.setComparator(comparator));
    }

    @Override
    public Comparator<T> getTileComparator() {
        return (Comparator)this.propertySupport.getProperty("tileComparator");
    }

    @Override
    protected Comparator<? extends IGroup> resolveComparator() {
        if (this.getGroupManager() != null && this.getGroupManager().getComparator() != null) {
            return this.getGroupManager().getComparator();
        }
        return super.getComparator();
    }

    @Override
    public T getSelectedTile() {
        for (ITileGrid<T> tileGrid : this.getTileGrids()) {
            T selectedTile = tileGrid.getSelectedTile();
            if (selectedTile == null) continue;
            return selectedTile;
        }
        return null;
    }

    @Override
    public List<T> getSelectedTiles() {
        ArrayList selectedTiles = new ArrayList();
        for (ITileGrid<T> tiles : this.getTileGrids()) {
            selectedTiles.addAll(((AbstractTileGrid)tiles).getSelectedTilesInternal());
        }
        return selectedTiles;
    }

    @Override
    public int getSelectedTileCount() {
        return this.getTileGrids().stream().mapToInt(ITileGrid::getSelectedTileCount).sum();
    }

    @Override
    public void selectTile(T tile) {
        this.selectTiles(CollectionUtility.arrayList(tile));
    }

    @Override
    public void selectTiles(List<T> tiles) {
        Map<IGroup, List<T>> tilesPerGroup = this.groupTilesReverse(tiles);
        List<? extends IGroup> groups = this.getGroups();
        groups.removeAll(tilesPerGroup.keySet());
        for (IGroup iGroup : groups) {
            this.getTileGrid(iGroup).deselectAllTiles();
        }
        for (Map.Entry entry : tilesPerGroup.entrySet()) {
            this.getTileGrid((IGroup)entry.getKey()).selectTiles((List)entry.getValue());
        }
    }

    @Override
    public void selectAllTiles() {
        this.getTileGrids().forEach(ITileGrid::selectAllTiles);
    }

    @Override
    public void deselectTile(T tile) {
        this.deselectTiles(CollectionUtility.arrayList(tile));
    }

    @Override
    public void deselectTiles(List<T> tiles) {
        this.getTileGrids().forEach(tileGrid -> tileGrid.deselectTiles(tiles));
    }

    @Override
    public void deselectAllTiles() {
        this.getTileGrids().forEach(ITileGrid::deselectAllTiles);
    }

    protected Map<IGroup, List<T>> groupTilesReverse(List<T> tiles) {
        LinkedHashMap<IGroup, List<T>> tilesPerGroup = new LinkedHashMap<IGroup, List<T>>();
        int i = tiles.size() - 1;
        while (i >= 0) {
            ITile tile = (ITile)tiles.get(i);
            IGroup group = this.getGroupByTile(tile);
            tilesPerGroup.computeIfAbsent(group, t -> new ArrayList()).add(tile);
            --i;
        }
        return tilesPerGroup;
    }

    @Override
    public void setGridColumnCount(int gridColumnCount) {
        this.propertySupport.setPropertyInt("gridColumnCount", gridColumnCount);
        this.getTileGrids().forEach(tileGrid -> tileGrid.setGridColumnCount(gridColumnCount));
    }

    @Override
    public int getGridColumnCount() {
        return this.propertySupport.getPropertyInt("gridColumnCount");
    }

    @Override
    public void setSelectable(boolean selectable) {
        this.propertySupport.setPropertyBool("selectable", selectable);
        this.getTileGrids().forEach(tileGrid -> tileGrid.setSelectable(selectable));
    }

    @Override
    public boolean isSelectable() {
        return this.propertySupport.getPropertyBool("selectable");
    }

    @Override
    public void setMultiSelect(boolean multiSelect) {
        this.propertySupport.setPropertyBool("multiSelect", multiSelect);
        this.getTileGrids().forEach(tileGrid -> tileGrid.setMultiSelect(multiSelect));
    }

    @Override
    public boolean isMultiSelect() {
        return this.propertySupport.getPropertyBool("multiSelect");
    }

    @Override
    public void setWithPlaceholders(boolean withPlaceholders) {
        this.propertySupport.setPropertyBool("withPlaceholders", withPlaceholders);
        this.getTileGrids().forEach(tileGrid -> tileGrid.setWithPlaceholders(withPlaceholders));
    }

    @Override
    public boolean isWithPlaceholders() {
        return this.propertySupport.getPropertyBool("withPlaceholders");
    }

    @Override
    public void setTileGridLayoutConfig(TileGridLayoutConfig layoutConfig) {
        this.propertySupport.setProperty("tileGridLayoutConfig", (Object)layoutConfig);
        this.getTileGrids().forEach(tileGrid -> tileGrid.setLayoutConfig(layoutConfig));
    }

    @Override
    public TileGridLayoutConfig getTileGridLayoutConfig() {
        return (TileGridLayoutConfig)this.propertySupport.getProperty("tileGridLayoutConfig");
    }

    @Override
    public void setVirtual(boolean virtual) {
        this.propertySupport.setPropertyBool("virtual", virtual);
        this.getTileGrids().forEach(tileGrid -> tileGrid.setVirtual(virtual));
    }

    @Override
    public boolean isVirtual() {
        return this.propertySupport.getPropertyBool("virtual");
    }

    protected void handleSelectedTilesChange(IGroup changedGroup, PropertyChangeEvent event) {
        if (this.m_selectionUpdateLocked) {
            return;
        }
        ITileGrid<T> tileGrid = this.getTileGrid(changedGroup);
        if (tileGrid.getSelectedTileCount() > 0 && changedGroup.isCollapsed()) {
            tileGrid.deselectAllTiles();
            return;
        }
        List<T> selectedTiles = tileGrid.getSelectedTiles();
        if (!this.isMultiSelect() && selectedTiles.size() > 0) {
            this.m_selectionUpdateLocked = true;
            try {
                for (IGroup iGroup : this.getGroupsInternal()) {
                    if (iGroup == changedGroup) continue;
                    this.getTileGrid(iGroup).deselectAllTiles();
                }
            }
            finally {
                this.m_selectionUpdateLocked = false;
            }
        }
        List<T> list = this.getSelectedTiles();
        this.interceptTilesSelected(list);
        this.propertySupport.setProperty("selectedTiles", list);
    }

    protected void handleFilteredTilesChange(IGroup changedGroup, PropertyChangeEvent event) {
        this.updateGroupTitleSuffix(changedGroup);
        this.updateDefaultGroupState();
    }

    protected void updateDefaultGroupState() {
        Object defaultGroup = this.getDefaultGroup();
        ITileGrid<T> defaultTileGrid = this.getTileGrid((IGroup)defaultGroup);
        if (this.m_groupManager instanceof DefaultGroupManager) {
            this.setPropertyPreservingOldValue((IGroup)defaultGroup, "oldHeaderVisible", () -> defaultGroup.isHeaderVisible(), arg_0 -> defaultGroup.setHeaderVisible(arg_0));
            this.setPropertyPreservingOldValue((IGroup)defaultGroup, "oldCollapsible", () -> defaultGroup.isCollapsible(), arg_0 -> defaultGroup.setCollapsible(arg_0));
        } else {
            boolean hasTiles = defaultTileGrid.getFilteredTileCount() > 0;
            this.setPropertyIncludingOldValue((IGroup)defaultGroup, "oldHeaderVisible", hasTiles, arg_0 -> defaultGroup.setHeaderVisible(arg_0));
            this.setPropertyIncludingOldValue((IGroup)defaultGroup, "oldCollapsible", hasTiles, arg_0 -> defaultGroup.setCollapsible(arg_0));
        }
        defaultGroup.setCollapsed(defaultTileGrid.getFilteredTileCount() == 0);
    }

    protected void setPropertyPreservingOldValue(IGroup group, String propertyName, Supplier<Object> supplier, Consumer<Boolean> consumer) {
        group.setProperty(propertyName, supplier.get());
        consumer.accept(false);
    }

    protected void setPropertyIncludingOldValue(IGroup group, String propertyName, boolean hasTiles, Consumer<Boolean> consumer) {
        Boolean oldValue = Optional.ofNullable(group.getProperty(propertyName)).map(o -> (Boolean)o).orElse(Boolean.TRUE);
        consumer.accept(oldValue != false && hasTiles);
    }

    protected void updateGroupTitleSuffix(IGroup group) {
        group.setTitleSuffix(this.createGroupTitleSuffixLabel(group));
    }

    protected String createGroupTitleSuffixLabel(IGroup group) {
        int numFilteredTiles = this.getTileGrid(group).getFilteredTileCount();
        return "(" + numFilteredTiles + ")";
    }

    @Override
    public IFastListenerList<TileGridListener> tileGridListeners() {
        return this.m_listenerList;
    }

    protected void fireTileGridEventInternal(TileGridEvent e) {
        this.tileGridListeners().list().forEach(listener -> listener.tileGridChanged(e));
    }

    protected void handleTileGridChanged(TileGridEvent e) {
        switch (e.getType()) {
            case 200: {
                this.interceptTileClick(e.getTile(), e.getMouseButton());
                this.fireTileGridEventInternal(e);
                break;
            }
            case 100: {
                this.interceptTileAction(e.getTile());
                this.fireTileGridEventInternal(e);
                break;
            }
            default: {
                LOG.debug("Unhandled event from TileGrid received " + e);
            }
        }
    }

    protected void handleGroupCollapsedChange(IGroup group) {
        if (group.isCollapsed()) {
            this.getTileGrid(group).deselectAllTiles();
        }
    }

    @ConfigOperation
    @Order(value=100.0)
    protected void execTilesSelected(List<T> tiles) {
    }

    @ConfigOperation
    @Order(value=110.0)
    protected void execTileClick(T tile, MouseButton mouseButton) {
    }

    @ConfigOperation
    @Order(value=120.0)
    protected void execTileAction(T tile) {
    }

    public final List<ITileAccordionExtension<T, ? extends AbstractTileAccordion>> getAllExtensions() {
        return this.m_objectExtensions.getAllExtensions();
    }

    public <E extends IExtension<?>> E getExtension(Class<E> c) {
        return (E)this.m_objectExtensions.getExtension(c);
    }

    protected ITileAccordionExtension<T, ? extends AbstractTileAccordion> createLocalExtension() {
        return new LocalTileAccordionExtension(this);
    }

    protected final void interceptTilesSelected(List<T> tiles) {
        List<ITileAccordionExtension<T, AbstractTileAccordion>> extensions = this.getAllExtensions();
        TileAccordionChains.TilesSelectedChain<T> chain = new TileAccordionChains.TilesSelectedChain<T>(extensions);
        chain.execTilesSelected(tiles);
    }

    protected final void interceptTileClick(T tile, MouseButton mouseButton) {
        List<ITileAccordionExtension<T, AbstractTileAccordion>> extensions = this.getAllExtensions();
        TileAccordionChains.TileClickChain<T> chain = new TileAccordionChains.TileClickChain<T>(extensions);
        chain.execTileClick(tile, mouseButton);
    }

    protected final void interceptTileAction(T tile) {
        List<ITileAccordionExtension<T, AbstractTileAccordion>> extensions = this.getAllExtensions();
        TileAccordionChains.TileActionChain<T> chain = new TileAccordionChains.TileActionChain<T>(extensions);
        chain.execTileAction(tile);
    }

    public static class DefaultComparator
    implements Comparator<IGroup>,
    Serializable {
        private static final long serialVersionUID = 1L;

        @Override
        public int compare(IGroup group1, IGroup group2) {
            if (DefaultGroupManager.GROUP_ID_DEFAULT.equals(group1.getGroupId())) {
                return 1;
            }
            if (DefaultGroupManager.GROUP_ID_DEFAULT.equals(group2.getGroupId())) {
                return -1;
            }
            return 0;
        }
    }

    protected static class LocalTileAccordionExtension<T extends ITile, TILES extends AbstractTileAccordion<T>>
    extends AbstractExtension<TILES>
    implements ITileAccordionExtension<T, TILES> {
        public LocalTileAccordionExtension(TILES owner) {
            super(owner);
        }

        @Override
        public void execTilesSelected(TileAccordionChains.TilesSelectedChain<T> chain, List<T> tiles) {
            ((AbstractTileAccordion)this.getOwner()).execTilesSelected(tiles);
        }

        @Override
        public void execTileClick(TileAccordionChains.TileClickChain<T> chain, T tile, MouseButton mouseButton) {
            ((AbstractTileAccordion)this.getOwner()).execTileClick(tile, mouseButton);
        }

        @Override
        public void execTileAction(TileAccordionChains.TileActionChain<T> chain, T tile) {
            ((AbstractTileAccordion)this.getOwner()).execTileAction(tile);
        }
    }

    protected class P_GroupPropertyChangeListener
    implements PropertyChangeListener {
        protected P_GroupPropertyChangeListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if ("collapsed".equals(evt.getPropertyName())) {
                AbstractTileAccordion.this.handleGroupCollapsedChange((IGroup)evt.getSource());
            }
        }
    }

    public class P_TileGridListener
    implements TileGridListener {
        @Override
        public void tileGridChanged(TileGridEvent event) {
            AbstractTileAccordion.this.handleTileGridChanged(event);
        }
    }

    public class P_TileGridPropertyChangeListener
    implements PropertyChangeListener {
        private IGroup m_group;

        public P_TileGridPropertyChangeListener(IGroup group) {
            this.m_group = group;
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if ("filteredTiles".equals(evt.getPropertyName())) {
                AbstractTileAccordion.this.handleFilteredTilesChange(this.m_group, evt);
            } else if ("selectedTiles".equals(evt.getPropertyName())) {
                AbstractTileAccordion.this.handleSelectedTilesChange(this.m_group, evt);
            }
        }
    }
}

