/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.client.ui.tile;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.EventObject;
import org.eclipse.scout.rt.client.ui.IModelEvent;
import org.eclipse.scout.rt.client.ui.MouseButton;
import org.eclipse.scout.rt.client.ui.tile.ITile;
import org.eclipse.scout.rt.client.ui.tile.ITileGrid;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TileGridEvent
extends EventObject
implements IModelEvent {
    private static final Logger LOG = LoggerFactory.getLogger(TileGridEvent.class);
    public static final int TYPE_TILE_ACTION = 100;
    public static final int TYPE_TILE_CLICK = 200;
    private final int m_type;
    private ITile m_tile;
    private MouseButton m_mouseButton;

    public TileGridEvent(ITileGrid source, int type) {
        this(source, type, null);
    }

    public TileGridEvent(ITileGrid source, int type, ITile tile) {
        super(source);
        this.m_type = type;
        this.m_tile = tile;
    }

    public ITileGrid getTileGrid() {
        return (ITileGrid)this.getSource();
    }

    @Override
    public int getType() {
        return this.m_type;
    }

    public ITile getTile() {
        return this.m_tile;
    }

    public void setTile(ITile tile) {
        this.m_tile = tile;
    }

    public void setMouseButton(MouseButton mouseButton) {
        this.m_mouseButton = mouseButton;
    }

    public MouseButton getMouseButton() {
        return this.m_mouseButton;
    }

    @Override
    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append(this.getClass().getSimpleName()).append("[");
        buf.append(this.getTypeName());
        if (this.m_tile != null && this.getTileGrid() != null) {
            buf.append(" ");
            buf.append("tile ").append(this.m_tile);
        }
        buf.append("]");
        return buf.toString();
    }

    protected String getTypeName() {
        try {
            Field[] f;
            Field[] fieldArray = f = this.getClass().getDeclaredFields();
            int n = f.length;
            int n2 = 0;
            while (n2 < n) {
                Field aF = fieldArray[n2];
                if (Modifier.isPublic(aF.getModifiers()) && Modifier.isStatic(aF.getModifiers()) && aF.getName().startsWith("TYPE_") && ((Number)aF.get(null)).intValue() == this.m_type) {
                    return aF.getName();
                }
                ++n2;
            }
        }
        catch (IllegalAccessException e) {
            LOG.error("Error Reading fields", (Throwable)e);
        }
        return "#" + this.m_type;
    }
}

