/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.client;

import org.eclipse.scout.rt.platform.config.AbstractPositiveLongConfigProperty;
import org.eclipse.scout.rt.platform.config.AbstractStringConfigProperty;
import org.eclipse.scout.rt.platform.exception.PlatformException;
import org.eclipse.scout.rt.platform.util.ObjectUtility;

public final class ClientConfigProperties {
    private ClientConfigProperties() {
    }

    public static class JobCompletionDelayOnSessionShutdown
    extends AbstractPositiveLongConfigProperty {
        public String getKey() {
            return "scout.client.jobCompletionDelayOnSessionShutdown";
        }

        public String description() {
            return "Specifies the maximal time (in seconds) to wait until running jobs are cancelled on session shutdown.\nThe default value is 10 seconds.";
        }

        public Long getDefaultValue() {
            return 10L;
        }
    }

    public static class MemoryPolicyProperty
    extends AbstractStringConfigProperty {
        protected String parse(String value) {
            if (ObjectUtility.isOneOf((Object)value, (Object)"small", (Object[])new Object[]{"medium", "large"})) {
                return value;
            }
            throw new PlatformException("Invalid value for property '" + this.getKey() + "': '" + value + "'. Valid values are small, medium or large", new Object[0]);
        }

        public String getKey() {
            return "scout.client.memoryPolicy";
        }

        public String description() {
            return "Specifies how long the client keeps fetched data before it is discarded. One of 'small', 'medium' or 'large'. The default value is 'large'.";
        }

        public String getDefaultValue() {
            return "large";
        }
    }

    public static class UserAreaProperty
    extends AbstractStringConfigProperty {
        public String getKey() {
            return "scout.client.userArea";
        }

        public String description() {
            return "User data area (e.g. in the user home) to store user preferences. If nothing is specified the user home of the operating system is used. By default no user home is set.";
        }
    }
}

