/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.client.clientnotification;

import java.util.List;
import java.util.concurrent.TimeUnit;
import javax.annotation.PostConstruct;
import javax.security.auth.Subject;
import org.eclipse.scout.rt.client.clientnotification.ClientNotificationDispatcher;
import org.eclipse.scout.rt.client.context.ClientRunContexts;
import org.eclipse.scout.rt.platform.ApplicationScoped;
import org.eclipse.scout.rt.platform.BEANS;
import org.eclipse.scout.rt.platform.CreateImmediately;
import org.eclipse.scout.rt.platform.IPlatform;
import org.eclipse.scout.rt.platform.IPlatformListener;
import org.eclipse.scout.rt.platform.Order;
import org.eclipse.scout.rt.platform.PlatformEvent;
import org.eclipse.scout.rt.platform.context.RunContext;
import org.eclipse.scout.rt.platform.context.RunContexts;
import org.eclipse.scout.rt.platform.context.RunMonitor;
import org.eclipse.scout.rt.platform.exception.PlatformException;
import org.eclipse.scout.rt.platform.job.IFuture;
import org.eclipse.scout.rt.platform.job.JobInput;
import org.eclipse.scout.rt.platform.job.Jobs;
import org.eclipse.scout.rt.platform.util.Assertions;
import org.eclipse.scout.rt.platform.util.SleepUtil;
import org.eclipse.scout.rt.platform.util.concurrent.FutureCancelledError;
import org.eclipse.scout.rt.platform.util.concurrent.ICancellable;
import org.eclipse.scout.rt.platform.util.concurrent.IRunnable;
import org.eclipse.scout.rt.platform.util.concurrent.ThreadInterruptedError;
import org.eclipse.scout.rt.shared.INode;
import org.eclipse.scout.rt.shared.SharedConfigProperties;
import org.eclipse.scout.rt.shared.clientnotification.ClientNotificationMessage;
import org.eclipse.scout.rt.shared.clientnotification.IClientNotificationService;
import org.eclipse.scout.rt.shared.servicetunnel.IServiceTunnel;
import org.eclipse.scout.rt.shared.ui.UserAgents;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ApplicationScoped
@CreateImmediately
public class ClientNotificationPoller {
    private static final Logger LOG = LoggerFactory.getLogger(ClientNotificationPoller.class);
    private IFuture<Void> m_pollerFuture;

    @PostConstruct
    public void start() {
        Assertions.assertNull(this.m_pollerFuture);
        if (((IServiceTunnel)BEANS.get(IServiceTunnel.class)).isActive()) {
            this.m_pollerFuture = Jobs.schedule((IRunnable)new P_NotificationPoller(), (JobInput)Jobs.newInput().withRunContext((RunContext)ClientRunContexts.empty().withSubject((Subject)((SharedConfigProperties.NotificationSubjectProperty)BEANS.get(SharedConfigProperties.NotificationSubjectProperty.class)).getValue()).withUserAgent(UserAgents.createDefault()).withSession(null, false)).withName(ClientNotificationPoller.class.getSimpleName(), new Object[0]));
        } else {
            LOG.debug("Starting without notifications due to no proxy service is available");
        }
    }

    public void stop() {
        if (this.m_pollerFuture == null) {
            return;
        }
        LOG.debug("Stopping client notification poller.");
        this.m_pollerFuture.cancel(true);
        this.m_pollerFuture = null;
    }

    protected static void handleMessagesReceived(List<ClientNotificationMessage> notifications) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("CLIENT NOTIFICATION returned with {} notifications ({}).", (Object)notifications.size(), notifications);
        }
        if (!notifications.isEmpty()) {
            ((ClientNotificationDispatcher)BEANS.get(ClientNotificationDispatcher.class)).dispatchNotifications(notifications);
        }
    }

    private static final class P_NotificationPoller
    implements IRunnable {
        private P_NotificationPoller() {
        }

        public void run() {
            RunMonitor outerRunMonitor = (RunMonitor)RunMonitor.CURRENT.get();
            while (!outerRunMonitor.isCancelled()) {
                try {
                    RunMonitor tempRunMonitor = (RunMonitor)BEANS.get(RunMonitor.class);
                    RunContexts.copyCurrent().withRunMonitor(tempRunMonitor).withParentRunMonitor(outerRunMonitor).run(() -> {
                        try {
                            ClientNotificationPoller.handleMessagesReceived(((IClientNotificationService)BEANS.get(IClientNotificationService.class)).getNotifications(INode.ID));
                        }
                        finally {
                            outerRunMonitor.unregisterCancellable((ICancellable)tempRunMonitor);
                        }
                    });
                }
                catch (FutureCancelledError | ThreadInterruptedError e) {
                    LOG.debug("Client notification polling has been interrupted.", e);
                }
                catch (RuntimeException e) {
                    if (!(e instanceof PlatformException) || !((PlatformException)e).isConsumed()) {
                        LOG.error("Error receiving client notifications", (Throwable)e);
                    }
                    SleepUtil.sleepSafe((long)10L, (TimeUnit)TimeUnit.SECONDS);
                }
            }
            LOG.debug("Client notification polling has ended because the job was cancelled.");
        }
    }

    @Order(value=-1000.0)
    public static final class ShutdownListener
    implements IPlatformListener {
        public void stateChanged(PlatformEvent event) {
            if (event.getState() == IPlatform.State.PlatformStopping) {
                ((ClientNotificationPoller)BEANS.get(ClientNotificationPoller.class)).stop();
            }
        }
    }
}

