/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.client.deeplink;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.scout.rt.client.deeplink.DeepLinkException;
import org.eclipse.scout.rt.client.deeplink.IDeepLinkHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractDeepLinkHandler
implements IDeepLinkHandler {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractDeepLinkHandler.class);
    protected final Pattern m_pattern;

    protected AbstractDeepLinkHandler(Pattern pattern) {
        this.m_pattern = pattern;
    }

    protected static Pattern defaultPattern(String handlerName, String dataGroup) {
        return Pattern.compile("^" + handlerName + "-(" + dataGroup + ")$");
    }

    protected String toDeepLinkPath(String handlerData) {
        return String.valueOf(this.getName()) + "-" + handlerData;
    }

    @Override
    public boolean matches(String path) {
        return this.m_pattern.matcher(path).matches();
    }

    @Override
    public boolean handle(String path) throws DeepLinkException {
        Matcher matcher = this.m_pattern.matcher(path);
        if (matcher.matches()) {
            LOG.debug("Handling deep-link name={} path={}", (Object)this.getName(), (Object)path);
            this.handleImpl(matcher);
            return true;
        }
        return false;
    }

    protected abstract void handleImpl(Matcher var1) throws DeepLinkException;
}

