/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.client.deeplink;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.scout.rt.client.deeplink.DeepLinkException;
import org.eclipse.scout.rt.client.deeplink.IDeepLinkHandler;
import org.eclipse.scout.rt.client.deeplink.IDeepLinks;
import org.eclipse.scout.rt.platform.BEANS;
import org.eclipse.scout.rt.platform.util.StringUtility;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DeepLinks
implements IDeepLinks {
    private static final Logger LOG = LoggerFactory.getLogger(DeepLinks.class);
    protected final List<IDeepLinkHandler> m_handlers;

    public DeepLinks() {
        ArrayList<IDeepLinkHandler> handlers = new ArrayList<IDeepLinkHandler>();
        this.collectDeepLinkHandlers(handlers);
        this.m_handlers = handlers;
        if (LOG.isInfoEnabled()) {
            StringBuilder sb = new StringBuilder();
            for (IDeepLinkHandler handler : this.m_handlers) {
                sb.append("\n- ").append(handler);
            }
            LOG.info("Registered {} deep-link handlers:{}", (Object)this.m_handlers.size(), (Object)sb.toString());
        }
    }

    protected void collectDeepLinkHandlers(List<IDeepLinkHandler> handlers) {
        handlers.addAll(BEANS.all(IDeepLinkHandler.class));
    }

    @Override
    public boolean canHandleDeepLink(String deepLinkPath) {
        if (StringUtility.isNullOrEmpty((CharSequence)deepLinkPath)) {
            return false;
        }
        for (IDeepLinkHandler handler : this.m_handlers) {
            if (!handler.matches(deepLinkPath)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean handleDeepLink(String deepLinkPath) throws DeepLinkException {
        for (IDeepLinkHandler handler : this.m_handlers) {
            if (!handler.handle(deepLinkPath)) continue;
            return true;
        }
        return false;
    }
}

