/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.client.extension.ui.desktop;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.scout.rt.client.ui.IDisplayParent;
import org.eclipse.scout.rt.client.ui.form.IForm;
import org.eclipse.scout.rt.platform.index.IIndex;
import org.eclipse.scout.rt.platform.util.CollectionUtility;

public abstract class AbstractDisplayParentViewIndex
implements IIndex<IDisplayParent, IForm> {
    private final Map<IDisplayParent, List<IForm>> m_mapByIndex = new HashMap<IDisplayParent, List<IForm>>();
    private final Map<IForm, IDisplayParent> m_mapByElement = new LinkedHashMap<IForm, IDisplayParent>();

    public boolean addToIndex(IForm element) {
        IDisplayParent index;
        if (this.m_mapByElement.containsKey(element)) {
            this.removeFromIndex(element);
        }
        if ((index = this.calculateIndexFor(element)) == null) {
            return false;
        }
        List elements = this.m_mapByIndex.computeIfAbsent(index, k -> new ArrayList());
        int position = this.calculatePositionForElement(element);
        elements.add(position, element);
        this.m_mapByElement.put(element, index);
        return true;
    }

    protected abstract int calculatePositionForElement(IForm var1);

    public boolean removeFromIndex(IForm element) {
        IDisplayParent index = this.m_mapByElement.remove(element);
        if (index == null) {
            return false;
        }
        List<IForm> elements = this.m_mapByIndex.get(index);
        elements.remove(element);
        if (elements.isEmpty()) {
            this.m_mapByIndex.remove(index);
        }
        return true;
    }

    public Set<IDisplayParent> indexValues() {
        return new HashSet<IDisplayParent>(this.m_mapByIndex.keySet());
    }

    public List<IForm> values() {
        return new ArrayList<IForm>(this.m_mapByElement.keySet());
    }

    public void clear() {
        this.m_mapByIndex.clear();
        this.m_mapByElement.clear();
    }

    public boolean contains(IForm element) {
        return this.m_mapByElement.containsKey(element);
    }

    public Iterator<IForm> iterator() {
        return this.values().iterator();
    }

    public List<IForm> get(IDisplayParent index) {
        return CollectionUtility.arrayList((Collection)this.m_mapByIndex.get(index));
    }

    protected IDisplayParent calculateIndexFor(IForm form) {
        if (form.getDisplayHint() != 20) {
            return form.getDisplayParent();
        }
        return null;
    }
}

