/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.client.extension.ui.form;

import java.util.HashSet;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.function.Consumer;
import org.eclipse.scout.rt.client.ui.form.IForm;
import org.eclipse.scout.rt.client.ui.form.fields.AbstractCompositeField;
import org.eclipse.scout.rt.client.ui.form.fields.ICompositeField;
import org.eclipse.scout.rt.client.ui.form.fields.IFormField;
import org.eclipse.scout.rt.platform.BEANS;
import org.eclipse.scout.rt.platform.classid.ClassIdentifier;
import org.eclipse.scout.rt.shared.extension.IInternalExtensionRegistry;
import org.eclipse.scout.rt.shared.extension.IMoveModelObjectToRootMarker;
import org.eclipse.scout.rt.shared.extension.MoveDescriptor;

public class MoveFormFieldsHandler {
    private final IForm m_form;
    private final IInternalExtensionRegistry m_extensionRegistry;
    private final Set<MoveDescriptor<IFormField>> m_moveDescriptors;

    public MoveFormFieldsHandler(IForm form) {
        this.m_form = form;
        this.m_extensionRegistry = (IInternalExtensionRegistry)BEANS.get(IInternalExtensionRegistry.class);
        this.m_moveDescriptors = new HashSet<MoveDescriptor<IFormField>>();
    }

    public void moveFields() {
        P_FormFieldVisitor visitor = new P_FormFieldVisitor();
        this.m_form.visit(visitor, IFormField.class);
        if (this.m_moveDescriptors.isEmpty()) {
            return;
        }
        StringBuilder sb = new StringBuilder();
        for (MoveDescriptor<IFormField> moveItem : this.m_moveDescriptors) {
            IFormField field = (IFormField)moveItem.getModel();
            ICompositeField oldContainer = field.getParentField();
            ICompositeField newContainer = this.findContainer(oldContainer, moveItem.getNewContainerIdentifer(), null);
            if (newContainer != null) {
                Double newOrder = moveItem.getNewOrder();
                if (newOrder != null) {
                    field.setOrder(newOrder);
                }
                try {
                    field.setFieldChanging(true);
                    oldContainer.moveFieldTo(field, newContainer);
                    continue;
                }
                finally {
                    field.setFieldChanging(false);
                }
            }
            if (sb.length() == 0) {
                sb.append("Invalid field move commands:");
            }
            sb.append("  \nField '").append(field).append("' cannot be moved into container '").append(newContainer).append("'");
        }
        if (sb.length() > 0) {
            throw new IllegalArgumentException(sb.toString());
        }
    }

    protected ICompositeField findContainer(ICompositeField container, ClassIdentifier newModelContainerClassIdentifier, ICompositeField ignoredChildContainer) {
        if (newModelContainerClassIdentifier == null) {
            return container;
        }
        Class newModelContainerClass = newModelContainerClassIdentifier.getLastSegment();
        if (newModelContainerClass == IMoveModelObjectToRootMarker.class) {
            return container.getForm().getRootGroupBox();
        }
        if (newModelContainerClass.isInstance(container) && this.matchesClassIdentifier(container, newModelContainerClassIdentifier)) {
            return container;
        }
        for (IFormField c : container.getFields()) {
            if (!newModelContainerClass.isInstance(c) || !(c instanceof ICompositeField) || !this.matchesClassIdentifier((ICompositeField)c, newModelContainerClassIdentifier)) continue;
            return (ICompositeField)c;
        }
        for (IFormField c : container.getFields()) {
            ICompositeField recursiveContainer;
            if (c == ignoredChildContainer || !(c instanceof ICompositeField) || (recursiveContainer = this.findContainer((ICompositeField)c, newModelContainerClassIdentifier, container)) == null) continue;
            return recursiveContainer;
        }
        if (container instanceof AbstractCompositeField && ((AbstractCompositeField)container).isTemplateField()) {
            return null;
        }
        ICompositeField parent = container.getParentField();
        if (parent != null && parent != ignoredChildContainer) {
            return this.findContainer(parent, newModelContainerClassIdentifier, container);
        }
        return null;
    }

    protected boolean matchesClassIdentifier(ICompositeField container, ClassIdentifier identifier) {
        if (identifier.size() <= 1) {
            return true;
        }
        P_FormFieldParentIterator fieldParentIterator = new P_FormFieldParentIterator(container);
        P_ClassIdentifierReverseIterator identifierIterator = new P_ClassIdentifierReverseIterator(identifier);
        while (identifierIterator.hasNext() && fieldParentIterator.hasNext()) {
            Object nextSegment = identifierIterator.next();
            boolean parentIsInstanceOfSegment = false;
            while (!parentIsInstanceOfSegment && fieldParentIterator.hasNext()) {
                Object parent = fieldParentIterator.next();
                if (!((Class)nextSegment).isInstance(parent)) continue;
                parentIsInstanceOfSegment = true;
            }
            if (parentIsInstanceOfSegment) continue;
            return false;
        }
        return !identifierIterator.hasNext();
    }

    private static class P_ClassIdentifierReverseIterator
    implements Iterator<Class<?>> {
        private final ClassIdentifier m_identifier;
        private int m_index;

        public P_ClassIdentifierReverseIterator(ClassIdentifier identifier) {
            this.m_identifier = identifier;
            this.m_index = this.m_identifier.size() - 2;
        }

        @Override
        public boolean hasNext() {
            return this.m_index >= 0;
        }

        @Override
        public Class<?> next() {
            if (this.m_index < 0) {
                throw new NoSuchElementException();
            }
            Class next = this.m_identifier.getSegment(this.m_index);
            --this.m_index;
            return next;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    private static class P_FormFieldParentIterator
    implements Iterator<Object> {
        private IFormField m_currentField;

        public P_FormFieldParentIterator() {
            this(null);
        }

        public P_FormFieldParentIterator(IFormField field) {
            this.m_currentField = field;
        }

        void setCurrentField(IFormField field) {
            if (field == null) {
                throw new IllegalArgumentException("field must not be null.");
            }
            this.m_currentField = field;
        }

        @Override
        public boolean hasNext() {
            return this.m_currentField != null && (this.m_currentField.getParentField() != null || this.m_currentField.getForm() != null);
        }

        @Override
        public Object next() {
            if (this.m_currentField == null) {
                throw new NoSuchElementException();
            }
            IFormField field = this.m_currentField;
            this.m_currentField = field.getParentField();
            if (this.m_currentField != null) {
                return this.m_currentField;
            }
            IForm form = field.getForm();
            if (form != null) {
                return form;
            }
            throw new NoSuchElementException();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    private class P_FormFieldVisitor
    implements Consumer<IFormField> {
        private final P_FormFieldParentIterator m_parentIterator = new P_FormFieldParentIterator();

        private P_FormFieldVisitor() {
        }

        @Override
        public void accept(IFormField field) {
            this.m_parentIterator.setCurrentField(field);
            MoveDescriptor moveDesc = MoveFormFieldsHandler.this.m_extensionRegistry.createModelMoveDescriptorFor((Object)field, (Iterator)this.m_parentIterator);
            if (moveDesc != null) {
                MoveFormFieldsHandler.this.m_moveDescriptors.add(moveDesc);
            }
        }
    }
}

