/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.client.res;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.scout.rt.client.res.Attachment;
import org.eclipse.scout.rt.platform.Bean;
import org.eclipse.scout.rt.platform.resource.BinaryResource;
import org.eclipse.scout.rt.platform.util.BooleanUtility;

@Bean
public class AttachmentSupport {
    private Map<String, Attachment> m_attachments = new HashMap<String, Attachment>(0);

    public Set<BinaryResource> getAttachments() {
        return this.getAttachments(null, null);
    }

    public Set<BinaryResource> getAttachments(Boolean uploaded, Boolean referenced) {
        return this.m_attachments.values().stream().filter(attachment -> !(uploaded != null && BooleanUtility.nvl((Boolean)uploaded) != attachment.isUploaded() || referenced != null && BooleanUtility.nvl((Boolean)referenced) != attachment.isReferenced())).map(Attachment::getBinaryResource).collect(Collectors.toSet());
    }

    public BinaryResource getAttachment(String filename) {
        Attachment attachment = this.m_attachments.get(filename);
        if (attachment == null) {
            return null;
        }
        return attachment.getBinaryResource();
    }

    public void setAttachments(Collection<? extends BinaryResource> attachments) {
        if (attachments == null) {
            this.m_attachments = new HashMap<String, Attachment>(0);
            return;
        }
        HashMap<String, Attachment> newMap = new HashMap<String, Attachment>(attachments.size());
        for (BinaryResource binaryResource : attachments) {
            if (binaryResource == null) continue;
            newMap.put(binaryResource.getFilename(), new Attachment(binaryResource));
        }
        this.m_attachments = newMap;
    }

    public void addAttachment(BinaryResource attachment) {
        this.addAttachment(attachment, false);
    }

    public void addAttachment(BinaryResource attachment, boolean uploaded) {
        if (attachment != null) {
            this.m_attachments.put(attachment.getFilename(), new Attachment(attachment, uploaded));
        }
    }

    public void removeAttachment(BinaryResource attachment) {
        if (attachment != null) {
            this.m_attachments.remove(attachment.getFilename());
        }
    }

    public void setUploaded(BinaryResource attachment0, boolean uploaded) {
        Attachment attachment = this.m_attachments.get(attachment0.getFilename());
        if (attachment != null) {
            attachment.setUploaded(uploaded);
        }
    }

    public boolean isUploaded(BinaryResource attachment0) {
        Attachment attachment = this.m_attachments.get(attachment0.getFilename());
        if (attachment == null) {
            return false;
        }
        return attachment.isUploaded();
    }

    public void setReferenced(String filename, boolean referenced) {
        Attachment attachment = this.m_attachments.get(filename);
        if (attachment != null) {
            attachment.setReferenced(referenced);
        }
    }

    public void setReferenced(BinaryResource attachment, boolean referenced) {
        this.setReferenced(attachment.getFilename(), referenced);
    }

    public boolean isReferenced(BinaryResource attachment0) {
        Attachment attachment = this.m_attachments.get(attachment0.getFilename());
        if (attachment == null) {
            return false;
        }
        return attachment.isReferenced();
    }

    public void cleanup() {
        Set<String> toDelete = this.m_attachments.values().stream().filter(attachment -> !attachment.isReferenced()).map(attachment -> attachment.getBinaryResource().getFilename()).collect(Collectors.toSet());
        toDelete.forEach(filename -> {
            Attachment attachment = this.m_attachments.remove(filename);
        });
    }
}

