/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.client.services.common.prefs;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import org.eclipse.scout.rt.client.ClientConfigProperties;
import org.eclipse.scout.rt.platform.BEANS;
import org.eclipse.scout.rt.platform.config.ConfigUtility;
import org.eclipse.scout.rt.platform.config.IConfigProperty;
import org.eclipse.scout.rt.platform.exception.ProcessingException;
import org.eclipse.scout.rt.shared.services.common.prefs.AbstractUserPreferencesStorageService;
import org.eclipse.scout.rt.shared.services.common.prefs.IPreferences;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileSystemUserPreferencesStorageService
extends AbstractUserPreferencesStorageService {
    private static final Logger LOG = LoggerFactory.getLogger(FileSystemUserPreferencesStorageService.class);
    public static final String PROP_USER_HOME = "user.home";
    public static final String SETTINGS_SUB_DIR = ".settings";
    public static final char NODE_NAME_DELIM = '-';
    public static final String SETTINGS_EXT = ".prefs";
    private final AtomicBoolean m_noUserAreaWarningLogged = new AtomicBoolean(false);

    public void flush(IPreferences prefs) {
        if (prefs == null) {
            return;
        }
        File prefsLocation = this.getPrefsLocation(this.getUserScope(prefs.userScope()), prefs.name());
        LOG.debug("flusing preferences to file '{}'.", (Object)prefsLocation.getAbsolutePath());
        Properties propsToFlush = new Properties();
        this.convertToProperties(prefs, propsToFlush);
        if (propsToFlush.isEmpty()) {
            boolean deleted;
            if (prefsLocation.exists() && !(deleted = prefsLocation.delete())) {
                LOG.warn("Could not delete preference file '{}'.", (Object)prefsLocation.getAbsolutePath());
            }
        } else {
            this.flushToDisk(propsToFlush, prefsLocation);
        }
    }

    protected void load(String userScope, String nodeId, IPreferences prefsToFill) {
        File prefsLocation = this.getPrefsLocation(userScope, nodeId);
        if (!prefsLocation.exists()) {
            File legacyPrefsLocation = this.getLegacyPrefsLocation(nodeId);
            if (legacyPrefsLocation.exists()) {
                LOG.warn("Legacy preference found: '{}'. Will be stored in the new location ('{}') the next time.", (Object)legacyPrefsLocation.getAbsolutePath(), (Object)prefsLocation.getAbsolutePath());
            }
            prefsLocation = legacyPrefsLocation;
        }
        if (prefsLocation.exists()) {
            Properties propertiesFromDisk = this.loadFromDisk(prefsLocation);
            this.convertToPreferences(propertiesFromDisk, prefsToFill);
        }
    }

    protected void convertToProperties(IPreferences src, Properties target) {
        Set keys = src.keys();
        for (String key : keys) {
            String value = src.get(key, null);
            if (value == null) continue;
            target.setProperty(key, value);
        }
    }

    protected void convertToPreferences(Properties src, IPreferences target) {
        for (Map.Entry<Object, Object> entry : src.entrySet()) {
            String key = (String)entry.getKey();
            String value = (String)entry.getValue();
            if (value == null) continue;
            target.put(key, value);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void flushToDisk(Properties props, File prefsLocation) {
        boolean done2;
        File parentDirectory = prefsLocation.getParentFile();
        if (!parentDirectory.exists() && !(done2 = parentDirectory.mkdirs())) {
            throw new ProcessingException("Error writing preferences to file '" + prefsLocation.getAbsolutePath() + "'. Directory could not be created.", new Object[0]);
        }
        try {
            Throwable done2 = null;
            Object var5_8 = null;
            try {
                FileOutputStream fos = new FileOutputStream(prefsLocation, false);
                try {
                    try (BufferedOutputStream out = new BufferedOutputStream(fos);){
                        props.store(out, null);
                        ((OutputStream)out).flush();
                        fos.getFD().sync();
                    }
                    if (fos == null) return;
                }
                catch (Throwable throwable) {
                    if (done2 == null) {
                        done2 = throwable;
                    } else if (done2 != throwable) {
                        done2.addSuppressed(throwable);
                    }
                    if (fos == null) throw done2;
                    fos.close();
                    throw done2;
                }
                fos.close();
                return;
            }
            catch (Throwable throwable) {
                if (done2 == null) {
                    done2 = throwable;
                    throw done2;
                } else {
                    if (done2 == throwable) throw done2;
                    done2.addSuppressed(throwable);
                }
                throw done2;
            }
        }
        catch (IOException e) {
            throw new ProcessingException("Error writing preferences to file '" + prefsLocation.getAbsolutePath() + "'.", new Object[]{e});
        }
    }

    protected Properties loadFromDisk(File prefsLocation) {
        LOG.debug("loading preferences from file '{}'.", (Object)prefsLocation.getAbsolutePath());
        Properties result = new Properties();
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try (BufferedInputStream input = new BufferedInputStream(new FileInputStream(prefsLocation));){
                result.load(input);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            throw new ProcessingException("Error loading preferences from file '" + prefsLocation.getAbsolutePath() + "'.", new Object[]{e});
        }
        return result;
    }

    protected String computeFullNodeName(String userScope, String nodeId) {
        int len = nodeId.length() + 1 + userScope.length() + SETTINGS_EXT.length();
        return new StringBuilder(len).append(nodeId).append('-').append(userScope).append(SETTINGS_EXT).toString();
    }

    protected String computeLegacyFullNodeName(String nodeId) {
        int len = nodeId.length() + SETTINGS_EXT.length();
        return new StringBuilder(len).append(nodeId).append(SETTINGS_EXT).toString();
    }

    protected File getLegacyPrefsLocation(String nodeId) {
        File prefsLoc = new File(new File(this.getBaseFolder(), SETTINGS_SUB_DIR), this.computeLegacyFullNodeName(nodeId));
        return prefsLoc;
    }

    protected File getPrefsLocation(String userScope, String nodeId) {
        File prefsLoc = new File(new File(this.getBaseFolder(), SETTINGS_SUB_DIR), this.computeFullNodeName(userScope, nodeId));
        return prefsLoc;
    }

    protected String getBaseFolder() {
        IConfigProperty userAreaProperty = (IConfigProperty)BEANS.get(ClientConfigProperties.UserAreaProperty.class);
        String location = (String)userAreaProperty.getValue();
        if (location == null) {
            location = new File(ConfigUtility.getProperty((String)PROP_USER_HOME), "user").getAbsolutePath();
            if (this.m_noUserAreaWarningLogged.compareAndSet(false, true)) {
                LOG.warn("No user area property found. Using '{}' as fallback. Consider specifying a user area using property '{}'.", (Object)location, (Object)userAreaProperty.getKey());
            }
        }
        if ((location = location.trim()).startsWith("file:")) {
            try {
                location = new File(new URI(location)).getAbsolutePath();
            }
            catch (URISyntaxException e) {
                LOG.warn("invalid URI syntax: '{}'.", (Object)location, (Object)e);
            }
        }
        return location;
    }
}

