/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.client.services.common.security;

import java.security.Permission;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.eclipse.scout.rt.client.IClientSession;
import org.eclipse.scout.rt.client.session.ClientSessionProvider;
import org.eclipse.scout.rt.shared.services.common.security.IPermissionService;
import org.eclipse.scout.rt.shared.servicetunnel.ServiceTunnelUtility;

public class PermissionServiceClientProxy
implements IPermissionService {
    private final Object m_stateLock = new Object();
    private final Map<Object, ServiceState> m_stateMap = new HashMap<Object, ServiceState>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ServiceState getServiceState() {
        IClientSession session = ClientSessionProvider.currentSession();
        Class<?> key = null;
        if (session != null) {
            key = session.getClass();
        }
        Object object = this.m_stateLock;
        synchronized (object) {
            ServiceState data = this.m_stateMap.computeIfAbsent(key, k -> new ServiceState());
            return data;
        }
    }

    public Set<Class<? extends Permission>> getAllPermissionClasses() {
        ServiceState state = this.getServiceState();
        this.checkCache(state);
        return state.m_permissionClasses;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkCache(ServiceState state) {
        Object object = state.m_permissionClassesLock;
        synchronized (object) {
            if (state.m_permissionClasses == null) {
                state.m_permissionClasses = this.getRemoteService().getAllPermissionClasses();
            }
        }
    }

    protected IPermissionService getRemoteService() {
        return (IPermissionService)ServiceTunnelUtility.createProxy(IPermissionService.class);
    }

    private static final class ServiceState {
        private final Object m_permissionClassesLock = new Object();
        private Set<Class<? extends Permission>> m_permissionClasses;

        private ServiceState() {
        }
    }
}

