/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.client.services.lookup;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.eclipse.scout.rt.dataobject.DataObjectHelper;
import org.eclipse.scout.rt.dataobject.lookup.AbstractLookupRestrictionDo;
import org.eclipse.scout.rt.dataobject.lookup.AbstractLookupRowDo;
import org.eclipse.scout.rt.dataobject.lookup.LookupResponse;
import org.eclipse.scout.rt.platform.BEANS;
import org.eclipse.scout.rt.platform.context.RunContext;
import org.eclipse.scout.rt.platform.exception.PlatformException;
import org.eclipse.scout.rt.platform.job.IFuture;
import org.eclipse.scout.rt.platform.job.JobInput;
import org.eclipse.scout.rt.platform.job.Jobs;
import org.eclipse.scout.rt.platform.util.CollectionUtility;
import org.eclipse.scout.rt.platform.util.NumberUtility;
import org.eclipse.scout.rt.platform.util.TriState;
import org.eclipse.scout.rt.platform.util.TypeCastUtility;
import org.eclipse.scout.rt.shared.services.lookup.ILookupCall;
import org.eclipse.scout.rt.shared.services.lookup.ILookupRow;
import org.eclipse.scout.rt.shared.services.lookup.ILookupRowFetchedCallback;
import org.eclipse.scout.rt.shared.services.lookup.LookupRow;

public abstract class AbstractRestLookupCall<RESTRICTION extends AbstractLookupRestrictionDo<?, ID>, ID>
implements ILookupCall<ID> {
    private static final long serialVersionUID = 1L;
    protected RESTRICTION m_restrictionDo = (AbstractLookupRestrictionDo)BEANS.get(this.resolveRestrictionClass());

    protected AbstractRestLookupCall() {
    }

    protected Class<RESTRICTION> resolveRestrictionClass() {
        return TypeCastUtility.getGenericsParameterClass(this.getClass(), AbstractRestLookupCall.class, (int)0);
    }

    public RESTRICTION getRestriction() {
        return this.m_restrictionDo;
    }

    public ID getKey() {
        return (ID)CollectionUtility.firstElement((List)this.m_restrictionDo.getIds());
    }

    public void setKey(ID key) {
        this.m_restrictionDo.getIds().clear();
        if (key != null) {
            this.m_restrictionDo.getIds().add(key);
        }
    }

    public List<ID> getKeys() {
        return this.m_restrictionDo.getIds();
    }

    public void setKeys(Collection<? extends ID> keys) {
        this.m_restrictionDo.withIds(keys);
    }

    @SafeVarargs
    public final void setKeys(ID ... keys) {
        this.m_restrictionDo.withIds((Object[])keys);
    }

    public void setText(String text) {
        this.m_restrictionDo.withText(text);
    }

    public void setAll(String s) {
    }

    public String getAll() {
        return null;
    }

    public void setRec(ID parent) {
    }

    public ID getRec() {
        return null;
    }

    public void setMaster(Object master) {
    }

    public Object getMaster() {
        return null;
    }

    public void setActive(TriState activeState) {
        this.m_restrictionDo.withActive(activeState == null ? null : activeState.getBooleanValue());
    }

    public TriState getActive() {
        return TriState.parse((Object)this.m_restrictionDo.getActive());
    }

    public String getText() {
        return this.m_restrictionDo.getText();
    }

    public List<? extends ILookupRow<ID>> getDataByKey() {
        if (!this.m_restrictionDo.ids().exists() || this.m_restrictionDo.ids().isEmpty()) {
            return Collections.emptyList();
        }
        return this.getData();
    }

    public IFuture<Void> getDataByKeyInBackground(RunContext runContext, ILookupRowFetchedCallback<ID> callback) {
        return this.loadDataInBackground(this::getDataByKey, runContext, callback);
    }

    public List<? extends ILookupRow<ID>> getDataByText() {
        return this.getData();
    }

    public IFuture<Void> getDataByTextInBackground(RunContext runContext, ILookupRowFetchedCallback<ID> callback) {
        return this.loadDataInBackground(this::getDataByText, runContext, callback);
    }

    public List<? extends ILookupRow<ID>> getDataByAll() {
        return this.getData();
    }

    public IFuture<Void> getDataByAllInBackground(RunContext runContext, ILookupRowFetchedCallback<ID> callback) {
        return this.loadDataInBackground(this::getDataByAll, runContext, callback);
    }

    public List<? extends ILookupRow<ID>> getDataByRec() {
        throw new UnsupportedOperationException("not implemented");
    }

    public IFuture<Void> getDataByRecInBackground(RunContext runContext, ILookupRowFetchedCallback<ID> callback) {
        throw new UnsupportedOperationException("not implemented");
    }

    public int getMaxRowCount() {
        return NumberUtility.nvl((Integer)this.m_restrictionDo.getMaxRowCount(), (int)0);
    }

    public void setMaxRowCount(int n) {
        this.m_restrictionDo.withMaxRowCount(Integer.valueOf(n));
    }

    public String getWildcard() {
        return null;
    }

    public void setWildcard(String wildcard) {
    }

    public void setMultilineText(boolean b) {
    }

    public boolean isMultilineText() {
        return false;
    }

    protected List<? extends ILookupRow<ID>> getData() {
        this.execPrepareRestriction(this.m_restrictionDo);
        LookupResponse<AbstractLookupRowDo<?, ID>> response = this.remoteCall().apply(this.m_restrictionDo);
        return this.transformLookupResponse(response);
    }

    protected void execPrepareRestriction(RESTRICTION restriction) {
    }

    protected abstract Function<RESTRICTION, LookupResponse<? extends AbstractLookupRowDo<?, ID>>> remoteCall();

    protected IFuture<Void> loadDataInBackground(Supplier<List<? extends ILookupRow<ID>>> supplier, RunContext runContext, ILookupRowFetchedCallback<ID> callback) {
        return Jobs.schedule(() -> this.loadData(supplier, callback), (JobInput)Jobs.newInput().withRunContext(runContext).withName("Fetching lookup data [lookupCall={}]", new Object[]{this.getClass().getName()}));
    }

    protected void loadData(Supplier<List<? extends ILookupRow<ID>>> supplier, ILookupRowFetchedCallback<ID> callback) {
        try {
            callback.onSuccess(supplier.get());
        }
        catch (RuntimeException e) {
            callback.onFailure(e);
        }
    }

    protected List<? extends ILookupRow<ID>> transformLookupResponse(LookupResponse<? extends AbstractLookupRowDo<?, ID>> response) {
        return response.getRows().stream().map(this::transformLookupRow).collect(Collectors.toList());
    }

    protected ILookupRow<ID> transformLookupRow(AbstractLookupRowDo<?, ID> row) {
        return new LookupRow(row.getId(), row.getText()).withActive(row.isActive().booleanValue()).withEnabled(row.isEnabled().booleanValue()).withParentKey(row.getParentId()).withIconId(row.getIconId()).withCssClass(row.getCssClass()).withTooltipText(row.getTooltipText());
    }

    public AbstractRestLookupCall<RESTRICTION, ID> copy() {
        try {
            AbstractRestLookupCall clone = (AbstractRestLookupCall)super.clone();
            clone.m_restrictionDo = (AbstractLookupRestrictionDo)((DataObjectHelper)BEANS.get(DataObjectHelper.class)).clone(this.m_restrictionDo);
            return clone;
        }
        catch (CloneNotSupportedException e) {
            throw new PlatformException("could not clone rest lookup call", new Object[]{e});
        }
    }

    public String toString() {
        return String.valueOf(this.getClass().getSimpleName()) + "[ m_restrictionDo=" + this.m_restrictionDo + "]";
    }
}

