/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.client.services.lookup;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.scout.rt.client.services.lookup.BatchSplit;
import org.eclipse.scout.rt.platform.BEANS;
import org.eclipse.scout.rt.platform.Order;
import org.eclipse.scout.rt.platform.util.CollectionUtility;
import org.eclipse.scout.rt.shared.services.lookup.BatchLookupCall;
import org.eclipse.scout.rt.shared.services.lookup.BatchLookupNormalizer;
import org.eclipse.scout.rt.shared.services.lookup.BatchLookupResultCache;
import org.eclipse.scout.rt.shared.services.lookup.IBatchLookupService;
import org.eclipse.scout.rt.shared.services.lookup.ILookupCall;
import org.eclipse.scout.rt.shared.services.lookup.ILookupRow;
import org.eclipse.scout.rt.shared.services.lookup.IServerBatchLookupService;

@Order(value=4900.0)
public class BatchLookupServiceClientProxy
implements IBatchLookupService {
    public List<List<ILookupRow<?>>> getBatchDataByKey(BatchLookupCall batch) {
        List allCalls = batch.getCallBatch();
        ArrayList cleanCalls = new ArrayList(allCalls.size());
        for (ILookupCall call : allCalls) {
            if (call != null && call.getKey() == null) {
                cleanCalls.add(null);
                continue;
            }
            cleanCalls.add(call);
        }
        BatchSplit split = new BatchSplit(cleanCalls);
        if (split.getLocalCallCount() > 0) {
            BatchLookupResultCache cache = new BatchLookupResultCache();
            List<ILookupCall<?>> calls = split.getLocalCalls();
            ArrayList result = new ArrayList();
            for (ILookupCall<?> call : calls) {
                result.add(cache.getDataByKey(call));
            }
            split.setLocalResults(result);
        }
        if (split.getRemoteCallCount() > 0) {
            BatchLookupNormalizer normalizer = new BatchLookupNormalizer();
            List normCallArray = normalizer.normalizeCalls(split.getRemoteCalls());
            List normResultArray = this.getTargetService().getBatchDataByKey(new BatchLookupCall(normCallArray));
            List resultArray = normalizer.denormalizeResults(normResultArray);
            split.setRemoteResults(resultArray);
        }
        List<List<ILookupRow<?>>> results = split.getCombinedResults();
        int i = 0;
        while (i < results.size()) {
            if (results.get(i) == null) {
                ArrayList emptyList = CollectionUtility.emptyArrayList();
                results.set(i, emptyList);
            }
            ++i;
        }
        return results;
    }

    public List<List<ILookupRow<?>>> getBatchDataByText(BatchLookupCall batch) {
        BatchSplit split = new BatchSplit(batch);
        if (split.getLocalCallCount() > 0) {
            BatchLookupResultCache cache = new BatchLookupResultCache();
            List<ILookupCall<?>> calls = split.getLocalCalls();
            ArrayList resultArray = new ArrayList();
            for (ILookupCall<?> call : calls) {
                resultArray.add(cache.getDataByText(call));
            }
            split.setLocalResults(resultArray);
        }
        if (split.getRemoteCallCount() > 0) {
            List resultArray = this.getTargetService().getBatchDataByText(new BatchLookupCall(split.getRemoteCalls()));
            split.setRemoteResults(resultArray);
        }
        return split.getCombinedResults();
    }

    public List<List<ILookupRow<?>>> getBatchDataByAll(BatchLookupCall batch) {
        BatchSplit split = new BatchSplit(batch);
        if (split.getLocalCallCount() > 0) {
            BatchLookupResultCache cache = new BatchLookupResultCache();
            List<ILookupCall<?>> calls = split.getLocalCalls();
            ArrayList resultArray = new ArrayList();
            for (ILookupCall<?> call : calls) {
                resultArray.add(cache.getDataByAll(call));
            }
            split.setLocalResults(resultArray);
        }
        if (split.getRemoteCallCount() > 0) {
            List resultArray = this.getTargetService().getBatchDataByAll(new BatchLookupCall(split.getRemoteCalls()));
            split.setRemoteResults(resultArray);
        }
        return split.getCombinedResults();
    }

    public List<List<ILookupRow<?>>> getBatchDataByRec(BatchLookupCall batch) {
        BatchSplit split = new BatchSplit(batch);
        if (split.getLocalCallCount() > 0) {
            BatchLookupResultCache cache = new BatchLookupResultCache();
            List<ILookupCall<?>> calls = split.getLocalCalls();
            ArrayList resultArray = new ArrayList();
            for (ILookupCall<?> call : calls) {
                resultArray.add(cache.getDataByRec(call));
            }
            split.setLocalResults(resultArray);
        }
        if (split.getRemoteCallCount() > 0) {
            List resultArray = this.getTargetService().getBatchDataByRec(new BatchLookupCall(split.getRemoteCalls()));
            split.setRemoteResults(resultArray);
        }
        return split.getCombinedResults();
    }

    private IBatchLookupService getTargetService() {
        return (IBatchLookupService)BEANS.get(IServerBatchLookupService.class);
    }
}

