/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.client.session;

import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;
import org.eclipse.scout.rt.client.ClientConfigProperties;
import org.eclipse.scout.rt.client.IClientSession;
import org.eclipse.scout.rt.client.context.ClientRunContexts;
import org.eclipse.scout.rt.client.job.ModelJobs;
import org.eclipse.scout.rt.client.job.filter.future.ModelJobFutureFilter;
import org.eclipse.scout.rt.client.ui.desktop.IDesktop;
import org.eclipse.scout.rt.platform.Bean;
import org.eclipse.scout.rt.platform.config.CONFIG;
import org.eclipse.scout.rt.platform.job.FixedDelayScheduleBuilder;
import org.eclipse.scout.rt.platform.job.IFuture;
import org.eclipse.scout.rt.platform.job.JobInput;
import org.eclipse.scout.rt.platform.job.JobState;
import org.eclipse.scout.rt.platform.job.Jobs;
import org.eclipse.scout.rt.platform.util.Assertions;
import org.eclipse.scout.rt.platform.util.NumberUtility;
import org.eclipse.scout.rt.platform.util.concurrent.ThreadInterruptedError;
import org.eclipse.scout.rt.platform.util.concurrent.TimedOutError;
import org.eclipse.scout.rt.shared.ISession;
import org.eclipse.scout.rt.shared.job.filter.future.SessionFutureFilter;
import org.quartz.ScheduleBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Bean
public class ClientSessionStopHelper {
    private static final Logger LOG = LoggerFactory.getLogger(ClientSessionStopHelper.class);
    public static final String STOP_JOB_HINT = "ClientSessionStopHelper.session.stop";

    public IFuture<?> scheduleStop(IClientSession clientSession, boolean force, String stopReason) {
        Jobs.getJobManager().cancel(Jobs.newFutureFilterBuilder().andMatch((Predicate)new SessionFutureFilter((ISession)clientSession)).andMatch(ModelJobFutureFilter.INSTANCE).andMatchNotExecutionHint(STOP_JOB_HINT).andMatchNotState(new JobState[]{JobState.DONE, JobState.REJECTED}).toFilter(), true);
        LOG.debug("Stop client session {} due to {}", (Object)clientSession.getId(), (Object)stopReason);
        return ModelJobs.schedule(() -> this.callStop(clientSession, force), ModelJobs.newInput(ClientRunContexts.empty().withSession(clientSession, true)).withExecutionHint(STOP_JOB_HINT).withName("Stop client session {} due to {}", new Object[]{clientSession.getId(), stopReason}));
    }

    protected void callStop(IClientSession session, boolean force) {
        Assertions.assertNotNull((Object)session);
        if (!session.isActive()) {
            LOG.debug("Client session with ID {} is already inactive.", (Object)session.getId());
        } else if (session.isStopping()) {
            LOG.debug("Client session with ID {} is already stopping.", (Object)session.getId());
        } else {
            LOG.debug("Forcing session with ID {} to shut down...", (Object)session.getId());
            IDesktop desktop = session.getDesktop();
            if (force && desktop != null) {
                desktop.getUIFacade().closeFromUI(force);
            } else {
                session.stop();
            }
            LOG.info("Client session with ID {} terminated.", (Object)session.getId());
        }
    }

    public IFuture<?> scheduleJobTerminationLoop(IClientSession session) {
        return Jobs.schedule(() -> {
            if (!((IFuture)IFuture.CURRENT.get()).isCancelled()) {
                this.runJobTermination(session);
            }
        }, (JobInput)Jobs.newInput().withExecutionTrigger(Jobs.newExecutionTrigger().withStartIn(1L, TimeUnit.SECONDS).withSchedule((ScheduleBuilder)FixedDelayScheduleBuilder.repeatForever((long)1L, (TimeUnit)TimeUnit.SECONDS))));
    }

    public void runJobTermination(IClientSession session) {
        IFuture myself = (IFuture)IFuture.CURRENT.get();
        if (this.awaitJobs(session, myself)) {
            return;
        }
        if (myself.isCancelled()) {
            return;
        }
        this.cancelJobs(session, myself);
    }

    protected boolean awaitJobs(IClientSession session, IFuture<?> caller) {
        Predicate<IFuture<?>> runningJobsFilter = this.createJobFilter(session, caller);
        long seconds = NumberUtility.nvl((Long)((Long)CONFIG.getPropertyValue(ClientConfigProperties.JobCompletionDelayOnSessionShutdown.class)), (long)0L);
        if (seconds > 0L) {
            try {
                Jobs.getJobManager().awaitDone(runningJobsFilter, seconds, TimeUnit.SECONDS);
            }
            catch (TimedOutError timedOutError) {
            }
            catch (ThreadInterruptedError threadInterruptedError) {}
        }
        if (Jobs.getJobManager().getFutures(runningJobsFilter).isEmpty()) {
            return true;
        }
        LOG.warn("Client session {} did not stop within {} seconds. Stopping will continue.", (Object)session, (Object)seconds);
        return false;
    }

    protected void cancelJobs(IClientSession session, IFuture<?> caller) {
        Predicate<IFuture<?>> jobFilter = this.createJobFilter(session, caller);
        Set runningFutures = Jobs.getJobManager().getFutures(jobFilter);
        if (!runningFutures.isEmpty()) {
            LOG.info("Cancel running model jobs because the client session was shut down. [session={}, user={}, jobs={}]", new Object[]{session, session.getUserId(), runningFutures});
            Jobs.getJobManager().cancel(jobFilter, true);
        }
    }

    protected Predicate<IFuture<?>> createJobFilter(IClientSession session, IFuture<?> caller) {
        return Jobs.newFutureFilterBuilder().andMatch((Predicate)new SessionFutureFilter((ISession)session)).andMatchNotFuture(new IFuture[]{caller}).andMatchNotState(new JobState[]{JobState.DONE, JobState.REJECTED}).toFilter();
    }
}

