/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.client.transformation;

import org.eclipse.scout.rt.client.IClientSession;
import org.eclipse.scout.rt.client.session.ClientSessionProvider;
import org.eclipse.scout.rt.client.transformation.IDeviceTransformation;
import org.eclipse.scout.rt.client.transformation.IDeviceTransformationService;
import org.eclipse.scout.rt.client.transformation.IDeviceTransformer;
import org.eclipse.scout.rt.client.transformation.MainDeviceTransformer;
import org.eclipse.scout.rt.client.transformation.NullDeviceTransformer;
import org.eclipse.scout.rt.client.ui.desktop.IDesktop;
import org.eclipse.scout.rt.client.ui.form.IForm;
import org.eclipse.scout.rt.client.ui.form.fields.IFormField;
import org.eclipse.scout.rt.platform.BEANS;
import org.eclipse.scout.rt.shared.session.ISessionListener;
import org.eclipse.scout.rt.shared.session.SessionEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DeviceTransformationService
implements IDeviceTransformationService {
    private static final Logger LOG = LoggerFactory.getLogger(DeviceTransformationService.class);
    private static final String SESSION_DATA_KEY = "DeviceTransformationServiceData";
    private final IDeviceTransformer m_nullTransformer = new NullDeviceTransformer();

    @Override
    public void install(IDesktop desktop) {
        IClientSession session = ClientSessionProvider.currentSession();
        if (session == null) {
            throw new IllegalArgumentException("No current session available");
        }
        if (desktop == null) {
            throw new IllegalArgumentException("Desktop must not be null");
        }
        if (this.getDeviceTransformer(session) != null) {
            return;
        }
        IDeviceTransformer data = this.createDeviceTransformer();
        data.setDesktop(desktop);
        session.setData(SESSION_DATA_KEY, data);
        session.addListener(new P_SessionListener());
        LOG.debug("DeviceTransformationService installed for session {}", (Object)session);
    }

    @Override
    public void uninstall() {
        this.uninstall(ClientSessionProvider.currentSession());
    }

    protected void uninstall(IClientSession session) {
        IDeviceTransformer transformer = this.getDeviceTransformer(session);
        if (transformer == null) {
            return;
        }
        transformer.dispose();
        session.setData(SESSION_DATA_KEY, null);
        LOG.debug("DeviceTransformationService uninstalled for session {}", (Object)session);
    }

    protected IDeviceTransformer createDeviceTransformer() {
        return (IDeviceTransformer)BEANS.get(MainDeviceTransformer.class);
    }

    @Override
    public IDeviceTransformer getDeviceTransformer() {
        IDeviceTransformer transformer = this.getDeviceTransformer(ClientSessionProvider.currentSession());
        if (transformer == null) {
            return this.m_nullTransformer;
        }
        return transformer;
    }

    protected IDeviceTransformer getDeviceTransformer(IClientSession session) {
        if (session == null) {
            return null;
        }
        Object data = session.getData(SESSION_DATA_KEY);
        if (data == null) {
            return null;
        }
        return (IDeviceTransformer)data;
    }

    @Override
    public void excludeTransformation(IDeviceTransformation transformation) {
        this.getDeviceTransformer().excludeTransformation(transformation);
    }

    @Override
    public void removeTransformationExclusion(IDeviceTransformation transformation) {
        this.getDeviceTransformer().removeTransformationExclusion(transformation);
    }

    @Override
    public boolean isTransformationExcluded(IDeviceTransformation transformation) {
        return this.getDeviceTransformer().isTransformationExcluded(transformation);
    }

    @Override
    public void excludeForm(IForm form) {
        this.getDeviceTransformer().excludeForm(form);
    }

    @Override
    public void excludeFormTransformation(IForm form, IDeviceTransformation transformation) {
        this.getDeviceTransformer().excludeFormTransformation(form, transformation);
    }

    @Override
    public void excludeField(IFormField formField) {
        this.getDeviceTransformer().excludeField(formField);
    }

    @Override
    public void excludeFieldTransformation(IFormField formField, IDeviceTransformation transformation) {
        this.getDeviceTransformer().excludeFieldTransformation(formField, transformation);
    }

    @Override
    public void enableTransformation(IDeviceTransformation transformation) {
        this.getDeviceTransformer().enableTransformation(transformation);
    }

    @Override
    public void disableTransformation(IDeviceTransformation transformation) {
        this.getDeviceTransformer().disableTransformation(transformation);
    }

    @Override
    public boolean isTransformationEnabled(IDeviceTransformation transformation) {
        return this.getDeviceTransformer().isTransformationEnabled(transformation);
    }

    @Override
    public boolean isTransformationEnabled(IDeviceTransformation transformation, IForm form) {
        return this.getDeviceTransformer().isTransformationEnabled(transformation, form);
    }

    @Override
    public boolean isTransformationEnabled(IDeviceTransformation transformation, IFormField field) {
        return this.getDeviceTransformer().isTransformationEnabled(transformation, field);
    }

    private class P_SessionListener
    implements ISessionListener {
        private P_SessionListener() {
        }

        public void sessionChanged(SessionEvent event) {
            if (event.getType() == 110) {
                IClientSession session = (IClientSession)event.getSource();
                session.removeListener(this);
                DeviceTransformationService.this.uninstall(session);
            }
        }
    }
}

