/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.client.transformation;

import java.util.List;
import org.eclipse.scout.rt.client.transformation.DeviceTransformationConfig;
import org.eclipse.scout.rt.client.transformation.IDeviceTransformation;
import org.eclipse.scout.rt.client.transformation.IDeviceTransformer;
import org.eclipse.scout.rt.client.ui.basic.table.ITable;
import org.eclipse.scout.rt.client.ui.desktop.IDesktop;
import org.eclipse.scout.rt.client.ui.desktop.outline.IOutline;
import org.eclipse.scout.rt.client.ui.desktop.outline.pages.IPage;
import org.eclipse.scout.rt.client.ui.desktop.outline.pages.IPageWithTable;
import org.eclipse.scout.rt.client.ui.form.IForm;
import org.eclipse.scout.rt.client.ui.form.fields.IFormField;
import org.eclipse.scout.rt.platform.BEANS;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MainDeviceTransformer
implements IDeviceTransformer {
    private static final Logger LOG = LoggerFactory.getLogger(MainDeviceTransformer.class);
    private List<IDeviceTransformer> m_transformers;

    public List<IDeviceTransformer> getTransformers() {
        if (this.m_transformers == null) {
            this.m_transformers = this.createTransformers();
            LOG.debug("Using following device transformers{}", this.m_transformers);
        }
        return this.m_transformers;
    }

    protected List<IDeviceTransformer> createTransformers() {
        return BEANS.all(IDeviceTransformer.class, transformer -> !(transformer instanceof MainDeviceTransformer) && transformer.isActive());
    }

    @Override
    public boolean isActive() {
        return !this.getTransformers().isEmpty();
    }

    @Override
    public void dispose() {
        for (IDeviceTransformer transformer : this.getTransformers()) {
            transformer.dispose();
        }
    }

    @Override
    public void setDesktop(IDesktop desktop) {
        for (IDeviceTransformer transformer : this.getTransformers()) {
            transformer.setDesktop(desktop);
        }
    }

    @Override
    public void transformDesktop() {
        for (IDeviceTransformer transformer : this.getTransformers()) {
            transformer.transformDesktop();
        }
    }

    @Override
    public void transformForm(IForm form) {
        if (this.isFormExcluded(form)) {
            return;
        }
        for (IDeviceTransformer transformer : this.getTransformers()) {
            transformer.transformForm(form);
        }
    }

    @Override
    public void notifyFormAboutToShow(IForm form) {
        for (IDeviceTransformer transformer : this.getTransformers()) {
            transformer.notifyFormAboutToShow(form);
        }
    }

    @Override
    public void notifyFormDisposed(IForm form) {
        for (IDeviceTransformer transformer : this.getTransformers()) {
            transformer.notifyFormDisposed(form);
        }
    }

    @Override
    public void notifyFieldDisposed(IFormField formField) {
        for (IDeviceTransformer transformer : this.getTransformers()) {
            transformer.notifyFieldDisposed(formField);
        }
    }

    @Override
    public void excludeTransformation(IDeviceTransformation transformation) {
        for (IDeviceTransformer transformer : this.getTransformers()) {
            transformer.excludeTransformation(transformation);
        }
    }

    @Override
    public void removeTransformationExclusion(IDeviceTransformation transformation) {
        for (IDeviceTransformer transformer : this.getTransformers()) {
            transformer.removeTransformationExclusion(transformation);
        }
    }

    @Override
    public boolean isTransformationExcluded(IDeviceTransformation transformation) {
        for (IDeviceTransformer transformer : this.getTransformers()) {
            if (!transformer.isTransformationExcluded(transformation)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void excludeForm(IForm form) {
        for (IDeviceTransformer transformer : this.getTransformers()) {
            transformer.excludeForm(form);
        }
    }

    @Override
    public void excludeFormTransformation(IForm form, IDeviceTransformation transformation) {
        for (IDeviceTransformer transformer : this.getTransformers()) {
            transformer.excludeFormTransformation(form, transformation);
        }
    }

    @Override
    public boolean isFormExcluded(IForm form) {
        for (IDeviceTransformer transformer : this.getTransformers()) {
            if (!transformer.isFormExcluded(form)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void excludeField(IFormField formField) {
        for (IDeviceTransformer transformer : this.getTransformers()) {
            transformer.excludeField(formField);
        }
    }

    @Override
    public void excludeFieldTransformation(IFormField formField, IDeviceTransformation transformation) {
        for (IDeviceTransformer transformer : this.getTransformers()) {
            transformer.excludeFieldTransformation(formField, transformation);
        }
    }

    @Override
    public boolean isFormFieldExcluded(IFormField formField) {
        for (IDeviceTransformer transformer : this.getTransformers()) {
            if (!transformer.isFormFieldExcluded(formField)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void enableTransformation(IDeviceTransformation transformation) {
        for (IDeviceTransformer transformer : this.getTransformers()) {
            transformer.enableTransformation(transformation);
        }
    }

    @Override
    public void disableTransformation(IDeviceTransformation transformation) {
        for (IDeviceTransformer transformer : this.getTransformers()) {
            transformer.disableTransformation(transformation);
        }
    }

    @Override
    public boolean isTransformationEnabled(IDeviceTransformation transformation) {
        for (IDeviceTransformer transformer : this.getTransformers()) {
            if (!transformer.isTransformationEnabled(transformation)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isTransformationEnabled(IDeviceTransformation transformation, IForm form) {
        for (IDeviceTransformer transformer : this.getTransformers()) {
            if (!transformer.isTransformationEnabled(transformation, form)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isTransformationEnabled(IDeviceTransformation transformation, IFormField field) {
        for (IDeviceTransformer transformer : this.getTransformers()) {
            if (!transformer.isTransformationEnabled(transformation, field)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void transformFormField(IFormField field) {
        if (this.isFormExcluded(field.getForm()) || this.isFormFieldExcluded(field)) {
            return;
        }
        for (IDeviceTransformer transformer : this.getTransformers()) {
            transformer.transformFormField(field);
        }
    }

    @Override
    public void transformOutline(IOutline outline) {
        for (IDeviceTransformer transformer : this.getTransformers()) {
            transformer.transformOutline(outline);
        }
    }

    @Override
    public void transformPage(IPage<?> page) {
        for (IDeviceTransformer transformer : this.getTransformers()) {
            transformer.transformPage(page);
        }
    }

    @Override
    public void transformPageTable(ITable table, IPage<?> page) {
        for (IDeviceTransformer transformer : this.getTransformers()) {
            transformer.transformPageTable(table, page);
        }
    }

    @Override
    public void notifyPageDetailFormChanged(IForm form) {
        if (form == null || this.isFormExcluded(form)) {
            return;
        }
        for (IDeviceTransformer transformer : this.getTransformers()) {
            transformer.notifyPageDetailFormChanged(form);
        }
    }

    @Override
    public void notifyPageDetailTableChanged(ITable table) {
        if (table == null) {
            return;
        }
        for (IDeviceTransformer transformer : this.getTransformers()) {
            transformer.notifyPageDetailTableChanged(table);
        }
    }

    @Override
    public void notifyDesktopClosing() {
        for (IDeviceTransformer transformer : this.getTransformers()) {
            transformer.notifyDesktopClosing();
        }
    }

    @Override
    public void notifyPageSearchFormInit(IPageWithTable<ITable> page) {
        for (IDeviceTransformer transformer : this.getTransformers()) {
            transformer.notifyPageSearchFormInit(page);
        }
    }

    @Override
    public DeviceTransformationConfig getDeviceTransformationConfig() {
        return null;
    }
}

