/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.client.transformation;

import org.eclipse.scout.rt.client.transformation.AbstractDeviceTransformer;
import org.eclipse.scout.rt.client.transformation.TabletDeviceTransformation;
import org.eclipse.scout.rt.client.ui.desktop.outline.IOutline;
import org.eclipse.scout.rt.client.ui.form.IForm;
import org.eclipse.scout.rt.platform.Order;
import org.eclipse.scout.rt.shared.ui.UserAgentUtility;

@Order(value=5300.0)
public class TabletDeviceTransformer
extends AbstractDeviceTransformer {
    protected boolean m_navigationWasVisible = false;
    protected boolean m_navigationVisibleChanging = false;

    @Override
    protected void initTransformationConfig() {
        this.enableTransformation(TabletDeviceTransformation.AUTO_HIDE_NAVIGATION);
        this.enableTransformation(TabletDeviceTransformation.USE_BREAD_CRUMB_NAVIGATION);
    }

    @Override
    public boolean isActive() {
        return UserAgentUtility.isTabletDevice();
    }

    @Override
    public void transformDesktop() {
        this.getDesktop().setCacheSplitterPosition(false);
    }

    @Override
    public void transformOutline(IOutline outline) {
        if (!this.isTransformationEnabled(TabletDeviceTransformation.USE_BREAD_CRUMB_NAVIGATION)) {
            return;
        }
        outline.setDisplayStyle("breadcrumb");
    }

    @Override
    public void notifyFormAboutToShow(IForm form) {
        super.notifyFormAboutToShow(form);
        this.hideNavigationIfNecessary(form);
    }

    @Override
    public void notifyFormDisposed(IForm form) {
        super.notifyFormDisposed(form);
        this.showNavigationIfNecessary(form);
    }

    protected void hideNavigationIfNecessary(IForm form) {
        if (!this.isTransformationEnabled(TabletDeviceTransformation.AUTO_HIDE_NAVIGATION)) {
            return;
        }
        if (form.getDisplayHint() == 20 && this.getDesktop().getViews().size() == 0) {
            boolean navigationVisible;
            this.m_navigationWasVisible = navigationVisible = this.getDesktop().isNavigationVisible();
            this.m_navigationVisibleChanging = true;
            try {
                this.getDesktop().setNavigationVisible(false);
            }
            finally {
                this.m_navigationVisibleChanging = false;
            }
        }
    }

    protected void showNavigationIfNecessary(IForm form) {
        if (!this.isTransformationEnabled(TabletDeviceTransformation.AUTO_HIDE_NAVIGATION)) {
            return;
        }
        if (this.m_navigationWasVisible && this.getDesktop().getViews().size() == 1 && this.getDesktop().getViews().get(0) == form) {
            this.m_navigationVisibleChanging = true;
            try {
                this.getDesktop().setNavigationVisible(true);
            }
            finally {
                this.m_navigationVisibleChanging = false;
            }
        }
    }
}

