/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.client.ui;

import java.io.Serializable;
import java.math.BigDecimal;
import org.eclipse.scout.rt.platform.util.NumberUtility;

public class Coordinates
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final String m_latitude;
    private final String m_longitude;

    public Coordinates(String latitude, String longitude) {
        this.m_latitude = latitude;
        this.m_longitude = longitude;
    }

    public Coordinates(BigDecimal latitude, BigDecimal longitude) {
        this.m_latitude = latitude == null ? null : latitude.toPlainString();
        this.m_longitude = longitude == null ? null : longitude.toPlainString();
    }

    public String getLatitude() {
        return this.m_latitude;
    }

    public BigDecimal getLatitudeAsBigDecimal() {
        return NumberUtility.getBigDecimalValue((Object)this.getLatitude());
    }

    public String getLongitude() {
        return this.m_longitude;
    }

    public BigDecimal getLongitudeAsBigDecimal() {
        return NumberUtility.getBigDecimalValue((Object)this.getLongitude());
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.m_latitude == null ? 0 : this.m_latitude.hashCode());
        result = 31 * result + (this.m_longitude == null ? 0 : this.m_longitude.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Coordinates other = (Coordinates)obj;
        if (this.m_latitude == null ? other.m_latitude != null : !this.m_latitude.equals(other.m_latitude)) {
            return false;
        }
        return !(this.m_longitude == null ? other.m_longitude != null : !this.m_longitude.equals(other.m_longitude));
    }

    public String toString() {
        return "Coordinates [m_latitude=" + this.m_latitude + ", m_longitude=" + this.m_longitude + "]";
    }
}

