/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.client.ui.action.keystroke;

import java.util.Iterator;
import java.util.List;
import org.eclipse.scout.rt.platform.util.CollectionUtility;
import org.eclipse.scout.rt.platform.util.StringUtility;

public class KeyStrokeNormalizer {
    private final String m_originalKeyStroke;
    private boolean m_shift;
    private boolean m_ctrl;
    private boolean m_alt;
    private String m_key;
    private String m_normalizedKeyStroke;
    private boolean m_isValid = true;

    public KeyStrokeNormalizer(String keyStroke) {
        this.m_originalKeyStroke = keyStroke;
    }

    public void normalize() {
        String keyStroke = this.m_originalKeyStroke;
        if (StringUtility.hasText((CharSequence)keyStroke)) {
            keyStroke = keyStroke.toLowerCase();
            List<String> components = this.getComponents(keyStroke);
            this.performSanityChecks(keyStroke, components);
            this.parseModifiers(components);
            this.parseKey(components);
            if (!this.m_isValid) {
                this.setInvalid();
            }
        }
    }

    private void parseKey(List<String> components) {
        String key = (String)CollectionUtility.lastElement(components);
        if (this.isModifier(key)) {
            this.m_isValid = false;
        } else {
            this.m_key = key;
            this.m_normalizedKeyStroke = String.valueOf(this.m_shift ? "shift-" : "") + (this.m_ctrl ? "control-" : "") + (this.m_alt ? "alternate-" : "") + this.m_key;
        }
    }

    private void parseModifiers(List<String> components) {
        Iterator<String> iter = components.iterator();
        while (iter.hasNext()) {
            String currentComponent = iter.next();
            if (this.isLastElement(iter)) continue;
            if (this.hasAltModifier(currentComponent)) {
                this.m_alt = true;
                continue;
            }
            if (this.hasCtrlModifier(currentComponent)) {
                this.m_ctrl = true;
                continue;
            }
            if (this.hasShiftModifier(currentComponent)) {
                this.m_shift = true;
                continue;
            }
            this.m_isValid = false;
        }
    }

    private boolean isLastElement(Iterator<String> iter) {
        return !iter.hasNext();
    }

    private void performSanityChecks(String keystroke, List<String> components) {
        if (components.size() > 1 && keystroke.endsWith("-") && !"-".equals(CollectionUtility.lastElement(components))) {
            this.m_isValid = false;
        }
    }

    private boolean isModifier(String component) {
        return this.hasAltModifier(component) || this.hasShiftModifier(component) || this.hasCtrlModifier(component);
    }

    private boolean hasAltModifier(String component) {
        return "alt".equalsIgnoreCase(component) || "alternate".equalsIgnoreCase(component);
    }

    private boolean hasCtrlModifier(String component) {
        return "control".equalsIgnoreCase(component) || "ctrl".equalsIgnoreCase(component) || "strg".equalsIgnoreCase(component);
    }

    private boolean hasShiftModifier(String component) {
        return "shift".equalsIgnoreCase(component);
    }

    private List<String> getComponents(String keyStroke) {
        Object[] components = keyStroke.trim().split("\\b-|-\\b");
        return CollectionUtility.arrayList((Object[])components);
    }

    private void setInvalid() {
        this.m_normalizedKeyStroke = null;
        this.m_key = null;
        this.m_alt = false;
        this.m_shift = false;
        this.m_ctrl = false;
        this.m_isValid = false;
    }

    public boolean hasShift() {
        return this.m_shift;
    }

    public boolean hasCtrl() {
        return this.m_ctrl;
    }

    public boolean hasAlt() {
        return this.m_alt;
    }

    public String getKey() {
        return this.m_key;
    }

    public String getNormalizedKeystroke() {
        return this.m_normalizedKeyStroke;
    }

    public boolean isValid() {
        return this.m_isValid;
    }
}

