/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.client.ui.action.menu;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.scout.rt.client.ui.action.menu.IMenu;
import org.eclipse.scout.rt.client.ui.action.menu.root.ContextMenuEvent;
import org.eclipse.scout.rt.client.ui.action.menu.root.ContextMenuListener;
import org.eclipse.scout.rt.client.ui.action.menu.root.IContextMenuOwner;
import org.eclipse.scout.rt.client.ui.desktop.outline.MenuWrapper;

public class MenuMediator {
    private ContextMenuListener m_contextMenuListener;
    private final List<IMenu> m_menus = new ArrayList<IMenu>();
    private IContextMenuOwner m_source;
    private IContextMenuOwner m_destination;

    public MenuMediator(IContextMenuOwner source, IContextMenuOwner destination) {
        this.m_source = source;
        this.m_destination = destination;
    }

    public void install() {
        if (this.m_contextMenuListener != null) {
            return;
        }
        this.m_contextMenuListener = new P_SourceContextMenuListener();
        this.getSource().getContextMenu().addContextMenuListener(this.m_contextMenuListener);
        this.mediateMenus();
    }

    public void uninstall() {
        if (this.m_contextMenuListener == null) {
            return;
        }
        this.getSource().getContextMenu().removeContextMenuListener(this.m_contextMenuListener);
        this.m_contextMenuListener = null;
        this.unmediateMenus();
    }

    protected void unmediateMenus() {
        this.getDestination().getContextMenu().removeChildActions(this.getMenus());
    }

    protected void mediateMenus() {
        this.unmediateMenus();
        List<IMenu> sourceMenus = this.getSource().getMenus();
        for (IMenu menu : sourceMenus) {
            this.m_menus.add(MenuWrapper.wrapMenuIfNotWrapped(menu));
        }
        this.getDestination().getContextMenu().addChildActions(this.m_menus);
    }

    public IContextMenuOwner getSource() {
        return this.m_source;
    }

    public IContextMenuOwner getDestination() {
        return this.m_destination;
    }

    public List<IMenu> getMenus() {
        return this.m_menus;
    }

    protected class P_SourceContextMenuListener
    implements ContextMenuListener {
        protected P_SourceContextMenuListener() {
        }

        @Override
        public void contextMenuChanged(ContextMenuEvent event) {
            if (1 == event.getType()) {
                MenuMediator.this.mediateMenus();
            }
        }
    }
}

