/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.client.ui.action.menu;

import java.util.Collections;
import java.util.List;
import org.eclipse.scout.rt.client.ui.action.ActionFinder;
import org.eclipse.scout.rt.client.ui.action.menu.IMenu;
import org.eclipse.scout.rt.client.ui.action.menu.root.IContextMenu;
import org.eclipse.scout.rt.client.ui.action.menu.root.IContextMenuOwner;
import org.eclipse.scout.rt.client.ui.action.tree.IActionNode;

public final class MenuUtility {
    private MenuUtility() {
    }

    public static <T extends IActionNode<?>> boolean isVisible(T menu) {
        if (!menu.isVisible()) {
            return false;
        }
        if (menu.hasChildActions()) {
            boolean visible = false;
            for (Object o : menu.getChildActions()) {
                IActionNode m;
                if (!(o instanceof IActionNode) || (m = (IActionNode)o).isSeparator() || !m.isVisible()) continue;
                visible = true;
                break;
            }
            return visible;
        }
        return true;
    }

    public static <T extends IMenu> T getMenuByClass(IContextMenuOwner contextMenuOwner, Class<T> menuType) {
        if (contextMenuOwner == null) {
            throw new IllegalArgumentException("Argument 'contextMenuOwner' must not be null");
        }
        IContextMenu root = contextMenuOwner.getContextMenu();
        List<IMenu> rootMenus = root == null ? contextMenuOwner.getMenus() : Collections.singletonList(root);
        return (T)((IMenu)new ActionFinder().findAction(rootMenus, menuType));
    }
}

