/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.client.ui.action.menu.root.internal;

import java.util.Collections;
import java.util.Set;
import java.util.function.Consumer;
import org.eclipse.scout.rt.client.ui.action.menu.IMenu;
import org.eclipse.scout.rt.client.ui.action.menu.IMenuType;
import org.eclipse.scout.rt.client.ui.action.menu.IReadOnlyMenu;

public class MenuOwnerChangedVisitor
implements Consumer<IMenu> {
    private final Object m_ownerValue;
    private final Set<? extends IMenuType> m_menuTypes;

    public MenuOwnerChangedVisitor(Object ownerValue, Set<? extends IMenuType> menuTypes) {
        this.m_ownerValue = ownerValue;
        this.m_menuTypes = menuTypes;
    }

    @Override
    public void accept(IMenu menu) {
        if (!Collections.disjoint(menu.getMenuTypes(), this.m_menuTypes) && !(menu instanceof IReadOnlyMenu)) {
            menu.handleOwnerValueChanged(this.m_ownerValue);
        }
    }
}

