/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.client.ui.action.menu.root.internal;

import java.beans.PropertyChangeEvent;
import java.util.List;
import java.util.Set;
import org.eclipse.scout.rt.client.ui.action.ActionUtility;
import org.eclipse.scout.rt.client.ui.action.menu.IMenu;
import org.eclipse.scout.rt.client.ui.action.menu.TableMenuType;
import org.eclipse.scout.rt.client.ui.action.menu.root.AbstractContextMenu;
import org.eclipse.scout.rt.client.ui.action.menu.root.ITableContextMenu;
import org.eclipse.scout.rt.client.ui.action.menu.root.internal.MenuOwnerChangedVisitor;
import org.eclipse.scout.rt.client.ui.basic.table.ITable;
import org.eclipse.scout.rt.client.ui.basic.table.ITableRow;
import org.eclipse.scout.rt.client.ui.basic.table.TableEvent;
import org.eclipse.scout.rt.platform.classid.ClassId;
import org.eclipse.scout.rt.platform.util.CollectionUtility;

@ClassId(value="97f17065-0142-4362-9dd4-a34148e20bb3")
public class TableContextMenu
extends AbstractContextMenu<ITable>
implements ITableContextMenu {
    private List<? extends ITableRow> m_currentSelection;

    public TableContextMenu(ITable owner, List<? extends IMenu> initialChildMenus) {
        super(owner, initialChildMenus);
    }

    @Override
    protected void initConfig() {
        super.initConfig();
        ITable container = (ITable)this.getContainer();
        container.addTableListener(this::tableChanged, 103, 101);
        this.setCurrentMenuTypes(this.getMenuTypesForSelection(container.getSelectedRows()));
        this.calculateLocalVisibility();
    }

    protected void tableChanged(TableEvent e) {
        switch (e.getType()) {
            case 103: {
                this.handleOwnerValueChanged();
                break;
            }
            case 101: {
                if (!CollectionUtility.containsAny(e.getRows(), this.m_currentSelection)) break;
                this.handleOwnerValueChanged();
            }
        }
    }

    @Override
    public void callOwnerValueChanged() {
        this.handleOwnerValueChanged();
    }

    @Override
    protected boolean isOwnerPropertyChangedListenerRequired() {
        return true;
    }

    @Override
    protected void handleOwnerPropertyChanged(PropertyChangeEvent evt) {
        super.handleOwnerPropertyChanged(evt);
        if ("enabled".equals(evt.getPropertyName())) {
            this.calculateEnabledState();
        }
    }

    protected void handleOwnerValueChanged() {
        this.m_currentSelection = null;
        ITable container = (ITable)this.getContainer();
        if (container != null) {
            List<ITableRow> ownerValue = container.getSelectedRows();
            this.m_currentSelection = CollectionUtility.arrayList(ownerValue);
            this.setCurrentMenuTypes(this.getMenuTypesForSelection(ownerValue));
            this.visit(new MenuOwnerChangedVisitor(ownerValue, this.getCurrentMenuTypes()), IMenu.class);
            this.calculateLocalVisibility();
            this.calculateEnabledState();
        }
    }

    protected boolean isSelectionEnabled() {
        return ((ITable)this.getContainer()).getSelectedRows().stream().allMatch(ITableRow::isEnabled);
    }

    protected void calculateEnabledState() {
        ActionUtility.updateContextMenuEnabledState(this, this::isSelectionEnabled, TableMenuType.MultiSelection, TableMenuType.SingleSelection);
    }

    protected Set<TableMenuType> getMenuTypesForSelection(List<? extends ITableRow> selection) {
        if (CollectionUtility.isEmpty(selection)) {
            return CollectionUtility.hashSet((Object)TableMenuType.EmptySpace);
        }
        if (CollectionUtility.size(selection) == 1) {
            return CollectionUtility.hashSet((Object)TableMenuType.SingleSelection);
        }
        return CollectionUtility.hashSet((Object)TableMenuType.MultiSelection);
    }
}

