/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.client.ui.action.menu.root.internal;

import java.beans.PropertyChangeEvent;
import java.util.List;
import java.util.Set;
import org.eclipse.scout.rt.client.ui.action.menu.IMenu;
import org.eclipse.scout.rt.client.ui.action.menu.TileGridMenuType;
import org.eclipse.scout.rt.client.ui.action.menu.root.AbstractContextMenu;
import org.eclipse.scout.rt.client.ui.action.menu.root.ITileGridContextMenu;
import org.eclipse.scout.rt.client.ui.action.menu.root.internal.MenuOwnerChangedVisitor;
import org.eclipse.scout.rt.client.ui.tile.ITile;
import org.eclipse.scout.rt.client.ui.tile.ITileGrid;
import org.eclipse.scout.rt.platform.classid.ClassId;
import org.eclipse.scout.rt.platform.util.CollectionUtility;

@ClassId(value="6c1c8e1a-bee2-49fc-8bcc-e2169037fb7e")
public class TileGridContextMenu
extends AbstractContextMenu<ITileGrid<? extends ITile>>
implements ITileGridContextMenu {
    public TileGridContextMenu(ITileGrid<? extends ITile> owner, List<? extends IMenu> initialChildMenus) {
        super(owner, initialChildMenus);
    }

    @Override
    protected void initConfig() {
        super.initConfig();
        this.setCurrentMenuTypes(this.getMenuTypesForSelection(((ITileGrid)this.getContainer()).getSelectedTiles()));
        this.calculateLocalVisibility();
    }

    @Override
    public void callOwnerValueChanged() {
        this.handleOwnerValueChanged();
    }

    protected void handleOwnerValueChanged() {
        ITileGrid container = (ITileGrid)this.getContainer();
        if (container == null) {
            return;
        }
        List ownerValue = container.getSelectedTiles();
        this.setCurrentMenuTypes(this.getMenuTypesForSelection(ownerValue));
        this.visit(new MenuOwnerChangedVisitor(ownerValue, this.getCurrentMenuTypes()), IMenu.class);
        this.calculateLocalVisibility();
    }

    @Override
    protected void handleOwnerPropertyChanged(PropertyChangeEvent evt) {
        super.handleOwnerPropertyChanged(evt);
        if ("selectedTiles".equals(evt.getPropertyName())) {
            this.handleOwnerValueChanged();
        }
    }

    @Override
    protected boolean isOwnerPropertyChangedListenerRequired() {
        return true;
    }

    protected Set<TileGridMenuType> getMenuTypesForSelection(List<? extends ITile> selection) {
        if (CollectionUtility.isEmpty(selection)) {
            return CollectionUtility.hashSet((Object)TileGridMenuType.EmptySpace);
        }
        if (CollectionUtility.size(selection) == 1) {
            return CollectionUtility.hashSet((Object)TileGridMenuType.SingleSelection);
        }
        return CollectionUtility.hashSet((Object)TileGridMenuType.MultiSelection);
    }
}

