/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.client.ui.basic.calendar;

import java.util.Date;
import org.eclipse.scout.rt.client.ui.basic.calendar.ICalendar;
import org.eclipse.scout.rt.client.ui.basic.calendar.provider.ICalendarItemProvider;
import org.eclipse.scout.rt.platform.util.Range;
import org.eclipse.scout.rt.platform.util.StringUtility;
import org.eclipse.scout.rt.platform.util.date.DateUtility;
import org.eclipse.scout.rt.shared.services.common.calendar.ICalendarAppointment;
import org.eclipse.scout.rt.shared.services.common.calendar.ICalendarItem;
import org.eclipse.scout.rt.shared.services.common.calendar.ICalendarTask;

public class CalendarComponent
implements Comparable<CalendarComponent> {
    private final ICalendar m_calendar;
    private final ICalendarItemProvider m_producer;
    private final ICalendarItem m_item;
    private final Date m_fromDate;
    private final Date m_toDate;
    private final Range<Date> m_coveredDaysRange;
    private final boolean m_fullDay;

    protected CalendarComponent(ICalendar calendar, ICalendarItemProvider producer, ICalendarItem item) {
        ICalendarTask task;
        ICalendarAppointment app;
        this.m_calendar = calendar;
        this.m_producer = producer;
        this.m_item = item;
        Date d = null;
        if (this.m_item instanceof ICalendarAppointment) {
            app = (ICalendarAppointment)this.m_item;
            d = DateUtility.min((Date[])new Date[]{app.getStart(), app.getEnd()});
        }
        if (this.m_item instanceof ICalendarTask) {
            task = (ICalendarTask)this.m_item;
            d = DateUtility.min((Date[])new Date[]{task.getStart(), task.getDue(), task.getComplete()});
        }
        if (d == null) {
            d = new Date(0L);
        }
        this.m_fromDate = d;
        d = null;
        if (this.m_item instanceof ICalendarAppointment) {
            app = (ICalendarAppointment)this.m_item;
            d = DateUtility.max((Date[])new Date[]{app.getStart(), app.getEnd()});
        }
        if (this.m_item instanceof ICalendarTask) {
            task = (ICalendarTask)this.m_item;
            d = DateUtility.max((Date[])new Date[]{task.getStart(), task.getDue(), task.getComplete()});
        }
        if (d == null) {
            d = new Date(0L);
        }
        this.m_toDate = d;
        this.m_coveredDaysRange = new Range((Object)DateUtility.truncDate((Date)this.m_fromDate), (Object)DateUtility.truncDate((Date)this.m_toDate));
        this.m_fullDay = this.m_item instanceof ICalendarAppointment ? ((ICalendarAppointment)this.m_item).isFullDay() : true;
    }

    public ICalendarItem getItem() {
        return this.m_item;
    }

    public ICalendarItemProvider getProvider() {
        return this.m_producer;
    }

    public ICalendar getCalendar() {
        return this.m_calendar;
    }

    public Date getFromDate() {
        return this.m_fromDate;
    }

    public Date getToDate() {
        return this.m_toDate;
    }

    public Range<Date> getCoveredDaysRange() {
        return this.m_coveredDaysRange;
    }

    public boolean isFullDay() {
        return this.m_fullDay;
    }

    public boolean isDraggable() {
        return this.m_producer.isMoveItemEnabled();
    }

    @Override
    public int compareTo(CalendarComponent o) {
        String label2;
        String label1;
        if (this.m_item instanceof Comparable) {
            return ((Comparable)this.m_item).compareTo(o.getItem());
        }
        int i = this.getFromDate().compareTo(o.getFromDate());
        if (i == 0 && (i = StringUtility.compareIgnoreCase((String)(label1 = this.m_item.getSubject()), (String)(label2 = o.getItem().getSubject()))) == 0) {
            i = Integer.compare(this.hashCode(), o.hashCode());
        }
        return i;
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.m_item == null ? 0 : this.m_item.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CalendarComponent other = (CalendarComponent)obj;
        return !(this.m_item == null ? other.m_item != null : !this.m_item.equals(other.m_item));
    }
}

