/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.client.ui.basic.calendar;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.eclipse.scout.rt.client.ui.basic.calendar.CalendarComponent;
import org.eclipse.scout.rt.client.ui.basic.calendar.provider.ICalendarItemProvider;

public class CalendarItemConflict {
    private final Map<Class<? extends ICalendarItemProvider>, Collection<CalendarComponent>> m_componentsByProvider;
    private final List<CalendarComponent> m_components;
    private final double m_match;

    public CalendarItemConflict(Map<Class<? extends ICalendarItemProvider>, Collection<CalendarComponent>> componentsByProvider, List<CalendarComponent> components, double match) {
        this.m_componentsByProvider = componentsByProvider;
        this.m_components = components;
        this.m_match = match;
    }

    public double getMatch() {
        return this.m_match;
    }

    public List<CalendarComponent> getComponents() {
        return this.m_components;
    }

    public void acceptComponentOf(Class<? extends ICalendarItemProvider> providerType) {
        for (CalendarComponent comp : this.m_components) {
            Class<?> pcls = comp.getProvider().getClass();
            if (providerType.isAssignableFrom(pcls)) continue;
            this.m_componentsByProvider.get(pcls).remove(comp);
        }
    }
}

