/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.client.ui.basic.calendar.provider;

import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.eclipse.scout.rt.client.IClientSession;
import org.eclipse.scout.rt.client.context.ClientRunContexts;
import org.eclipse.scout.rt.client.extension.ui.action.tree.MoveActionNodesHandler;
import org.eclipse.scout.rt.client.extension.ui.basic.calendar.provider.CalendarItemProviderChains;
import org.eclipse.scout.rt.client.extension.ui.basic.calendar.provider.ICalendarItemProviderExtension;
import org.eclipse.scout.rt.client.job.ModelJobs;
import org.eclipse.scout.rt.client.session.ClientSessionProvider;
import org.eclipse.scout.rt.client.ui.action.menu.IMenu;
import org.eclipse.scout.rt.client.ui.basic.calendar.provider.ICalendarItemProvider;
import org.eclipse.scout.rt.client.ui.basic.cell.Cell;
import org.eclipse.scout.rt.platform.IOrdered;
import org.eclipse.scout.rt.platform.Order;
import org.eclipse.scout.rt.platform.annotations.ConfigOperation;
import org.eclipse.scout.rt.platform.annotations.ConfigProperty;
import org.eclipse.scout.rt.platform.context.RunContext;
import org.eclipse.scout.rt.platform.context.RunMonitor;
import org.eclipse.scout.rt.platform.exception.VetoException;
import org.eclipse.scout.rt.platform.job.FixedDelayScheduleBuilder;
import org.eclipse.scout.rt.platform.job.IFuture;
import org.eclipse.scout.rt.platform.job.JobInput;
import org.eclipse.scout.rt.platform.job.Jobs;
import org.eclipse.scout.rt.platform.reflect.AbstractPropertyObserver;
import org.eclipse.scout.rt.platform.reflect.ConfigurationUtility;
import org.eclipse.scout.rt.platform.util.CollectionUtility;
import org.eclipse.scout.rt.platform.util.collection.OrderedCollection;
import org.eclipse.scout.rt.platform.util.concurrent.FutureCancelledError;
import org.eclipse.scout.rt.platform.util.concurrent.IRunnable;
import org.eclipse.scout.rt.platform.util.concurrent.ThreadInterruptedError;
import org.eclipse.scout.rt.platform.util.date.DateUtility;
import org.eclipse.scout.rt.shared.extension.AbstractExtension;
import org.eclipse.scout.rt.shared.extension.ContributionComposite;
import org.eclipse.scout.rt.shared.extension.IContributionOwner;
import org.eclipse.scout.rt.shared.extension.IExtensibleObject;
import org.eclipse.scout.rt.shared.extension.IExtension;
import org.eclipse.scout.rt.shared.extension.ObjectExtensions;
import org.eclipse.scout.rt.shared.services.common.calendar.ICalendarItem;
import org.quartz.ScheduleBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractCalendarItemProvider
extends AbstractPropertyObserver
implements ICalendarItemProvider,
IContributionOwner,
IExtensibleObject {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractCalendarItemProvider.class);
    private volatile IFuture<Void> m_reloadJob;
    private boolean m_initialized;
    private List<IMenu> m_menus;
    private Date m_minDateLoaded;
    private Date m_maxDateLoaded;
    private IContributionOwner m_contributionHolder;
    private final ObjectExtensions<AbstractCalendarItemProvider, ICalendarItemProviderExtension<? extends AbstractCalendarItemProvider>> m_objectExtensions = new ObjectExtensions((Object)this, false);

    public AbstractCalendarItemProvider() {
        this(true);
    }

    public AbstractCalendarItemProvider(boolean callInitializer) {
        if (callInitializer) {
            this.callInitializer();
        }
    }

    public final List<Object> getAllContributions() {
        return this.m_contributionHolder.getAllContributions();
    }

    public final <T> List<T> getContributionsByClass(Class<T> type) {
        return this.m_contributionHolder.getContributionsByClass(type);
    }

    public final <T> T getContribution(Class<T> contribution) {
        return (T)this.m_contributionHolder.getContribution(contribution);
    }

    public final <T> T optContribution(Class<T> contribution) {
        return (T)this.m_contributionHolder.optContribution(contribution);
    }

    protected void callInitializer() {
        if (!this.m_initialized) {
            this.interceptInitConfig();
            this.m_initialized = true;
        }
    }

    @ConfigProperty(value="BOOLEAN")
    @Order(value=10.0)
    protected boolean getConfiguredMoveItemEnabled() {
        return false;
    }

    @ConfigProperty(value="LONG")
    @Order(value=20.0)
    protected long getConfiguredRefreshIntervallMillis() {
        return 0L;
    }

    protected List<Class<? extends IMenu>> getDeclaredMenus() {
        Class[] dca = ConfigurationUtility.getDeclaredPublicClasses(this.getClass());
        List filtered = ConfigurationUtility.filterClasses((Class[])dca, IMenu.class);
        return ConfigurationUtility.removeReplacedClasses((List)filtered);
    }

    @ConfigOperation
    @Order(value=30.0)
    protected void execLoadItems(Date minDate, Date maxDate, Set<ICalendarItem> result) {
    }

    @ConfigOperation
    @Order(value=40.0)
    protected void execLoadItemsInBackground(IClientSession session, Date minDate, Date maxDate, Set<ICalendarItem> result) {
        ModelJobs.schedule(() -> this.interceptLoadItems(minDate, maxDate, result), ModelJobs.newInput(ClientRunContexts.copyCurrent().withSession(session, true))).awaitDone();
    }

    @ConfigOperation
    @Order(value=10.0)
    protected void execDecorateCell(Cell cell, ICalendarItem item) {
    }

    @ConfigOperation
    @Order(value=20.0)
    protected void execItemMoved(ICalendarItem item, Date newDate) {
    }

    @ConfigOperation
    @Order(value=50.0)
    protected void execItemAction(ICalendarItem item) {
    }

    protected final void interceptInitConfig() {
        this.m_objectExtensions.initConfig(this.createLocalExtension(), this::initConfig);
    }

    protected void initConfig() {
        this.m_contributionHolder = new ContributionComposite((Object)this);
        this.setMoveItemEnabled(this.getConfiguredMoveItemEnabled());
        this.setRefreshIntervalMillis(this.getConfiguredRefreshIntervallMillis());
        List<Class<? extends IMenu>> declaredMenus = this.getDeclaredMenus();
        OrderedCollection menus = new OrderedCollection();
        for (Class<? extends IMenu> menuClazz : declaredMenus) {
            IMenu menu = (IMenu)ConfigurationUtility.newInnerInstance((Object)this, menuClazz);
            menu.init();
            menus.addOrdered((IOrdered)menu);
        }
        List contributedMenus = this.m_contributionHolder.getContributionsByClass(IMenu.class);
        menus.addAllOrdered((Collection)contributedMenus);
        try {
            this.injectMenusInternal((OrderedCollection<IMenu>)menus);
        }
        catch (Exception e) {
            LOG.error("Error occurred while dynamically contribute menus.", (Throwable)e);
        }
        new MoveActionNodesHandler(menus).moveModelObjects();
        this.m_menus = menus.getOrderedList();
    }

    public final List<? extends ICalendarItemProviderExtension<? extends AbstractCalendarItemProvider>> getAllExtensions() {
        return this.m_objectExtensions.getAllExtensions();
    }

    protected ICalendarItemProviderExtension<? extends AbstractCalendarItemProvider> createLocalExtension() {
        return new LocalCalendarItemProviderExtension<AbstractCalendarItemProvider>(this);
    }

    public <T extends IExtension<?>> T getExtension(Class<T> c) {
        return (T)this.m_objectExtensions.getExtension(c);
    }

    protected void injectMenusInternal(OrderedCollection<IMenu> menus) {
    }

    @Override
    public void disposeProvider() {
        IFuture<Void> job = this.m_reloadJob;
        if (job != null) {
            job.cancel(true);
            this.m_reloadJob = null;
        }
    }

    @Override
    public Set<ICalendarItem> getItems(Date minDate, Date maxDate) {
        this.ensureItemsLoadedInternal(minDate, maxDate);
        Set allItems = this.propertySupport.getPropertySet("items");
        if (CollectionUtility.hasElements((Collection)allItems)) {
            HashSet<ICalendarItem> list = new HashSet<ICalendarItem>(allItems.size());
            for (ICalendarItem item : allItems) {
                if (!item.isIntersecting(minDate, maxDate)) continue;
                list.add(item);
            }
            return list;
        }
        return CollectionUtility.hashSet((Object[])new ICalendarItem[0]);
    }

    @Override
    public void reloadProvider() {
        this.loadItemsAsyncInternal(ClientSessionProvider.currentSession(), this.m_minDateLoaded, this.m_maxDateLoaded, 250L);
    }

    private void setItemsInternal(Date minDate, Date maxDate, Set<ICalendarItem> items0) {
        HashSet items = CollectionUtility.hashSetWithoutNullElements(items0);
        this.m_minDateLoaded = minDate;
        this.m_maxDateLoaded = maxDate;
        this.propertySupport.setPropertySet("items", (Set)items);
    }

    @Override
    public List<IMenu> getMenus() {
        return CollectionUtility.arrayList(this.m_menus);
    }

    @Override
    public boolean isMoveItemEnabled() {
        return this.propertySupport.getPropertyBool("moveItemEnabled");
    }

    @Override
    public void setMoveItemEnabled(boolean b) {
        this.propertySupport.setPropertyBool("moveItemEnabled", b);
    }

    @Override
    public boolean isLoadInProgress() {
        return this.propertySupport.getPropertyBool("loadInProgress");
    }

    @Override
    public void setLoadInProgress(boolean loadInProgress) {
        if (ModelJobs.isModelThread()) {
            this.propertySupport.setPropertyBool("loadInProgress", loadInProgress);
        } else {
            try {
                ModelJobs.schedule(() -> this.propertySupport.setPropertyBool("loadInProgress", loadInProgress), ModelJobs.newInput(ClientRunContexts.copyCurrent())).awaitDone();
            }
            catch (ThreadInterruptedError threadInterruptedError) {}
        }
    }

    @Override
    public long getRefreshIntervalMillis() {
        return this.propertySupport.getPropertyLong("refreshIntervalMillis");
    }

    @Override
    public void setRefreshIntervalMillis(long m) {
        this.propertySupport.setPropertyLong("refreshIntervalMillis", m);
        if (m > 0L) {
            this.loadItemsAsyncInternal(ClientSessionProvider.currentSession(), this.m_minDateLoaded, this.m_maxDateLoaded, m);
        }
    }

    @Override
    public void onItemAction(ICalendarItem item) {
        this.interceptItemAction(item);
    }

    @Override
    public void onItemMoved(ICalendarItem item, Date newDate) {
        this.interceptItemMoved(item, newDate);
    }

    private void ensureItemsLoadedInternal(Date minDate, Date maxDate) {
        if (!DateUtility.isInRange((Date)this.m_minDateLoaded, (Date)minDate, (Date)this.m_maxDateLoaded) || !DateUtility.isInRange((Date)this.m_minDateLoaded, (Date)maxDate, (Date)this.m_maxDateLoaded)) {
            this.loadItemsAsyncInternal(ClientSessionProvider.currentSession(), minDate, maxDate, 250L);
        }
    }

    private synchronized void loadItemsAsyncInternal(IClientSession session, Date minDate, Date maxDate, long startDelayMillis) {
        IFuture<Void> oldJob = this.m_reloadJob;
        if (oldJob != null) {
            oldJob.cancel(true);
            this.m_reloadJob = null;
        }
        if (minDate != null && maxDate != null) {
            long refreshInterval = this.getRefreshIntervalMillis();
            P_ReloadJob runnable = new P_ReloadJob(minDate, maxDate);
            this.m_reloadJob = refreshInterval > 0L ? Jobs.schedule((IRunnable)runnable, (JobInput)Jobs.newInput().withName("Loading calendar items", new Object[0]).withRunContext((RunContext)ClientRunContexts.copyCurrent().withSession(session, true)).withExecutionTrigger(Jobs.newExecutionTrigger().withStartIn(startDelayMillis, TimeUnit.MILLISECONDS).withSchedule((ScheduleBuilder)FixedDelayScheduleBuilder.repeatForever((long)refreshInterval, (TimeUnit)TimeUnit.MILLISECONDS)))) : Jobs.schedule((IRunnable)runnable, (JobInput)Jobs.newInput().withName("Loading calendar items", new Object[0]).withRunContext((RunContext)ClientRunContexts.copyCurrent().withSession(session, true)).withExecutionTrigger(Jobs.newExecutionTrigger().withStartIn(startDelayMillis, TimeUnit.MILLISECONDS)));
        }
    }

    protected final void interceptLoadItems(Date minDate, Date maxDate, Set<ICalendarItem> result) {
        List<? extends ICalendarItemProviderExtension<? extends AbstractCalendarItemProvider>> extensions = this.getAllExtensions();
        CalendarItemProviderChains.CalendarItemProviderLoadItemsChain chain = new CalendarItemProviderChains.CalendarItemProviderLoadItemsChain(extensions);
        chain.execLoadItems(minDate, maxDate, result);
    }

    protected final void interceptItemAction(ICalendarItem item) {
        List<? extends ICalendarItemProviderExtension<? extends AbstractCalendarItemProvider>> extensions = this.getAllExtensions();
        CalendarItemProviderChains.CalendarItemProviderItemActionChain chain = new CalendarItemProviderChains.CalendarItemProviderItemActionChain(extensions);
        chain.execItemAction(item);
    }

    protected final void interceptLoadItemsInBackground(IClientSession session, Date minDate, Date maxDate, Set<ICalendarItem> result) {
        List<? extends ICalendarItemProviderExtension<? extends AbstractCalendarItemProvider>> extensions = this.getAllExtensions();
        CalendarItemProviderChains.CalendarItemProviderLoadItemsInBackgroundChain chain = new CalendarItemProviderChains.CalendarItemProviderLoadItemsInBackgroundChain(extensions);
        chain.execLoadItemsInBackground(session, minDate, maxDate, result);
    }

    protected final void interceptItemMoved(ICalendarItem item, Date newDate) {
        List<? extends ICalendarItemProviderExtension<? extends AbstractCalendarItemProvider>> extensions = this.getAllExtensions();
        CalendarItemProviderChains.CalendarItemProviderItemMovedChain chain = new CalendarItemProviderChains.CalendarItemProviderItemMovedChain(extensions);
        chain.execItemMoved(item, newDate);
    }

    protected static class LocalCalendarItemProviderExtension<OWNER extends AbstractCalendarItemProvider>
    extends AbstractExtension<OWNER>
    implements ICalendarItemProviderExtension<OWNER> {
        public LocalCalendarItemProviderExtension(OWNER owner) {
            super(owner);
        }

        @Override
        public void execLoadItems(CalendarItemProviderChains.CalendarItemProviderLoadItemsChain chain, Date minDate, Date maxDate, Set<ICalendarItem> result) {
            ((AbstractCalendarItemProvider)this.getOwner()).execLoadItems(minDate, maxDate, result);
        }

        @Override
        public void execItemAction(CalendarItemProviderChains.CalendarItemProviderItemActionChain chain, ICalendarItem item) {
            ((AbstractCalendarItemProvider)this.getOwner()).execItemAction(item);
        }

        @Override
        public void execLoadItemsInBackground(CalendarItemProviderChains.CalendarItemProviderLoadItemsInBackgroundChain chain, IClientSession session, Date minDate, Date maxDate, Set<ICalendarItem> result) {
            ((AbstractCalendarItemProvider)this.getOwner()).execLoadItemsInBackground(session, minDate, maxDate, result);
        }

        @Override
        public void execItemMoved(CalendarItemProviderChains.CalendarItemProviderItemMovedChain chain, ICalendarItem item, Date newDate) {
            ((AbstractCalendarItemProvider)this.getOwner()).execItemMoved(item, newDate);
        }
    }

    private class P_ReloadJob
    implements IRunnable {
        private final Set<ICalendarItem> m_result = new HashSet<ICalendarItem>();
        private final Date m_loadingMinDate;
        private final Date m_loadingMaxDate;

        public P_ReloadJob(Date loadingMinDate, Date loadingMaxDate) {
            this.m_loadingMinDate = loadingMinDate;
            this.m_loadingMaxDate = loadingMaxDate;
        }

        public void run() throws Exception {
            if (((RunMonitor)RunMonitor.CURRENT.get()).isCancelled()) {
                return;
            }
            AbstractCalendarItemProvider.this.setLoadInProgress(true);
            try {
                try {
                    AbstractCalendarItemProvider.this.interceptLoadItemsInBackground(ClientSessionProvider.currentSession(), this.m_loadingMinDate, this.m_loadingMaxDate, this.m_result);
                }
                catch (FutureCancelledError | ThreadInterruptedError throwable) {
                }
                catch (VetoException e) {
                    LOG.info("Failed to reload calendar items: {}", (Object)e.getDisplayMessage());
                }
                catch (RuntimeException e) {
                    LOG.error("Failed to reload calendar items", (Throwable)e);
                }
                ModelJobs.schedule(() -> {
                    AbstractCalendarItemProvider abstractCalendarItemProvider = AbstractCalendarItemProvider.this;
                    synchronized (abstractCalendarItemProvider) {
                        if (!((RunMonitor)RunMonitor.CURRENT.get()).isCancelled()) {
                            AbstractCalendarItemProvider.this.setItemsInternal(this.m_loadingMinDate, this.m_loadingMaxDate, this.m_result);
                        }
                    }
                }, ModelJobs.newInput(ClientRunContexts.copyCurrent())).awaitDone();
            }
            finally {
                AbstractCalendarItemProvider.this.setLoadInProgress(false);
            }
        }
    }
}

