/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.client.ui.basic.cell;

import org.eclipse.scout.rt.client.ui.basic.cell.ICellObserver;
import org.eclipse.scout.rt.platform.html.HTML;
import org.eclipse.scout.rt.platform.status.IMultiStatus;
import org.eclipse.scout.rt.shared.data.basic.FontSpec;

public interface ICell {
    public static final int OBSERVER_BIT = 0;
    public static final int VALUE_BIT = 1;
    public static final int TEXT_BIT = 2;
    public static final int ICON_ID_BIT = 3;
    public static final int TOOLTIP_BIT = 4;
    public static final int H_ALIGN_BIT = 5;
    public static final int BG_COLOR_BIT = 6;
    public static final int FG_COLOR_BIT = 7;
    public static final int FONT_BIT = 8;
    public static final int EDITABLE_BIT = 10;
    public static final int CSS_CLASS_BIT = 11;
    public static final int HTML_ENABLED_BIT = 12;
    public static final int MANDATORY_BIT = 13;
    public static final int ERROR_STATUS_BIT = 14;

    public Object getValue();

    public String getText();

    default public String toPlainText() {
        String text = this.getText();
        if (text != null && this.isHtmlEnabled()) {
            text = HTML.raw((CharSequence[])new CharSequence[]{text}).toPlainText();
        }
        return text;
    }

    public String getCssClass();

    public String getIconId();

    public String getTooltipText();

    public int getHorizontalAlignment();

    public String getBackgroundColor();

    public String getForegroundColor();

    public FontSpec getFont();

    public boolean isMandatory();

    public boolean isEditable();

    public boolean isHtmlEnabled();

    public ICellObserver getObserver();

    public IMultiStatus getErrorStatus();

    public boolean isContentValid();

    public boolean isMandatoryFulfilled();
}

