/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.client.ui.basic.planner;

import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.scout.rt.client.ui.AbstractEventBuffer;
import org.eclipse.scout.rt.client.ui.IWidget;
import org.eclipse.scout.rt.client.ui.action.menu.IMenu;
import org.eclipse.scout.rt.client.ui.action.menu.root.IContextMenuOwner;
import org.eclipse.scout.rt.client.ui.action.menu.root.IPlannerContextMenu;
import org.eclipse.scout.rt.client.ui.basic.planner.Activity;
import org.eclipse.scout.rt.client.ui.basic.planner.DisplayModeOptions;
import org.eclipse.scout.rt.client.ui.basic.planner.IPlannerUIFacade;
import org.eclipse.scout.rt.client.ui.basic.planner.PlannerEvent;
import org.eclipse.scout.rt.client.ui.basic.planner.PlannerListener;
import org.eclipse.scout.rt.client.ui.basic.planner.Resource;
import org.eclipse.scout.rt.platform.util.Range;
import org.eclipse.scout.rt.platform.util.event.IFastListenerList;

public interface IPlanner<RESOURCE_ID, ACTIVITY_ID>
extends IWidget,
IContextMenuOwner {
    public static final String PROP_VIEW_RANGE = "viewRange";
    public static final String PROP_SELECTION_RANGE = "selectionRange";
    public static final String PROP_LABEL = "label";
    public static final String PROP_HEADER_VISIBLE = "headerVisible";
    public static final String PROP_DISPLAY_MODE = "displayMode";
    public static final String PROP_DISPLAY_MODE_OPTIONS = "displayModeOptions";
    public static final String PROP_AVAILABLE_DISPLAY_MODES = "availableDisplayModes";
    public static final String PROP_SELECTION_MODE = "selectionMode";
    public static final String PROP_ACTIVITY_SELECTABLE = "activitySelectable";
    public static final String PROP_SELECTED_ACTIVITY = "selectedActivity";
    public static final String PROP_CONTEXT_MENU = "contextMenus";
    public static final int SELECTION_MODE_NONE = 0;
    public static final int SELECTION_MODE_SINGLE_RANGE = 1;
    public static final int SELECTION_MODE_MULTI_RANGE = 2;

    public IFastListenerList<PlannerListener> plannerListeners();

    default public void addPlannerListener(PlannerListener listener) {
        this.plannerListeners().add((Object)listener);
    }

    default public void removePlannerListener(PlannerListener listener) {
        this.plannerListeners().remove((Object)listener);
    }

    public boolean isPlannerChanging();

    public void setPlannerChanging(boolean var1);

    public String getLabel();

    public void setLabel(String var1);

    public Range<Date> getViewRange();

    public void setViewRange(Date var1, Date var2);

    public void setViewRange(Range<Date> var1);

    public int getDisplayMode();

    public void setDisplayMode(int var1);

    public Set<Integer> getAvailableDisplayModes();

    public void setAvailableDisplayModes(Set<Integer> var1);

    public Map<Integer, DisplayModeOptions> getDisplayModeOptions();

    public void setDisplayModeOptions(Map<Integer, DisplayModeOptions> var1);

    public void setDisplayModeOption(int var1, DisplayModeOptions var2);

    public boolean isHeaderVisible();

    public void setHeaderVisible(boolean var1);

    public int getSelectionMode();

    public void setSelectionMode(int var1);

    public boolean isActivitySelectable();

    public void setActivitySelectable(boolean var1);

    public Range<Date> getSelectionRange();

    public void setSelectionRange(Date var1, Date var2);

    public void setSelectionRange(Range<Date> var1);

    public Date getSelectedBeginTime();

    public Date getSelectedEndTime();

    public void decorateResource(Resource<RESOURCE_ID> var1);

    public void replaceResources(List<Resource<RESOURCE_ID>> var1);

    public void deleteResource(Resource<RESOURCE_ID> var1);

    public void deleteResources(List<Resource<RESOURCE_ID>> var1);

    public void deleteAllResources();

    public void addResources(List<Resource<RESOURCE_ID>> var1);

    public void addResource(Resource<RESOURCE_ID> var1);

    public List<Resource<RESOURCE_ID>> getResources();

    public void decorateActivity(Activity<RESOURCE_ID, ACTIVITY_ID> var1);

    public Activity<RESOURCE_ID, ACTIVITY_ID> getSelectedActivity();

    public void setSelectedActivity(Activity<RESOURCE_ID, ACTIVITY_ID> var1);

    public boolean isSelectedActivity(Activity<RESOURCE_ID, ACTIVITY_ID> var1);

    public Resource<RESOURCE_ID> getSelectedResource();

    public List<? extends Resource<RESOURCE_ID>> getSelectedResources();

    public List<RESOURCE_ID> getSelectedResourceIds();

    public boolean isSelectedResource(Resource<RESOURCE_ID> var1);

    public void selectResource(Resource<RESOURCE_ID> var1);

    public void selectResources(List<? extends Resource<RESOURCE_ID>> var1);

    public boolean deselectResource(Resource<RESOURCE_ID> var1);

    public boolean deselectResources(List<? extends Resource<RESOURCE_ID>> var1);

    public void deselectAllResources();

    public void setMenus(List<? extends IMenu> var1);

    public void addMenu(IMenu var1);

    @Override
    public IPlannerContextMenu getContextMenu();

    public AbstractEventBuffer<PlannerEvent> createEventBuffer();

    public IPlannerUIFacade getUIFacade();
}

