/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.client.ui.basic.table;

public class KeyStrokeBuffer {
    private final StringBuilder m_buf = new StringBuilder();
    private long m_lastActivity;
    private final long m_resetTimeoutMillis;

    public KeyStrokeBuffer(long resetTimeoutMillis) {
        this.m_resetTimeoutMillis = resetTimeoutMillis;
        this.m_lastActivity = System.currentTimeMillis();
    }

    public void append(String s) {
        this.checkTimeout();
        this.m_buf.append(s);
        this.m_lastActivity = System.currentTimeMillis();
    }

    public String getText() {
        this.checkTimeout();
        return this.m_buf.toString();
    }

    private void checkTimeout() {
        if (System.currentTimeMillis() - this.m_lastActivity >= this.m_resetTimeoutMillis) {
            this.m_buf.setLength(0);
        }
    }
}

