/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.client.ui.basic.table;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import org.eclipse.scout.rt.client.ui.AbstractEventBuffer;
import org.eclipse.scout.rt.client.ui.action.menu.IMenu;
import org.eclipse.scout.rt.client.ui.basic.table.ITableRow;
import org.eclipse.scout.rt.client.ui.basic.table.TableEvent;
import org.eclipse.scout.rt.client.ui.basic.table.columns.IColumn;
import org.eclipse.scout.rt.client.ui.dnd.TransferObject;
import org.eclipse.scout.rt.platform.util.Assertions;
import org.eclipse.scout.rt.platform.util.CollectionUtility;
import org.eclipse.scout.rt.platform.util.ObjectUtility;

public class TableEventBuffer
extends AbstractEventBuffer<TableEvent> {
    @Override
    protected List<TableEvent> coalesce(List<TableEvent> events) {
        this.removeObsolete(events);
        this.replacePrevious(events, 100, 101);
        this.removeEmptyEvents(events);
        this.removeIdenticalEvents(events);
        this.coalesceSameType(events);
        this.removeIdenticalEvents(events);
        this.applyRowOrderChangedToRowsInserted(events);
        return events;
    }

    protected void removeObsolete(List<TableEvent> events) {
        if (events.size() < 2) {
            return;
        }
        HashSet<Integer> typesToDelete = new HashSet<Integer>();
        HashSet<Integer> typesToClear = new HashSet<Integer>();
        Set<Integer> rowRelatedEventTypes = this.getRowRelatedEvents();
        LinkedList<DeletedRowsRemover> deletedRowsRemoverList = new LinkedList<DeletedRowsRemover>();
        ListIterator<TableEvent> it = events.listIterator(events.size());
        while (it.hasPrevious()) {
            TableEvent event = it.previous();
            int type = event.getType();
            if (!deletedRowsRemoverList.isEmpty()) {
                Iterator removerIt = deletedRowsRemoverList.iterator();
                while (removerIt.hasNext()) {
                    DeletedRowsRemover remover = (DeletedRowsRemover)removerIt.next();
                    remover.removeDeletedRows(event);
                    if (this.isRowOrderUnchanged(type)) continue;
                    remover.complete();
                    removerIt.remove();
                }
            }
            if (typesToDelete.contains(type)) {
                it.remove();
                continue;
            }
            if (typesToClear.contains(type)) {
                event.clearRows();
            }
            if (type == 105) {
                for (Integer rowRelatedType : rowRelatedEventTypes) {
                    if (this.isRowsRequired(rowRelatedType) || rowRelatedType == 830) {
                        typesToDelete.add(rowRelatedType);
                        continue;
                    }
                    typesToClear.add(rowRelatedType);
                }
                continue;
            }
            if (type == 1) {
                typesToDelete.add(950);
                typesToDelete.add(960);
                typesToDelete.add(1);
                continue;
            }
            if (this.isIgnorePrevious(type)) {
                typesToDelete.add(type);
                continue;
            }
            if (type != 102 || !event.hasRows()) continue;
            deletedRowsRemoverList.add(new DeletedRowsRemover(event));
        }
        for (DeletedRowsRemover remover : deletedRowsRemoverList) {
            remover.complete();
        }
    }

    protected void replacePrevious(List<TableEvent> events, int oldType, int newType) {
        if (events.size() < 2) {
            return;
        }
        LinkedList<CommonRowsRemover> commonRowsRemovers = new LinkedList<CommonRowsRemover>();
        ListIterator<TableEvent> it = events.listIterator(events.size());
        while (it.hasPrevious()) {
            TableEvent event = it.previous();
            int type = event.getType();
            if (type == newType && event.hasRows()) {
                CommonRowsRemover remover = new CommonRowsRemover(event);
                commonRowsRemovers.add(remover);
            } else if (type == oldType && event.hasRows()) {
                for (CommonRowsRemover remover : commonRowsRemovers) {
                    remover.removeCommonRows(event);
                }
            }
            if (this.isRowOrderUnchanged(type)) continue;
            for (CommonRowsRemover remover : commonRowsRemovers) {
                remover.complete();
            }
            commonRowsRemovers.clear();
        }
        for (CommonRowsRemover remover : commonRowsRemovers) {
            remover.complete();
        }
    }

    protected void coalesceSameType(List<TableEvent> events) {
        if (events.size() < 2) {
            return;
        }
        HashMap<Integer, TableEvent> initialEventByType = new HashMap<Integer, TableEvent>();
        HashMap<Integer, TableEventMerger> eventMergerByType = new HashMap<Integer, TableEventMerger>();
        ListIterator<TableEvent> it = events.listIterator(events.size());
        while (it.hasPrevious()) {
            TableEvent event = it.previous();
            int type = event.getType();
            boolean rowRelatedEvent = this.isRowRelatedEvent(type);
            if (!initialEventByType.isEmpty()) {
                Iterator initialEventIt = initialEventByType.entrySet().iterator();
                while (initialEventIt.hasNext()) {
                    Map.Entry entry = initialEventIt.next();
                    int previousEventType = (Integer)entry.getKey();
                    if (type == previousEventType || rowRelatedEvent != this.isRowRelatedEvent(previousEventType)) continue;
                    initialEventIt.remove();
                    TableEventMerger eventMerger = (TableEventMerger)eventMergerByType.remove(previousEventType);
                    if (eventMerger == null) continue;
                    eventMerger.complete();
                }
            }
            if (!this.isCoalesceConsecutivePrevious(type)) continue;
            TableEvent initialEvent = (TableEvent)initialEventByType.get(type);
            if (initialEvent == null) {
                initialEventByType.put(type, event);
                continue;
            }
            TableEventMerger eventMerger = eventMergerByType.computeIfAbsent(type, k -> new TableEventMerger(initialEvent));
            eventMerger.merge(event);
            it.remove();
        }
        for (TableEventMerger eventMerger : eventMergerByType.values()) {
            eventMerger.complete();
        }
    }

    protected void applyRowOrderChangedToRowsInserted(List<TableEvent> events) {
        if (events.size() < 2) {
            return;
        }
        ArrayList<Integer> eventIndexesToDelete = new ArrayList<Integer>();
        ListIterator<TableEvent> it = events.listIterator(events.size());
        block0: while (it.hasPrevious()) {
            int eventIndex = it.previousIndex();
            TableEvent event = it.previous();
            if (event.getType() != 200) continue;
            while (it.hasPrevious()) {
                TableEvent previous = it.previous();
                if (previous.getType() == 100 && event.getRowCount() == previous.getRowCount() && CollectionUtility.equalsCollection(event.getRows(), previous.getRows(), (boolean)false)) {
                    previous.setRows(event.getRows());
                    eventIndexesToDelete.add(eventIndex);
                    continue block0;
                }
                if (this.isRowOrderUnchanged(previous.getType())) continue;
                if (previous.getType() != 200) continue block0;
                it.next();
                continue block0;
            }
        }
        if (eventIndexesToDelete.isEmpty()) {
            return;
        }
        it = events.listIterator(events.size());
        Iterator iterator = eventIndexesToDelete.iterator();
        block2: while (iterator.hasNext()) {
            int index = (Integer)iterator.next();
            while (it.hasPrevious()) {
                int currentEventIndex = it.previousIndex();
                it.previous();
                if (currentEventIndex != index) continue;
                it.remove();
                continue block2;
            }
        }
    }

    protected void removeEmptyEvents(List<TableEvent> events) {
        events.removeIf(event -> this.isRowsRequired(event.getType()) && !event.hasRows());
    }

    protected void removeIdenticalEvents(List<TableEvent> events) {
        if (events.size() < 2) {
            return;
        }
        HashMap<Integer, ArrayList<TableEvent>> predecessorEventsOfSameType = new HashMap<Integer, ArrayList<TableEvent>>();
        int currentEventGroupType = -1;
        ListIterator<TableEvent> it = events.listIterator();
        while (it.hasNext()) {
            TableEvent event = it.next();
            if (event.getType() != currentEventGroupType) {
                currentEventGroupType = event.getType();
                predecessorEventsOfSameType.clear();
                if (this.lookAheadEventType(it) != currentEventGroupType) continue;
                predecessorEventsOfSameType.put(this.identicalEventHashCode(event), CollectionUtility.arrayList((Object)event));
                continue;
            }
            boolean removed = false;
            int tableEventHashCode = this.identicalEventHashCode(event);
            ArrayList<TableEvent> identicalEventList = (ArrayList<TableEvent>)predecessorEventsOfSameType.get(tableEventHashCode);
            if (identicalEventList != null) {
                for (TableEvent predecessorEvent : identicalEventList) {
                    if (!this.isIdenticalEvent(event, predecessorEvent)) continue;
                    it.remove();
                    removed = true;
                    break;
                }
            }
            if (removed) continue;
            if (identicalEventList == null && this.lookAheadEventType(it) == currentEventGroupType) {
                identicalEventList = new ArrayList<TableEvent>();
                predecessorEventsOfSameType.put(tableEventHashCode, identicalEventList);
            }
            if (identicalEventList == null) continue;
            identicalEventList.add(event);
        }
    }

    protected int lookAheadEventType(ListIterator<TableEvent> it) {
        if (!it.hasNext()) {
            return -1;
        }
        try {
            int n = it.next().getType();
            return n;
        }
        finally {
            it.previous();
        }
    }

    protected int identicalEventHashCode(TableEvent event) {
        int result = 1;
        result = 31 * result + event.getType();
        result = 31 * result + (event.isConsumed() ? 1231 : 1237);
        result = 31 * result + (event.isSortInMemoryAllowed() ? 1231 : 1237);
        List<ITableRow> rows = event.getRows();
        result = 31 * result + (rows == null ? 0 : rows.hashCode());
        List<IMenu> popupMenus = event.getPopupMenus();
        result = 31 * result + (popupMenus == null ? 0 : popupMenus.hashCode());
        TransferObject dragObject = event.getDragObject();
        result = 31 * result + (dragObject == null ? 0 : dragObject.hashCode());
        TransferObject dropObject = event.getDropObject();
        result = 31 * result + (dropObject == null ? 0 : dropObject.hashCode());
        TransferObject copyObject = event.getCopyObject();
        result = 31 * result + (copyObject == null ? 0 : copyObject.hashCode());
        Collection<IColumn<?>> columns = event.getColumns();
        result = 31 * result + (columns == null ? 0 : columns.hashCode());
        return result;
    }

    @Override
    protected boolean isIdenticalEvent(TableEvent event1, TableEvent event2) {
        if (event1 == null && event2 == null) {
            return true;
        }
        if (event1 == null || event2 == null) {
            return false;
        }
        boolean identical = event1.getType() == event2.getType() && event1.isConsumed() == event2.isConsumed() && event1.isSortInMemoryAllowed() == event2.isSortInMemoryAllowed() && event1.getRowCount() == event2.getRowCount() && CollectionUtility.equalsCollection(event1.getRows(), event2.getRows()) && CollectionUtility.equalsCollection(event1.getPopupMenus(), event2.getPopupMenus()) && ObjectUtility.equals((Object)event1.getDragObject(), (Object)event2.getDragObject()) && ObjectUtility.equals((Object)event1.getDropObject(), (Object)event2.getDropObject()) && ObjectUtility.equals((Object)event1.getCopyObject(), (Object)event2.getCopyObject()) && ObjectUtility.equals(event1.getColumns(), event2.getColumns());
        return identical;
    }

    protected boolean isRowOrderUnchanged(int type) {
        switch (type) {
            case 1: 
            case 101: 
            case 103: 
            case 104: 
            case 770: 
            case 780: 
            case 810: 
            case 830: 
            case 850: {
                return true;
            }
        }
        return false;
    }

    protected Set<Integer> getRowRelatedEvents() {
        HashSet<Integer> res = new HashSet<Integer>();
        res.add(105);
        res.add(104);
        res.add(810);
        res.add(740);
        res.add(210);
        res.add(200);
        res.add(850);
        res.add(760);
        res.add(102);
        res.add(730);
        res.add(100);
        res.add(103);
        res.add(101);
        res.add(860);
        res.add(805);
        res.add(830);
        return res;
    }

    protected boolean isRowRelatedEvent(int type) {
        return this.getRowRelatedEvents().contains(type);
    }

    protected boolean isIgnorePrevious(int type) {
        switch (type) {
            case 1: 
            case 103: 
            case 105: 
            case 200: 
            case 730: 
            case 770: 
            case 830: {
                return true;
            }
        }
        return false;
    }

    protected boolean isCoalesceConsecutivePrevious(int type) {
        switch (type) {
            case 100: 
            case 101: 
            case 102: 
            case 780: 
            case 850: 
            case 950: 
            case 960: {
                return true;
            }
        }
        return false;
    }

    protected boolean isRowsRequired(int type) {
        switch (type) {
            case 100: 
            case 101: 
            case 102: 
            case 104: 
            case 200: 
            case 730: 
            case 740: 
            case 760: 
            case 805: 
            case 810: 
            case 860: {
                return true;
            }
        }
        return false;
    }

    protected static class CommonRowsRemover {
        private final TableEvent m_initialEvent;
        private final List<ITableRow> m_rows;

        public CommonRowsRemover(TableEvent initialEvent) {
            this.m_initialEvent = initialEvent;
            this.m_rows = new LinkedList<ITableRow>(this.m_initialEvent.getRows());
        }

        public void removeCommonRows(TableEvent event) {
            if (event == null || !event.hasRows() || this.m_rows.isEmpty()) {
                return;
            }
            this.m_rows.removeIf(event::containsRow);
        }

        public void complete() {
            if (this.m_rows.isEmpty()) {
                this.m_initialEvent.clearRows();
            } else {
                this.m_initialEvent.setRows(this.m_rows);
            }
        }
    }

    protected static class DeletedRowsRemover {
        private final TableEvent m_deleteEvent;
        private Set<ITableRow> m_rowsToRemove;
        private Set<ITableRow> m_removedRowsCollector;

        public DeletedRowsRemover(TableEvent deleteEvent) {
            this.m_deleteEvent = deleteEvent;
        }

        public void removeDeletedRows(TableEvent event) {
            if (200 != event.getType()) {
                this.ensureInitialized();
                event.removeRows(this.m_rowsToRemove, event.getType() == 100 ? this.m_removedRowsCollector : null);
            }
        }

        protected void ensureInitialized() {
            if (this.m_removedRowsCollector != null) {
                return;
            }
            this.m_rowsToRemove = this.m_deleteEvent.getRowsSet();
            this.m_removedRowsCollector = new HashSet<ITableRow>();
        }

        public void complete() {
            if (CollectionUtility.isEmpty(this.m_removedRowsCollector)) {
                return;
            }
            ArrayList<ITableRow> remainingRows = new ArrayList<ITableRow>();
            for (ITableRow row : this.m_deleteEvent.getRows()) {
                if (this.m_removedRowsCollector.contains(row)) continue;
                remainingRows.add(row);
            }
            this.m_deleteEvent.setRows(remainingRows);
        }
    }

    protected static class TableEventMerger {
        private final TableEvent m_targetEvent;
        private final Collection<IColumn<?>> m_targetColumns;
        private final Set<IColumn<?>> m_targetColumnSet;
        private final List<ITableRow> m_targetRows;
        private final Set<ITableRow> m_targetRowSet;
        private List<IColumn<?>> m_mergedColumns;
        private List<ITableRow> m_mergedRows;

        public TableEventMerger(TableEvent targetEvent) {
            Assertions.assertNotNull((Object)targetEvent, (String)"targetEvent must not be null", (Object[])new Object[0]);
            this.m_targetEvent = targetEvent;
            this.m_targetColumns = targetEvent.getColumns();
            this.m_targetColumnSet = new HashSet(this.m_targetColumns);
            this.m_mergedColumns = new LinkedList();
            this.m_targetRows = targetEvent.getRows();
            this.m_targetRowSet = new HashSet<ITableRow>(this.m_targetRows);
            this.m_mergedRows = new LinkedList<ITableRow>();
        }

        public void merge(TableEvent event) {
            if (this.m_mergedColumns == null || this.m_mergedRows == null) {
                throw new IllegalStateException("Invocations of merge is not allowed after complete has been invoked.");
            }
            this.mergeCollections(event.getColumns(), this.m_mergedColumns, this.m_targetColumnSet);
            this.mergeCollections(event.getRows(), this.m_mergedRows, this.m_targetRowSet);
        }

        public void complete() {
            if (this.m_mergedColumns == null || this.m_mergedRows == null) {
                return;
            }
            this.m_mergedColumns.addAll(this.m_targetColumns);
            this.m_targetEvent.setColumns(this.m_mergedColumns);
            this.m_mergedColumns = null;
            this.m_mergedRows.addAll(this.m_targetRows);
            this.m_targetEvent.setRows(this.m_mergedRows);
            this.m_mergedRows = null;
        }

        protected <TYPE> void mergeCollections(Collection<TYPE> source, List<TYPE> target, Set<TYPE> targetSet) {
            source.removeIf(sourceElement -> !targetSet.add(sourceElement));
            target.addAll(0, source);
        }
    }
}

