/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.client.ui.basic.table.columns;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.eclipse.scout.rt.client.ui.basic.table.columns.CompactLine;
import org.eclipse.scout.rt.platform.util.StringUtility;

public class CompactBean {
    private String m_title = "";
    private CompactLine m_titleLine;
    private String m_titleSuffix = "";
    private CompactLine m_titleSuffixLine;
    private String m_subtitle = "";
    private CompactLine m_subtitleLine;
    private String m_content = "";
    private String m_moreContent = "";
    private List<CompactLine> m_contentLines;
    private Map<Object, String> m_customData = new HashMap<Object, String>();

    public CompactBean() {
        this.m_contentLines = new ArrayList<CompactLine>();
    }

    public String getTitle() {
        return this.m_title;
    }

    public void setTitle(String title) {
        this.m_title = title;
    }

    public CompactLine getTitleLine() {
        return this.m_titleLine;
    }

    public void setTitleLine(CompactLine titleLine) {
        this.m_titleLine = titleLine;
    }

    public void setTitleSuffix(String titleSuffix) {
        this.m_titleSuffix = titleSuffix;
    }

    public String getTitleSuffix() {
        return this.m_titleSuffix;
    }

    public CompactLine getTitleSuffixLine() {
        return this.m_titleSuffixLine;
    }

    public void setTitleSuffixLine(CompactLine titleSuffixLine) {
        this.m_titleSuffixLine = titleSuffixLine;
    }

    public String getSubtitle() {
        return this.m_subtitle;
    }

    public void setSubtitle(String subtitle) {
        this.m_subtitle = subtitle;
    }

    public CompactLine getSubtitleLine() {
        return this.m_subtitleLine;
    }

    public void setSubtitleLine(CompactLine subtitleLine) {
        this.m_subtitleLine = subtitleLine;
    }

    public void addContentLine(CompactLine line) {
        this.m_contentLines.add(line);
    }

    public List<CompactLine> getContentLines() {
        return this.m_contentLines;
    }

    public String getContent() {
        return this.m_content;
    }

    public void setContent(String content) {
        this.m_content = content;
    }

    public String getMoreContent() {
        return this.m_moreContent;
    }

    public void setMoreContent(String moreContent) {
        this.m_moreContent = moreContent;
    }

    public Map<Object, String> getCustomData() {
        return this.m_customData;
    }

    public void setCustomData(Map<Object, String> customData) {
        this.m_customData = customData;
    }

    public void transform(boolean removeEmptyContentLines, int maxContentLines, boolean moreLinkAvailable) {
        int contentLineEnd;
        String content;
        CompactLine subtitleLine;
        CompactLine titleSuffixLine;
        CompactLine titleLine = this.getTitleLine();
        if (titleLine != null) {
            this.setTitle(titleLine.build());
        }
        if ((titleSuffixLine = this.getTitleSuffixLine()) != null) {
            this.setTitleSuffix(titleSuffixLine.build());
        }
        if ((subtitleLine = this.getSubtitleLine()) != null) {
            this.setSubtitle(subtitleLine.build());
        }
        List<CompactLine> contentLines = this.getContentLines();
        if (removeEmptyContentLines) {
            contentLines = contentLines.stream().filter(line -> !StringUtility.isNullOrEmpty((CharSequence)line.build())).collect(Collectors.toList());
        }
        if (moreLinkAvailable && maxContentLines + 1 == contentLines.size()) {
            ++maxContentLines;
        }
        if (!StringUtility.isNullOrEmpty((CharSequence)(content = StringUtility.join((String)"\n", (Collection)contentLines.subList(0, contentLineEnd = Math.min(contentLines.size(), maxContentLines)).stream().map(CompactLine::build).collect(Collectors.toList()))))) {
            this.setContent(content);
        }
        if (contentLineEnd < contentLines.size()) {
            String moreContent = StringUtility.join((String)"\n", (Collection)contentLines.subList(contentLineEnd, contentLines.size()).stream().map(CompactLine::build).collect(Collectors.toList()));
            this.setMoreContent(moreContent);
        }
    }
}

