/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.client.ui.basic.table.columns;

import java.util.function.Supplier;
import org.eclipse.scout.rt.client.ui.basic.cell.ICell;
import org.eclipse.scout.rt.client.ui.basic.table.IHeaderCell;
import org.eclipse.scout.rt.client.ui.basic.table.ITable;
import org.eclipse.scout.rt.client.ui.basic.table.ITableRow;
import org.eclipse.scout.rt.client.ui.basic.table.columns.CompactLine;
import org.eclipse.scout.rt.client.ui.basic.table.columns.IColumn;

public class CompactLineBuilder {
    private Supplier<IColumn<?>> m_columnSupplier;
    private IColumn<?> m_cachedColumn;
    private boolean m_showLabel;

    public CompactLineBuilder(Supplier<IColumn<?>> columnSupplier) {
        this.m_columnSupplier = columnSupplier;
        this.withShowLabel(true);
    }

    public CompactLineBuilder() {
        this(null);
    }

    public void prepare() {
        this.m_cachedColumn = null;
    }

    public Supplier<IColumn<?>> getColumnSupplier() {
        return this.m_columnSupplier;
    }

    public IColumn<?> getColumn() {
        if (this.m_cachedColumn != null) {
            return this.m_cachedColumn;
        }
        if (this.getColumnSupplier() == null) {
            return null;
        }
        this.m_cachedColumn = this.getColumnSupplier().get();
        return this.m_cachedColumn;
    }

    public CompactLineBuilder withShowLabel(boolean showLabel) {
        this.m_showLabel = showLabel;
        return this;
    }

    public boolean isShowLabel() {
        return this.m_showLabel;
    }

    public boolean accept(IColumn<?> column) {
        return this.getColumn() == column;
    }

    public CompactLine build(IColumn<?> column, ITableRow row) {
        IHeaderCell headerCell = null;
        if (this.isShowLabel()) {
            headerCell = column.getHeaderCell();
        }
        ICell cell = row.getCell(column);
        CompactLine line = new CompactLine(headerCell, cell);
        if (this.shouldConvertTextNlToBr(column.getTable())) {
            line.getTextBlock().setNlToBrEnabled(true);
        }
        return line;
    }

    protected boolean shouldConvertTextNlToBr(ITable table) {
        return !this.isShowLabel() && table.isMultilineText();
    }
}

